/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.bedwars.support.version.v1_18_R2;

import com.andrei1058.bedwars.api.arena.IArena;
import com.andrei1058.bedwars.api.arena.shop.ShopHolo;
import com.andrei1058.bedwars.api.arena.team.ITeam;
import com.andrei1058.bedwars.api.arena.team.TeamColor;
import com.andrei1058.bedwars.api.entity.Despawnable;
import com.andrei1058.bedwars.api.events.player.PlayerKillEvent;
import com.andrei1058.bedwars.api.language.Language;
import com.andrei1058.bedwars.api.language.Messages;
import com.andrei1058.bedwars.api.server.VersionSupport;
import com.andrei1058.bedwars.support.version.common.VersionCommon;
import com.andrei1058.bedwars.support.version.v1_18_R2.IGolem;
import com.andrei1058.bedwars.support.version.v1_18_R2.Silverfish;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3fa;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleParamRedstone;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutChat;
import net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy;
import net.minecraft.network.protocol.game.PacketPlayOutEntityEquipment;
import net.minecraft.network.protocol.game.PacketPlayOutEntityHeadRotation;
import net.minecraft.network.protocol.game.PacketPlayOutEntityVelocity;
import net.minecraft.network.protocol.game.PacketPlayOutNamedEntitySpawn;
import net.minecraft.network.protocol.game.PacketPlayOutWorldParticles;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemAxe;
import net.minecraft.world.item.ItemBow;
import net.minecraft.world.item.ItemElytra;
import net.minecraft.world.item.ItemSword;
import net.minecraft.world.item.ItemTool;
import net.minecraft.world.level.IMaterial;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBase;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Bed;
import org.bukkit.block.data.type.Ladder;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.command.Command;
import org.bukkit.craftbukkit.v1_18_R2.CraftServer;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftFireball;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_18_R2.entity.CraftTNTPrimed;
import org.bukkit.craftbukkit.v1_18_R2.inventory.CraftItemStack;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Player;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.entity.Villager;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scoreboard.Team;
import org.bukkit.util.Vector;
import org.jetbrains.annotations.NotNull;

public class v1_18_R2
extends VersionSupport {
    private static final UUID chatUUID = new UUID(0L, 0L);

    public v1_18_R2(Plugin plugin, String name) {
        super(plugin, name);
        this.loadDefaultEffects();
    }

    @Override
    public void registerVersionListeners() {
        new VersionCommon(this);
    }

    @Override
    public void registerCommand(String name, Command clasa) {
        ((CraftServer)this.getPlugin().getServer()).getCommandMap().register(name, clasa);
    }

    @Override
    public String getTag(ItemStack itemStack, String key) {
        net.minecraft.world.item.ItemStack i = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tag = i.t();
        return tag == null ? null : (tag.e(key) ? tag.l(key) : null);
    }

    @Override
    public void sendTitle(Player p, String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        p.sendTitle(title == null ? " " : title, subtitle == null ? " " : subtitle, fadeIn, stay, fadeOut);
    }

    @Override
    public void spawnSilverfish(Location loc, ITeam bedWarsTeam, double speed, double health, int despawn, double damage) {
        new Despawnable(Silverfish.spawn(loc, bedWarsTeam, speed, health, despawn, damage), bedWarsTeam, despawn, Messages.SHOP_UTILITY_NPC_SILVERFISH_NAME, PlayerKillEvent.PlayerKillCause.SILVERFISH_FINAL_KILL, PlayerKillEvent.PlayerKillCause.SILVERFISH);
    }

    @Override
    public void spawnIronGolem(Location loc, ITeam bedWarsTeam, double speed, double health, int despawn) {
        new Despawnable(IGolem.spawn(loc, bedWarsTeam, speed, health, despawn), bedWarsTeam, despawn, Messages.SHOP_UTILITY_NPC_IRON_GOLEM_NAME, PlayerKillEvent.PlayerKillCause.IRON_GOLEM_FINAL_KILL, PlayerKillEvent.PlayerKillCause.IRON_GOLEM);
    }

    @Override
    public void playAction(Player p, String text) {
        CraftPlayer cPlayer = (CraftPlayer)p;
        IChatMutableComponent cbc = IChatBaseComponent.ChatSerializer.a((String)("{\"text\": \"" + text + "\"}"));
        PacketPlayOutChat ppoc = new PacketPlayOutChat((IChatBaseComponent)cbc, ChatMessageType.c, chatUUID);
        cPlayer.getHandle().b.a((Packet)ppoc);
    }

    @Override
    public boolean isBukkitCommandRegistered(String name) {
        return ((CraftServer)this.getPlugin().getServer()).getCommandMap().getCommand(name) != null;
    }

    @Override
    public ItemStack getItemInHand(Player p) {
        return p.getInventory().getItemInMainHand();
    }

    @Override
    public void hideEntity(Entity e, Player p) {
        PacketPlayOutEntityDestroy packet = new PacketPlayOutEntityDestroy(new int[]{e.getEntityId()});
        ((CraftPlayer)p).getHandle().b.a((Packet)packet);
    }

    @Override
    public void minusAmount(Player p, ItemStack i, int amount) {
        if (i.getAmount() - amount <= 0) {
            if (p.getInventory().getItemInOffHand().equals((Object)i)) {
                p.getInventory().setItemInOffHand(null);
            } else {
                p.getInventory().removeItem(new ItemStack[]{i});
            }
            return;
        }
        i.setAmount(i.getAmount() - amount);
        p.updateInventory();
    }

    @Override
    public void setSource(TNTPrimed tnt, Player owner) {
        EntityLiving nmsEntityLiving = ((CraftLivingEntity)owner).getHandle();
        EntityTNTPrimed nmsTNT = ((CraftTNTPrimed)tnt).getHandle();
        try {
            Field sourceField = EntityTNTPrimed.class.getDeclaredField("d");
            sourceField.setAccessible(true);
            sourceField.set(nmsTNT, nmsEntityLiving);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public boolean isArmor(ItemStack itemStack) {
        if (CraftItemStack.asNMSCopy((ItemStack)itemStack) == null) {
            return false;
        }
        if (CraftItemStack.asNMSCopy((ItemStack)itemStack).c() == null) {
            return false;
        }
        return CraftItemStack.asNMSCopy((ItemStack)itemStack).c() instanceof ItemArmor || CraftItemStack.asNMSCopy((ItemStack)itemStack).c() instanceof ItemElytra;
    }

    @Override
    public boolean isTool(ItemStack itemStack) {
        if (CraftItemStack.asNMSCopy((ItemStack)itemStack) == null) {
            return false;
        }
        if (CraftItemStack.asNMSCopy((ItemStack)itemStack).c() == null) {
            return false;
        }
        return CraftItemStack.asNMSCopy((ItemStack)itemStack).c() instanceof ItemTool;
    }

    @Override
    public boolean isSword(ItemStack itemStack) {
        if (CraftItemStack.asNMSCopy((ItemStack)itemStack) == null) {
            return false;
        }
        if (CraftItemStack.asNMSCopy((ItemStack)itemStack).c() == null) {
            return false;
        }
        return CraftItemStack.asNMSCopy((ItemStack)itemStack).c() instanceof ItemSword;
    }

    @Override
    public boolean isAxe(ItemStack itemStack) {
        if (CraftItemStack.asNMSCopy((ItemStack)itemStack).c() == null) {
            return false;
        }
        return CraftItemStack.asNMSCopy((ItemStack)itemStack).c() instanceof ItemAxe;
    }

    @Override
    public boolean isBow(ItemStack itemStack) {
        if (CraftItemStack.asNMSCopy((ItemStack)itemStack) == null) {
            return false;
        }
        if (CraftItemStack.asNMSCopy((ItemStack)itemStack).c() == null) {
            return false;
        }
        return CraftItemStack.asNMSCopy((ItemStack)itemStack).c() instanceof ItemBow;
    }

    @Override
    public boolean isProjectile(ItemStack itemStack) {
        if (CraftItemStack.asNMSCopy((ItemStack)itemStack) == null) {
            return false;
        }
        if (CraftItemStack.asNMSCopy((ItemStack)itemStack).F() == null) {
            return false;
        }
        return CraftItemStack.asNMSCopy((ItemStack)itemStack).F() instanceof IProjectile;
    }

    @Override
    public boolean isInvisibilityPotion(ItemStack itemStack) {
        if (!itemStack.getType().equals((Object)Material.POTION)) {
            return false;
        }
        PotionMeta pm = (PotionMeta)itemStack.getItemMeta();
        return pm != null && pm.hasCustomEffects() && pm.hasCustomEffect(PotionEffectType.INVISIBILITY);
    }

    @Override
    public void registerEntities() {
    }

    @Override
    public void spawnShop(@NotNull Location loc, String name1, List<Player> players, IArena arena) {
        Location l = loc.clone();
        if (l.getWorld() == null) {
            return;
        }
        Villager vlg = (Villager)l.getWorld().spawnEntity(loc, EntityType.VILLAGER);
        vlg.setAI(false);
        vlg.setRemoveWhenFarAway(false);
        vlg.setCollidable(false);
        vlg.setInvulnerable(true);
        vlg.setSilent(true);
        for (Player p : players) {
            ArmorStand a2;
            String[] nume = Language.getMsg(p, name1).split(",");
            if (nume.length == 1) {
                a2 = v1_18_R2.createArmorStand(nume[0], l.clone().add(0.0, 1.85, 0.0));
                new ShopHolo(Language.getPlayerLanguage(p).getIso(), a2, null, l, arena);
                continue;
            }
            a2 = v1_18_R2.createArmorStand(nume[0], l.clone().add(0.0, 2.1, 0.0));
            ArmorStand b2 = v1_18_R2.createArmorStand(nume[1], l.clone().add(0.0, 1.85, 0.0));
            new ShopHolo(Language.getPlayerLanguage(p).getIso(), a2, b2, l, arena);
        }
        for (ShopHolo sh : ShopHolo.getShopHolo()) {
            if (sh.getA() != arena) continue;
            sh.update();
        }
    }

    @Override
    public double getDamage(ItemStack i) {
        net.minecraft.world.item.ItemStack nmsStack = CraftItemStack.asNMSCopy((ItemStack)i);
        NBTTagCompound compound = nmsStack.t() != null ? nmsStack.t() : new NBTTagCompound();
        return compound.k("generic.attackDamage");
    }

    private static ArmorStand createArmorStand(String name, Location loc) {
        if (loc == null) {
            return null;
        }
        if (loc.getWorld() == null) {
            return null;
        }
        ArmorStand a2 = (ArmorStand)loc.getWorld().spawn(loc, ArmorStand.class);
        a2.setGravity(false);
        a2.setVisible(false);
        a2.setCustomNameVisible(true);
        a2.setCustomName(name);
        return a2;
    }

    @Override
    public void voidKill(Player p) {
        ((CraftPlayer)p).getHandle().a(DamageSource.m, 1000.0f);
    }

    @Override
    public void hideArmor(Player victim, Player receiver) {
        ArrayList<Pair> items = new ArrayList<Pair>();
        ArrayList<Pair> hands = new ArrayList<Pair>();
        hands.add(new Pair((Object)EnumItemSlot.a, (Object)new net.minecraft.world.item.ItemStack((IMaterial)Item.b((int)0))));
        hands.add(new Pair((Object)EnumItemSlot.b, (Object)new net.minecraft.world.item.ItemStack((IMaterial)Item.b((int)0))));
        items.add(new Pair((Object)EnumItemSlot.f, (Object)new net.minecraft.world.item.ItemStack((IMaterial)Item.b((int)0))));
        items.add(new Pair((Object)EnumItemSlot.e, (Object)new net.minecraft.world.item.ItemStack((IMaterial)Item.b((int)0))));
        items.add(new Pair((Object)EnumItemSlot.d, (Object)new net.minecraft.world.item.ItemStack((IMaterial)Item.b((int)0))));
        items.add(new Pair((Object)EnumItemSlot.c, (Object)new net.minecraft.world.item.ItemStack((IMaterial)Item.b((int)0))));
        PacketPlayOutEntityEquipment packet1 = new PacketPlayOutEntityEquipment(victim.getEntityId(), items);
        PacketPlayOutEntityEquipment packet2 = new PacketPlayOutEntityEquipment(victim.getEntityId(), hands);
        EntityPlayer pc = ((CraftPlayer)receiver).getHandle();
        if (victim != receiver) {
            pc.b.a((Packet)packet2);
        }
        pc.b.a((Packet)packet1);
    }

    @Override
    public void showArmor(Player victim, Player receiver) {
        ArrayList<Pair> items = new ArrayList<Pair>();
        ArrayList<Pair> hands = new ArrayList<Pair>();
        hands.add(new Pair((Object)EnumItemSlot.a, (Object)CraftItemStack.asNMSCopy((ItemStack)victim.getInventory().getItemInMainHand())));
        hands.add(new Pair((Object)EnumItemSlot.b, (Object)CraftItemStack.asNMSCopy((ItemStack)victim.getInventory().getItemInOffHand())));
        items.add(new Pair((Object)EnumItemSlot.f, (Object)CraftItemStack.asNMSCopy((ItemStack)victim.getInventory().getHelmet())));
        items.add(new Pair((Object)EnumItemSlot.e, (Object)CraftItemStack.asNMSCopy((ItemStack)victim.getInventory().getChestplate())));
        items.add(new Pair((Object)EnumItemSlot.d, (Object)CraftItemStack.asNMSCopy((ItemStack)victim.getInventory().getLeggings())));
        items.add(new Pair((Object)EnumItemSlot.c, (Object)CraftItemStack.asNMSCopy((ItemStack)victim.getInventory().getBoots())));
        PacketPlayOutEntityEquipment packet1 = new PacketPlayOutEntityEquipment(victim.getEntityId(), items);
        PacketPlayOutEntityEquipment packet2 = new PacketPlayOutEntityEquipment(victim.getEntityId(), hands);
        EntityPlayer pc = ((CraftPlayer)receiver).getHandle();
        if (victim != receiver) {
            pc.b.a((Packet)packet2);
        }
        pc.b.a((Packet)packet1);
    }

    @Override
    public void spawnDragon(Location l, ITeam bwt) {
        if (l == null || l.getWorld() == null) {
            this.getPlugin().getLogger().log(Level.WARNING, "Could not spawn Dragon. Location is null");
            return;
        }
        EnderDragon ed = (EnderDragon)l.getWorld().spawnEntity(l, EntityType.ENDER_DRAGON);
        ed.setPhase(EnderDragon.Phase.CIRCLING);
    }

    @Override
    public void colorBed(ITeam bwt) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                BlockState bed = bwt.getBed().clone().add((double)x, 0.0, (double)z).getBlock().getState();
                if (!(bed instanceof Bed)) continue;
                bed.setType(bwt.getColor().bedMaterial());
                bed.update();
            }
        }
    }

    @Override
    public void registerTntWhitelist() {
        try {
            Field field = BlockBase.class.getDeclaredField("aH");
            field.setAccessible(true);
            field.set(Blocks.eq, Float.valueOf(300.0f));
            field.set(Blocks.bQ, Float.valueOf(300.0f));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setBlockTeamColor(Block block, TeamColor teamColor) {
        if (block.getType().toString().contains("STAINED_GLASS") || block.getType().toString().equals("GLASS")) {
            block.setType(teamColor.glassMaterial());
        } else if (block.getType().toString().contains("_TERRACOTTA")) {
            block.setType(teamColor.glazedTerracottaMaterial());
        } else if (block.getType().toString().contains("_WOOL")) {
            block.setType(teamColor.woolMaterial());
        }
    }

    @Override
    public void setCollide(Player p, IArena a2, boolean value) {
        p.setCollidable(value);
        if (a2 == null) {
            return;
        }
        a2.updateSpectatorCollideRule(p, value);
    }

    @Override
    public ItemStack addCustomData(ItemStack i, String data) {
        net.minecraft.world.item.ItemStack itemStack = CraftItemStack.asNMSCopy((ItemStack)i);
        NBTTagCompound tag = itemStack.t();
        if (tag == null) {
            tag = new NBTTagCompound();
            itemStack.c(tag);
        }
        tag.a("BedWars1058", data);
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)itemStack);
    }

    @Override
    public ItemStack setTag(ItemStack itemStack, String key, String value) {
        net.minecraft.world.item.ItemStack is = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tag = is.t();
        if (tag == null) {
            tag = new NBTTagCompound();
            is.c(tag);
        }
        tag.a(key, value);
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)is);
    }

    @Override
    public boolean isCustomBedWarsItem(ItemStack i) {
        net.minecraft.world.item.ItemStack itemStack = CraftItemStack.asNMSCopy((ItemStack)i);
        NBTTagCompound tag = itemStack.t();
        if (tag == null) {
            return false;
        }
        return tag.e("BedWars1058");
    }

    @Override
    public String getCustomData(ItemStack i) {
        net.minecraft.world.item.ItemStack itemStack = CraftItemStack.asNMSCopy((ItemStack)i);
        NBTTagCompound tag = itemStack.t();
        if (tag == null) {
            return "";
        }
        return tag.l("BedWars1058");
    }

    @Override
    public ItemStack colourItem(ItemStack itemStack, ITeam bedWarsTeam) {
        if (itemStack == null) {
            return null;
        }
        String type = itemStack.getType().toString();
        if (type.contains("_BED")) {
            return new ItemStack(bedWarsTeam.getColor().bedMaterial(), itemStack.getAmount());
        }
        if (type.contains("_STAINED_GLASS_PANE")) {
            return new ItemStack(bedWarsTeam.getColor().glassPaneMaterial(), itemStack.getAmount());
        }
        if (type.contains("STAINED_GLASS") || type.equals("GLASS")) {
            return new ItemStack(bedWarsTeam.getColor().glassMaterial(), itemStack.getAmount());
        }
        if (type.contains("_TERRACOTTA")) {
            return new ItemStack(bedWarsTeam.getColor().glazedTerracottaMaterial(), itemStack.getAmount());
        }
        if (type.contains("_WOOL")) {
            return new ItemStack(bedWarsTeam.getColor().woolMaterial(), itemStack.getAmount());
        }
        return itemStack;
    }

    @Override
    public ItemStack createItemStack(String material, int amount, short data) {
        ItemStack i;
        try {
            i = new ItemStack(Material.valueOf((String)material), amount);
        }
        catch (Exception ex) {
            this.getPlugin().getLogger().log(Level.WARNING, material + " is not a valid " + v1_18_R2.getName() + " material!");
            i = new ItemStack(Material.BEDROCK);
        }
        return i;
    }

    @Override
    public void teamCollideRule(Team team) {
        team.setOption(Team.Option.COLLISION_RULE, Team.OptionStatus.NEVER);
        team.setCanSeeFriendlyInvisibles(true);
    }

    @Override
    public Material materialFireball() {
        return Material.FIRE_CHARGE;
    }

    @Override
    public Material materialPlayerHead() {
        return Material.PLAYER_HEAD;
    }

    @Override
    public Material materialSnowball() {
        return Material.SNOWBALL;
    }

    @Override
    public Material materialGoldenHelmet() {
        return Material.GOLDEN_HELMET;
    }

    @Override
    public Material materialGoldenChestPlate() {
        return Material.GOLDEN_CHESTPLATE;
    }

    @Override
    public Material materialGoldenLeggings() {
        return Material.GOLDEN_LEGGINGS;
    }

    @Override
    public Material materialNetheriteHelmet() {
        return Material.NETHERITE_HELMET;
    }

    @Override
    public Material materialNetheriteChestPlate() {
        return Material.NETHERITE_CHESTPLATE;
    }

    @Override
    public Material materialNetheriteLeggings() {
        return Material.NETHERITE_LEGGINGS;
    }

    @Override
    public Material materialElytra() {
        return Material.ELYTRA;
    }

    @Override
    public Material materialCake() {
        return Material.CAKE;
    }

    @Override
    public Material materialCraftingTable() {
        return Material.CRAFTING_TABLE;
    }

    @Override
    public Material materialEnchantingTable() {
        return Material.ENCHANTING_TABLE;
    }

    @Override
    public Material woolMaterial() {
        return Material.WHITE_WOOL;
    }

    @Override
    public String getShopUpgradeIdentifier(ItemStack itemStack) {
        net.minecraft.world.item.ItemStack i = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tag = i.t();
        return tag == null ? "null" : (tag.e("tierIdentifier") ? tag.l("tierIdentifier") : "null");
    }

    @Override
    public ItemStack setShopUpgradeIdentifier(ItemStack itemStack, String identifier) {
        net.minecraft.world.item.ItemStack i = CraftItemStack.asNMSCopy((ItemStack)itemStack);
        NBTTagCompound tag = i.t();
        if (tag == null) {
            tag = new NBTTagCompound();
            i.c(tag);
        }
        tag.a("tierIdentifier", identifier);
        return CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)i);
    }

    @Override
    public ItemStack getPlayerHead(Player player, ItemStack copyTagFrom) {
        ItemMeta meta;
        ItemStack head = new ItemStack(this.materialPlayerHead());
        if (copyTagFrom != null) {
            net.minecraft.world.item.ItemStack i = CraftItemStack.asNMSCopy((ItemStack)head);
            i.c(CraftItemStack.asNMSCopy((ItemStack)copyTagFrom).t());
            head = CraftItemStack.asBukkitCopy((net.minecraft.world.item.ItemStack)i);
        }
        if ((meta = head.getItemMeta()) instanceof SkullMeta) {
            ((SkullMeta)meta).setOwnerProfile(player.getPlayerProfile());
        }
        return head;
    }

    @Override
    public void sendPlayerSpawnPackets(Player respawned, IArena arena) {
        EntityPlayer boundTo;
        if (respawned == null) {
            return;
        }
        if (arena == null) {
            return;
        }
        if (!arena.isPlayer(respawned)) {
            return;
        }
        if (arena.getRespawnSessions().containsKey(respawned)) {
            return;
        }
        EntityPlayer entityPlayer = ((CraftPlayer)respawned).getHandle();
        PacketPlayOutNamedEntitySpawn show = new PacketPlayOutNamedEntitySpawn((EntityHuman)entityPlayer);
        PacketPlayOutEntityVelocity playerVelocity = new PacketPlayOutEntityVelocity((net.minecraft.world.entity.Entity)entityPlayer);
        PacketPlayOutEntityHeadRotation head = new PacketPlayOutEntityHeadRotation((net.minecraft.world.entity.Entity)entityPlayer, this.getCompressedAngle(entityPlayer.getBukkitYaw()));
        ArrayList<Pair> list = new ArrayList<Pair>();
        list.add(new Pair((Object)EnumItemSlot.a, (Object)entityPlayer.b(EnumItemSlot.a)));
        list.add(new Pair((Object)EnumItemSlot.b, (Object)entityPlayer.b(EnumItemSlot.b)));
        list.add(new Pair((Object)EnumItemSlot.f, (Object)entityPlayer.b(EnumItemSlot.f)));
        list.add(new Pair((Object)EnumItemSlot.e, (Object)entityPlayer.b(EnumItemSlot.e)));
        list.add(new Pair((Object)EnumItemSlot.d, (Object)entityPlayer.b(EnumItemSlot.d)));
        list.add(new Pair((Object)EnumItemSlot.c, (Object)entityPlayer.b(EnumItemSlot.c)));
        for (Player p : arena.getPlayers()) {
            if (p == null || p.equals(respawned) || arena.getRespawnSessions().containsKey(p)) continue;
            boundTo = ((CraftPlayer)p).getHandle();
            if (!p.getWorld().equals(respawned.getWorld()) || !(respawned.getLocation().distance(p.getLocation()) <= (double)arena.getRenderDistance())) continue;
            boundTo.b.a((Packet)show);
            boundTo.b.a((Packet)head);
            boundTo.b.a((Packet)playerVelocity);
            boundTo.b.a((Packet)new PacketPlayOutEntityEquipment(respawned.getEntityId(), list));
            if (p.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
                this.hideArmor(p, respawned);
                continue;
            }
            PacketPlayOutNamedEntitySpawn show2 = new PacketPlayOutNamedEntitySpawn((EntityHuman)boundTo);
            PacketPlayOutEntityVelocity playerVelocity2 = new PacketPlayOutEntityVelocity((net.minecraft.world.entity.Entity)boundTo);
            PacketPlayOutEntityHeadRotation head2 = new PacketPlayOutEntityHeadRotation((net.minecraft.world.entity.Entity)boundTo, this.getCompressedAngle(boundTo.getBukkitYaw()));
            entityPlayer.b.a((Packet)show2);
            entityPlayer.b.a((Packet)playerVelocity2);
            entityPlayer.b.a((Packet)head2);
            this.showArmor(p, respawned);
        }
        for (Player spectator : arena.getSpectators()) {
            if (spectator == null || spectator.equals(respawned)) continue;
            boundTo = ((CraftPlayer)spectator).getHandle();
            respawned.hidePlayer(this.getPlugin(), spectator);
            if (!spectator.getWorld().equals(respawned.getWorld()) || !(respawned.getLocation().distance(spectator.getLocation()) <= (double)arena.getRenderDistance())) continue;
            boundTo.b.a((Packet)show);
            boundTo.b.a((Packet)playerVelocity);
            boundTo.b.a((Packet)new PacketPlayOutEntityEquipment(respawned.getEntityId(), list));
            boundTo.b.a((Packet)new PacketPlayOutEntityHeadRotation((net.minecraft.world.entity.Entity)entityPlayer, this.getCompressedAngle(entityPlayer.getBukkitYaw())));
        }
    }

    @Override
    public String getInventoryName(InventoryEvent e) {
        return e.getView().getTitle();
    }

    @Override
    public void setUnbreakable(ItemMeta itemMeta) {
        itemMeta.setUnbreakable(true);
    }

    @Override
    public String getMainLevel() {
        return ((DedicatedServer)MinecraftServer.getServer()).y.a().p;
    }

    @Override
    public int getVersion() {
        return 8;
    }

    @Override
    public void setJoinSignBackground(BlockState b2, Material material) {
        if (b2.getBlockData() instanceof WallSign) {
            b2.getBlock().getRelative(((WallSign)b2.getBlockData()).getFacing().getOppositeFace()).setType(material);
        }
    }

    @Override
    public void spigotShowPlayer(Player victim, Player receiver) {
        receiver.showPlayer(this.getPlugin(), victim);
    }

    @Override
    public void spigotHidePlayer(Player victim, Player receiver) {
        receiver.hidePlayer(this.getPlugin(), victim);
    }

    @Override
    public Fireball setFireballDirection(Fireball fireball, Vector vector) {
        EntityFireball fb = ((CraftFireball)fireball).getHandle();
        fb.b = vector.getX() * 0.1;
        fb.c = vector.getY() * 0.1;
        fb.d = vector.getZ() * 0.1;
        return (Fireball)fb.getBukkitEntity();
    }

    @Override
    public void playRedStoneDot(Player player) {
        Color color = Color.RED;
        PacketPlayOutWorldParticles particlePacket = new PacketPlayOutWorldParticles((ParticleParam)new ParticleParamRedstone(new Vector3fa((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue()), 1.0f), true, player.getLocation().getX(), player.getLocation().getY() + 2.6, player.getLocation().getZ(), 0.0f, 0.0f, 0.0f, 0.0f, 0);
        for (Player inWorld : player.getWorld().getPlayers()) {
            if (inWorld.equals(player)) continue;
            ((CraftPlayer)inWorld).getHandle().b.a((Packet)particlePacket);
        }
    }

    @Override
    public void clearArrowsFromPlayerBody(Player player) {
    }

    @Override
    public void placeTowerBlocks(@NotNull Block b2, @NotNull IArena a2, @NotNull TeamColor color, int x, int y, int z) {
        b2.getRelative(x, y, z).setType(color.woolMaterial());
        a2.addPlacedBlock(b2.getRelative(x, y, z));
    }

    @Override
    public void placeLadder(@NotNull Block b2, int x, int y, int z, @NotNull IArena a2, int ladderData) {
        Block block = b2.getRelative(x, y, z);
        block.setType(Material.LADDER);
        Ladder ladder = (Ladder)block.getBlockData();
        a2.addPlacedBlock(block);
        switch (ladderData) {
            case 2: {
                ladder.setFacing(BlockFace.NORTH);
                block.setBlockData((BlockData)ladder);
                break;
            }
            case 3: {
                ladder.setFacing(BlockFace.SOUTH);
                block.setBlockData((BlockData)ladder);
                break;
            }
            case 4: {
                ladder.setFacing(BlockFace.WEST);
                block.setBlockData((BlockData)ladder);
                break;
            }
            case 5: {
                ladder.setFacing(BlockFace.EAST);
                block.setBlockData((BlockData)ladder);
            }
        }
    }

    @Override
    public void playVillagerEffect(@NotNull Player player, Location location) {
        player.spawnParticle(Particle.VILLAGER_HAPPY, location, 1);
    }
}

