/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.bedwars.sidebar;

import com.andrei1058.bedwars.BedWars;
import com.andrei1058.bedwars.api.arena.GameState;
import com.andrei1058.bedwars.api.arena.IArena;
import com.andrei1058.bedwars.api.arena.team.ITeam;
import com.andrei1058.bedwars.api.events.sidebar.PlayerSidebarInitEvent;
import com.andrei1058.bedwars.api.language.Language;
import com.andrei1058.bedwars.api.language.Messages;
import com.andrei1058.bedwars.api.server.ServerType;
import com.andrei1058.bedwars.api.sidebar.ISidebar;
import com.andrei1058.bedwars.api.sidebar.ISidebarService;
import com.andrei1058.bedwars.libs.sidebar.SidebarManager;
import com.andrei1058.bedwars.sidebar.BwSidebar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SidebarService
implements ISidebarService {
    private static SidebarService instance;
    private final SidebarManager sidebarHandler;
    private final HashMap<UUID, BwSidebar> sidebars = new HashMap();

    public static boolean init() {
        if (null == instance) {
            instance = new SidebarService();
        }
        return SidebarService.instance.sidebarHandler != null;
    }

    private SidebarService() {
        this.sidebarHandler = SidebarManager.init();
    }

    @Override
    public void giveSidebar(@NotNull Player player, @Nullable IArena arena, boolean delay) {
        BwSidebar sidebar = this.sidebars.getOrDefault(player.getUniqueId(), null);
        if (null != sidebar) {
            if (null == arena) {
                if (!BedWars.config.getBoolean("scoreboard-settings.sidebar.enable-lobby-sidebar")) {
                    this.remove(sidebar);
                    return;
                }
            } else if (!BedWars.config.getBoolean("scoreboard-settings.sidebar.enable-game-sidebar")) {
                this.remove(sidebar);
                return;
            }
        }
        if (!BedWars.config.getBoolean("scoreboard-settings.sidebar.enable-lobby-sidebar") && null == arena) {
            return;
        }
        if (!BedWars.config.getBoolean("scoreboard-settings.sidebar.enable-game-sidebar") && null != arena) {
            return;
        }
        List<String> lines = null;
        if (null == arena) {
            if (BedWars.getServerType() != ServerType.SHARED) {
                lines = Language.getList(player, Messages.SCOREBOARD_LOBBY);
            }
        } else if (arena.getStatus() == GameState.waiting) {
            lines = Language.getScoreboard(player, "scoreboard." + arena.getGroup() + ".waiting", Messages.SCOREBOARD_DEFAULT_WAITING);
        } else if (arena.getStatus() == GameState.starting) {
            lines = Language.getScoreboard(player, "scoreboard." + arena.getGroup() + ".starting", Messages.SCOREBOARD_DEFAULT_STARTING);
        } else if (arena.getStatus() == GameState.playing || arena.getStatus() == GameState.restarting) {
            lines = Language.getScoreboard(player, "scoreboard." + arena.getGroup() + ".playing", Messages.SCOREBOARD_DEFAULT_PLAYING);
        }
        if (null == lines || lines.isEmpty()) {
            if (null != sidebar) {
                this.remove(sidebar);
            }
            return;
        }
        ArrayList<String> title = new ArrayList<String>(Arrays.asList(lines.get(0).split(",")));
        if (lines.size() == 1) {
            lines = new ArrayList<String>();
        }
        lines = lines.subList(1, lines.size());
        boolean newlyAdded = false;
        if (null == sidebar) {
            sidebar = new BwSidebar(player);
            newlyAdded = true;
            PlayerSidebarInitEvent event = new PlayerSidebarInitEvent(player, sidebar);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.isCancelled()) {
                return;
            }
        }
        sidebar.setContent(title, lines, arena);
        if (newlyAdded) {
            this.sidebars.put(player.getUniqueId(), sidebar);
        }
    }

    public void remove(@NotNull BwSidebar sidebar) {
        this.sidebars.remove(sidebar.getPlayer().getUniqueId());
        sidebar.remove();
    }

    @Override
    public void remove(@NotNull Player player) {
        BwSidebar sidebar = this.sidebars.remove(player.getUniqueId());
        if (null != sidebar) {
            sidebar.remove();
        }
    }

    public static SidebarService getInstance() {
        return instance;
    }

    protected SidebarManager getSidebarHandler() {
        return this.sidebarHandler;
    }

    @Override
    public void refreshTitles() {
        this.sidebars.forEach((k, v) -> v.getHandle().refreshTitle());
    }

    @Override
    public void refreshPlaceholders() {
        this.sidebars.forEach((k, v) -> v.getHandle().refreshPlaceholders());
    }

    @Override
    public void refreshPlaceholders(IArena arena) {
        this.sidebars.forEach((k, v) -> {
            if (v.getArena().equals(arena)) {
                v.getHandle().refreshPlaceholders();
            }
        });
    }

    @Override
    public void refreshTabList() {
        this.sidebars.forEach((k, v) -> v.getHandle().playerTabRefreshAnimation());
    }

    @Override
    public void refreshHealth() {
        this.sidebars.forEach((k, v) -> {
            if (null != v.getArena()) {
                v.getHandle().playerHealthRefreshAnimation();
                for (Player player : v.getArena().getPlayers()) {
                    v.getHandle().setPlayerHealth(player, (int)Math.ceil(player.getHealth()));
                }
            }
        });
    }

    @Override
    @Nullable
    public ISidebar getSidebar(@NotNull Player player) {
        return this.sidebars.getOrDefault(player.getUniqueId(), null);
    }

    public void refreshHealth(IArena arena, Player player, int health) {
        this.sidebars.forEach((k, v) -> {
            if (null != v.getArena() && v.getArena().equals(arena)) {
                v.getHandle().setPlayerHealth(player, health);
            }
        });
    }

    public void handleReJoin(IArena arena, Player player) {
        this.sidebars.forEach((k, v) -> {
            if (null != v.getArena() && v.getArena().equals(arena)) {
                v.giveUpdateTabFormat(player, false);
            }
        });
    }

    public void handleInvisibility(ITeam team, Player player, boolean toggle) {
        this.sidebars.forEach((k, v) -> {
            if (null != v.getArena() && v.getArena().equals(team.getArena())) {
                v.handleInvisibilityPotion(player, toggle);
            }
        });
    }
}

