/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.bedwars.sidebar;

import com.andrei1058.bedwars.BedWars;
import com.andrei1058.bedwars.api.arena.GameState;
import com.andrei1058.bedwars.api.arena.IArena;
import com.andrei1058.bedwars.api.arena.team.ITeam;
import com.andrei1058.bedwars.api.language.Language;
import com.andrei1058.bedwars.api.language.Messages;
import com.andrei1058.bedwars.api.server.ServerType;
import com.andrei1058.bedwars.api.sidebar.ISidebar;
import com.andrei1058.bedwars.arena.Arena;
import com.andrei1058.bedwars.levels.internal.PlayerLevel;
import com.andrei1058.bedwars.libs.sidebar.PlaceholderProvider;
import com.andrei1058.bedwars.libs.sidebar.PlayerTab;
import com.andrei1058.bedwars.libs.sidebar.Sidebar;
import com.andrei1058.bedwars.libs.sidebar.SidebarLine;
import com.andrei1058.bedwars.libs.sidebar.SidebarLineAnimated;
import com.andrei1058.bedwars.libs.sidebar.SidebarManager;
import com.andrei1058.bedwars.sidebar.SidebarService;
import com.andrei1058.bedwars.stats.PlayerStats;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BwSidebar
implements ISidebar {
    private static final SidebarLine EMPTY_TITLE = new SidebarLine(){

        @Override
        @NotNull
        public String getLine() {
            return "";
        }
    };
    private static final String SPECTATOR_TAB = "spectators010101";
    private static final String TEAM_PREFIX = "?_";
    private final Player player;
    private IArena arena;
    private Sidebar handle;
    private final SimpleDateFormat dateFormat;
    private final SimpleDateFormat nextEventDateFormat;
    private final HashMap<String, PlayerTab> tabList = new HashMap();
    private final List<PlaceholderProvider> persistentProviders = new ArrayList<PlaceholderProvider>();

    protected BwSidebar(Player player) {
        this.player = player;
        this.nextEventDateFormat = new SimpleDateFormat(Language.getMsg(player, Messages.FORMATTING_SCOREBOARD_NEXEVENT_TIMER));
        this.nextEventDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.dateFormat = new SimpleDateFormat(Language.getMsg(player, Messages.FORMATTING_SCOREBOARD_DATE));
    }

    public void remove() {
        if (this.handle == null) {
            return;
        }
        this.tabList.forEach((k, v) -> this.handle.removeTab((String)k));
        this.handle.remove(this.player);
    }

    @Override
    public void setContent(List<String> titleArray, List<String> lineArray, @Nullable IArena arena) {
        this.arena = arena;
        SidebarLine title = this.normalizeTitle(titleArray);
        List<SidebarLine> lines = this.normalizeLines(lineArray);
        List<PlaceholderProvider> placeholders = this.getPlaceholders();
        placeholders.addAll(this.persistentProviders);
        if (null == this.handle) {
            this.handle = SidebarService.getInstance().getSidebarHandler().createSidebar(title, lines, placeholders);
            this.handle.add(this.player);
        } else {
            while (this.handle.lineCount() > 0) {
                this.handle.removeLine(0);
            }
            Bukkit.getScheduler().runTaskLater((Plugin)BedWars.plugin, () -> {
                new ArrayList<PlaceholderProvider>(this.handle.getPlaceholders()).forEach(p -> this.handle.removePlaceholder(p.getPlaceholder()));
                placeholders.forEach(p -> this.handle.addPlaceholder((PlaceholderProvider)p));
                this.handle.setTitle(title);
                lines.forEach(l -> this.handle.addLine((SidebarLine)l));
            }, 2L);
            this.handlePlayerList();
        }
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public SidebarLine normalizeTitle(@Nullable List<String> titleArray) {
        String[] aolo = new String[titleArray.size()];
        for (int x = 0; x < titleArray.size(); ++x) {
            aolo[x] = titleArray.get(x);
        }
        return null == titleArray || titleArray.isEmpty() ? EMPTY_TITLE : new SidebarLineAnimated(aolo);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public List<SidebarLine> normalizeLines(@NotNull List<String> lineArray) {
        ArrayList<SidebarLine> lines = new ArrayList<SidebarLine>();
        int teamCount = 0;
        Language language = Language.getPlayerLanguage(this.player);
        String genericTeamFormat = language.m(Messages.FORMATTING_SCOREBOARD_TEAM_GENERIC);
        for (String line : lineArray) {
            if (this.arena != null) {
                if (line.trim().equals("{team}")) {
                    if (this.arena.getTeams().size() <= teamCount) continue;
                    ITeam team = this.arena.getTeams().get(teamCount++);
                    String teamName = team.getDisplayName(language);
                    line = genericTeamFormat.replace("{TeamLetter}", String.valueOf(teamName.length() != 0 ? Character.valueOf(teamName.charAt(0)) : "")).replace("{TeamColor}", team.getColor().chat().toString()).replace("{TeamName}", teamName).replace("{TeamStatus}", "{Team" + team.getName() + "Status}");
                }
                line = line.replace("{map}", this.arena.getDisplayName()).replace("{map_name}", this.arena.getArenaName()).replace("{group}", this.arena.getDisplayGroup(this.player));
                for (ITeam currentTeam : this.arena.getTeams()) {
                    ChatColor color = currentTeam.getColor().chat();
                    line = line.replace("{Team" + currentTeam.getName() + "Color}", color.toString()).replace("{Team" + currentTeam.getName() + "Name}", currentTeam.getDisplayName(language));
                }
            }
            final String finalTemp = line = line.replace("{server_ip}", BedWars.config.getString("server-ip")).replace("{version}", BedWars.plugin.getDescription().getVersion()).replace("{server}", BedWars.config.getString("bungee-settings.server-id")).replace("{playername}", this.player.getName()).replace("{player}", this.player.getDisplayName()).replace("{money}", String.valueOf(BedWars.getEconomy().getMoney(this.player)));
            lines.add(new SidebarLine(){

                @Override
                @NotNull
                public String getLine() {
                    return finalTemp;
                }
            });
        }
        return lines;
    }

    @Contract(pure=true)
    @NotNull
    private List<PlaceholderProvider> getPlaceholders() {
        ArrayList<PlaceholderProvider> providers = new ArrayList<PlaceholderProvider>();
        providers.add(new PlaceholderProvider("{player}", () -> ((Player)this.player).getDisplayName()));
        providers.add(new PlaceholderProvider("{playerName}", () -> ((Player)this.player).getCustomName()));
        providers.add(new PlaceholderProvider("{date}", () -> this.dateFormat.format(new Date(System.currentTimeMillis()))));
        PlayerLevel level = PlayerLevel.getLevelByPlayer(this.getPlayer().getUniqueId());
        if (null != level) {
            providers.add(new PlaceholderProvider("{progress}", level::getProgress));
            providers.add(new PlaceholderProvider("{level}", () -> String.valueOf(level.getLevelName())));
            providers.add(new PlaceholderProvider("{levelUnformatted}", () -> String.valueOf(level.getLevel())));
            providers.add(new PlaceholderProvider("{currentXp}", level::getFormattedCurrentXp));
            providers.add(new PlaceholderProvider("{requiredXp}", level::getFormattedRequiredXp));
        }
        if (null == this.arena) {
            providers.add(new PlaceholderProvider("{on}", () -> String.valueOf(Bukkit.getOnlinePlayers().size())));
            PlayerStats stats = BedWars.getStatsManager().get(this.getPlayer().getUniqueId());
            if (null != stats) {
                providers.add(new PlaceholderProvider("{kills}", () -> String.valueOf(stats.getKills())));
                providers.add(new PlaceholderProvider("{finalKills}", () -> String.valueOf(stats.getFinalKills())));
                providers.add(new PlaceholderProvider("{beds}", () -> String.valueOf(stats.getBedsDestroyed())));
                providers.add(new PlaceholderProvider("{deaths}", () -> String.valueOf(stats.getDeaths())));
                providers.add(new PlaceholderProvider("{finalDeaths}", () -> String.valueOf(stats.getFinalDeaths())));
                providers.add(new PlaceholderProvider("{wins}", () -> String.valueOf(stats.getWins())));
                providers.add(new PlaceholderProvider("{losses}", () -> String.valueOf(stats.getLosses())));
            }
        } else {
            providers.add(new PlaceholderProvider("{on}", () -> String.valueOf(this.arena.getPlayers().size())));
            providers.add(new PlaceholderProvider("{max}", () -> String.valueOf(this.arena.getMaxPlayers())));
            providers.add(new PlaceholderProvider("{nextEvent}", this::getNextEventName));
            providers.add(new PlaceholderProvider("{time}", () -> {
                if (this.arena.getStatus() == GameState.playing || this.arena.getStatus() == GameState.restarting) {
                    return this.getNextEventTime();
                }
                if (this.arena.getStatus() == GameState.starting && this.arena.getStartingTask() != null) {
                    return String.valueOf(this.arena.getStartingTask().getCountdown() + 1);
                }
                return this.dateFormat.format(new Date(System.currentTimeMillis()));
            }));
            providers.add(new PlaceholderProvider("{kills}", () -> String.valueOf(this.arena.getPlayerKills(this.player, false))));
            providers.add(new PlaceholderProvider("{finalKills}", () -> String.valueOf(this.arena.getPlayerKills(this.player, true))));
            providers.add(new PlaceholderProvider("{beds}", () -> String.valueOf(this.arena.getPlayerBedsDestroyed(this.player))));
            providers.add(new PlaceholderProvider("{deaths}", () -> String.valueOf(this.arena.getPlayerDeaths(this.player, false))));
            for (ITeam currentTeam : this.arena.getTeams()) {
                providers.add(new PlaceholderProvider("{Team" + currentTeam.getName() + "Status}", () -> {
                    String result = currentTeam.isBedDestroyed() ? (currentTeam.getSize() > 0 ? Language.getMsg(this.getPlayer(), Messages.FORMATTING_SCOREBOARD_BED_DESTROYED).replace("{remainingPlayers}", String.valueOf(currentTeam.getSize())) : Language.getMsg(this.getPlayer(), Messages.FORMATTING_SCOREBOARD_TEAM_ELIMINATED)) : Language.getMsg(this.getPlayer(), Messages.FORMATTING_SCOREBOARD_TEAM_ALIVE);
                    if (currentTeam.isMember(this.getPlayer())) {
                        result = result + Language.getMsg(this.getPlayer(), Messages.FORMATTING_SCOREBOARD_YOUR_TEAM);
                    }
                    return result;
                }));
            }
        }
        return providers;
    }

    @NotNull
    private String getNextEventName() {
        if (!(this.arena instanceof Arena)) {
            return "-";
        }
        Arena arena = (Arena)this.arena;
        String st = "-";
        switch (arena.getNextEvent()) {
            case EMERALD_GENERATOR_TIER_II: {
                st = Language.getMsg(this.getPlayer(), Messages.NEXT_EVENT_EMERALD_UPGRADE_II);
                break;
            }
            case EMERALD_GENERATOR_TIER_III: {
                st = Language.getMsg(this.getPlayer(), Messages.NEXT_EVENT_EMERALD_UPGRADE_III);
                break;
            }
            case DIAMOND_GENERATOR_TIER_II: {
                st = Language.getMsg(this.getPlayer(), Messages.NEXT_EVENT_DIAMOND_UPGRADE_II);
                break;
            }
            case DIAMOND_GENERATOR_TIER_III: {
                st = Language.getMsg(this.getPlayer(), Messages.NEXT_EVENT_DIAMOND_UPGRADE_III);
                break;
            }
            case GAME_END: {
                st = Language.getMsg(this.getPlayer(), Messages.NEXT_EVENT_GAME_END);
                break;
            }
            case BEDS_DESTROY: {
                st = Language.getMsg(this.getPlayer(), Messages.NEXT_EVENT_BEDS_DESTROY);
                break;
            }
            case ENDER_DRAGON: {
                st = Language.getMsg(this.getPlayer(), Messages.NEXT_EVENT_DRAGON_SPAWN);
            }
        }
        return st;
    }

    @NotNull
    private String getNextEventTime() {
        if (!(this.arena instanceof Arena)) {
            return this.nextEventDateFormat.format(0L);
        }
        Arena arena = (Arena)this.arena;
        long time = 0L;
        switch (arena.getNextEvent()) {
            case EMERALD_GENERATOR_TIER_II: 
            case EMERALD_GENERATOR_TIER_III: {
                time = (long)arena.upgradeEmeraldsCount * 1000L;
                break;
            }
            case DIAMOND_GENERATOR_TIER_II: 
            case DIAMOND_GENERATOR_TIER_III: {
                time = (long)arena.upgradeDiamondsCount * 1000L;
                break;
            }
            case GAME_END: {
                time = (long)arena.getPlayingTask().getGameEndCountdown() * 1000L;
                break;
            }
            case BEDS_DESTROY: {
                time = (long)arena.getPlayingTask().getBedsDestroyCountdown() * 1000L;
                break;
            }
            case ENDER_DRAGON: {
                time = (long)arena.getPlayingTask().getDragonSpawnCountdown() * 1000L;
            }
        }
        return time == 0L ? "0" : this.nextEventDateFormat.format(new Date(time));
    }

    private boolean noArena() {
        return null == this.arena;
    }

    private void handlePlayerList() {
        if (null != this.handle) {
            this.tabList.forEach((k, v) -> {
                String encodedName = Base64.getEncoder().encodeToString(k.getBytes(StandardCharsets.UTF_8));
                this.handle.removeTab(encodedName);
            });
        }
        if (this.isTabFormattingDisabled()) {
            return;
        }
        this.handleHealthIcon();
        if (this.arena == null) {
            if (BedWars.config.getBoolean("scoreboard-settings.player-list.format-lobby-list") && !BedWars.config.getLobbyWorldName().trim().isEmpty()) {
                World lobby = Bukkit.getWorld((String)BedWars.config.getLobbyWorldName());
                if (null == lobby) {
                    return;
                }
                lobby.getPlayers().forEach(inLobby -> this.giveUpdateTabFormat((Player)inLobby, true));
            }
            return;
        }
        this.arena.getPlayers().forEach(playing -> this.giveUpdateTabFormat((Player)playing, true));
        this.arena.getSpectators().forEach(spectating -> this.giveUpdateTabFormat((Player)spectating, true));
    }

    @Override
    public void giveUpdateTabFormat(@NotNull Player player, boolean skipStateCheck) {
        PlayerTab teamTab;
        if (this.handle == null) {
            return;
        }
        String tabListName = player.getName();
        Language lang = Language.getPlayerLanguage(player);
        if (this.tabList.containsKey(tabListName)) {
            this.handle.removeTab(tabListName);
            this.tabList.remove(tabListName);
            SidebarManager.getInstance().sendHeaderFooter(player, "", "");
        }
        if (!skipStateCheck && this.isTabFormattingDisabled()) {
            return;
        }
        if (this.noArena()) {
            SidebarLine prefix = this.getTabText(Messages.FORMATTING_SCOREBOARD_TAB_PREFIX_LOBBY, player, null);
            SidebarLine suffix = this.getTabText(Messages.FORMATTING_SCOREBOARD_TAB_SUFFIX_LOBBY, player, null);
            PlayerTab tab = this.handle.playerTabCreate(tabListName, player, prefix, suffix, PlayerTab.PushingRule.NEVER);
            tab.add(player);
            this.tabList.put(tabListName, tab);
            SidebarManager.getInstance().sendHeaderFooter(player, lang.m(Messages.FORMATTING_SIDEBAR_TAB_HEADER_LOBBY), lang.m(Messages.FORMATTING_SIDEBAR_TAB_FOOTER_LOBBY));
            return;
        }
        if (this.arena.isSpectator(player)) {
            PlayerTab tab = this.tabList.get(SPECTATOR_TAB);
            if (null == tab) {
                SidebarLine prefix = this.getTabText(Messages.FORMATTING_SCOREBOARD_TAB_PREFIX_SPECTATOR, player, null);
                SidebarLine suffix = this.getTabText(Messages.FORMATTING_SCOREBOARD_TAB_SUFFIX_SPECTATOR, player, null);
                tab = this.handle.playerTabCreate(SPECTATOR_TAB, null, prefix, suffix, PlayerTab.PushingRule.NEVER);
                this.tabList.put(SPECTATOR_TAB, tab);
            }
            tab.add(player);
            SidebarManager.getInstance().sendHeaderFooter(player, lang.m(Messages.FORMATTING_SIDEBAR_TAB_HEADER_SPECTATOR), lang.m(Messages.FORMATTING_SIDEBAR_TAB_FOOTER_SPECTATOR));
            return;
        }
        if (this.arena.getStatus() != GameState.playing) {
            SidebarLine suffix;
            SidebarLine prefix;
            if (this.arena.getStatus() == GameState.waiting) {
                prefix = this.getTabText(Messages.FORMATTING_SCOREBOARD_TAB_PREFIX_WAITING, player, null);
                suffix = this.getTabText(Messages.FORMATTING_SCOREBOARD_TAB_SUFFIX_WAITING, player, null);
                SidebarManager.getInstance().sendHeaderFooter(player, lang.m(Messages.FORMATTING_SIDEBAR_TAB_HEADER_WAITING), lang.m(Messages.FORMATTING_SIDEBAR_TAB_FOOTER_WAITING));
            } else if (this.arena.getStatus() == GameState.starting) {
                prefix = this.getTabText(Messages.FORMATTING_SCOREBOARD_TAB_PREFIX_STARTING, player, null);
                suffix = this.getTabText(Messages.FORMATTING_SCOREBOARD_TAB_SUFFIX_STARTING, player, null);
                SidebarManager.getInstance().sendHeaderFooter(player, lang.m(Messages.FORMATTING_SIDEBAR_TAB_HEADER_STARTING), lang.m(Messages.FORMATTING_SIDEBAR_TAB_FOOTER_STARTING));
            } else if (this.arena.getStatus() == GameState.restarting) {
                ITeam team = this.arena.getTeam(player);
                if (null == team) {
                    team = this.arena.getExTeam(player.getUniqueId());
                }
                String displayName = null == team ? "" : team.getDisplayName(Language.getPlayerLanguage(this.player));
                HashMap<String, String> replacements = new HashMap<String, String>();
                replacements.put("{team}", null == team ? "" : team.getColor().chat() + displayName);
                replacements.put("{teamLetter}", null == team ? "" : team.getColor().chat() + displayName.substring(0, 1));
                replacements.put("{teamColor}", null == team ? "" : team.getColor().chat().toString());
                prefix = this.getTabText(Messages.FORMATTING_SCOREBOARD_TAB_PREFIX_RESTARTING, player, replacements);
                suffix = this.getTabText(Messages.FORMATTING_SCOREBOARD_TAB_SUFFIX_RESTARTING, player, replacements);
                SidebarManager.getInstance().sendHeaderFooter(player, lang.m(Messages.FORMATTING_SIDEBAR_TAB_HEADER_RESTARTING), lang.m(Messages.FORMATTING_SIDEBAR_TAB_FOOTER_RESTARTING));
            } else {
                throw new RuntimeException("Unhandled game status!");
            }
            PlayerTab t = this.handle.playerTabCreate(tabListName, player, prefix, suffix, PlayerTab.PushingRule.NEVER);
            t.add(player);
            this.tabList.put(tabListName, t);
            return;
        }
        ITeam team = this.arena.getTeam(player);
        if (null == team) {
            team = this.arena.getExTeam(player.getUniqueId());
        }
        if (null == team) {
            throw new RuntimeException("Wtf dude");
        }
        String tabName = TEAM_PREFIX + Base64.getEncoder().encodeToString(team.getName().getBytes(StandardCharsets.UTF_8));
        if (tabName.length() > 16) {
            tabName = tabName.substring(0, 16);
        }
        if (null == (teamTab = this.tabList.get(tabName))) {
            String displayName = team.getDisplayName(Language.getPlayerLanguage(this.player));
            HashMap<String, String> replacements = new HashMap<String, String>();
            replacements.put("{team}", team.getColor().chat() + displayName);
            replacements.put("{teamLetter}", team.getColor().chat() + displayName.substring(0, 1));
            replacements.put("{teamColor}", team.getColor().chat().toString());
            SidebarLine prefix = this.getTabText(Messages.FORMATTING_SCOREBOARD_TAB_PREFIX_PLAYING, player, replacements);
            SidebarLine suffix = this.getTabText(Messages.FORMATTING_SCOREBOARD_TAB_SUFFIX_PLAYING, player, replacements);
            teamTab = this.handle.playerTabCreate(tabName, null, prefix, suffix, PlayerTab.PushingRule.PUSH_OTHER_TEAMS);
            this.tabList.put(tabName, teamTab);
        }
        teamTab.add(player);
        SidebarManager.getInstance().sendHeaderFooter(player, lang.m(Messages.FORMATTING_SIDEBAR_TAB_HEADER_PLAYING), lang.m(Messages.FORMATTING_SIDEBAR_TAB_FOOTER_PLAYING));
    }

    @NotNull
    private SidebarLine getTabText(String path, Player targetPlayer, @Nullable HashMap<String, String> replacements) {
        List<String> strings = Language.getList(this.getPlayer(), path);
        if (strings.isEmpty()) {
            return new SidebarLine(){

                @Override
                @NotNull
                public String getLine() {
                    return "";
                }
            };
        }
        strings = new ArrayList<String>();
        for (String string : Language.getList(this.getPlayer(), path)) {
            String parsed = string.replace("{vPrefix}", BedWars.getChatSupport().getPrefix(targetPlayer)).replace("{vSuffix}", BedWars.getChatSupport().getSuffix(targetPlayer));
            if (null != replacements) {
                for (Map.Entry<String, String> entry : replacements.entrySet()) {
                    parsed = parsed.replace(entry.getKey(), entry.getValue());
                }
            }
            strings.add(parsed);
        }
        if (strings.size() == 1) {
            final String line = strings.get(0);
            return new SidebarLine(){

                @Override
                @NotNull
                public String getLine() {
                    return line;
                }
            };
        }
        String[] lines = new String[strings.size()];
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = strings.get(i);
        }
        return new SidebarLineAnimated(lines);
    }

    @Override
    public boolean isTabFormattingDisabled() {
        if (null == this.arena) {
            if (BedWars.getServerType() == ServerType.SHARED && BedWars.config.getBoolean("scoreboard-settings.player-list.format-lobby-list") && !BedWars.config.getLobbyWorldName().trim().isEmpty()) {
                World lobby = Bukkit.getWorld((String)BedWars.config.getLobbyWorldName());
                return null != lobby;
            }
            return BedWars.config.getBoolean("scoreboard-settings.player-list.format-lobby-list");
        }
        if (this.arena.getStatus() == GameState.playing && BedWars.config.getBoolean("scoreboard-settings.player-list.format-playing-list")) {
            return false;
        }
        if (this.arena.getStatus() == GameState.starting && BedWars.config.getBoolean("scoreboard-settings.player-list.format-starting-list")) {
            return false;
        }
        if (this.arena.getStatus() == GameState.waiting && BedWars.config.getBoolean("scoreboard-settings.player-list.format-waiting-list")) {
            return false;
        }
        return this.arena.getStatus() != GameState.restarting || !BedWars.config.getBoolean("scoreboard-settings.player-list.format-restarting-list");
    }

    @Override
    public boolean registerPersistentPlaceholder(PlaceholderProvider placeholderProvider) {
        this.persistentProviders.add(placeholderProvider);
        return true;
    }

    public void handleHealthIcon() {
        SidebarLine line;
        if (null == this.handle) {
            return;
        }
        if (null == this.arena) {
            this.handle.hidePlayersHealth();
        } else if (this.arena.getStatus() != GameState.playing) {
            this.handle.hidePlayersHealth();
        }
        List<String> animation = Language.getList(this.player, Messages.FORMATTING_SCOREBOARD_HEALTH);
        if (animation.isEmpty()) {
            return;
        }
        if (animation.size() > 1) {
            String[] lines = new String[animation.size()];
            for (int i = 0; i < animation.size(); ++i) {
                lines[i] = animation.get(i);
            }
            line = new SidebarLineAnimated(lines);
        } else {
            final String text = animation.get(0);
            line = new SidebarLine(){

                @Override
                @NotNull
                public String getLine() {
                    return text;
                }
            };
        }
        this.handle.showPlayersHealth(line, BedWars.config.getBoolean("scoreboard-settings.health.display-in-tab"));
        Bukkit.getScheduler().runTaskLater((Plugin)BedWars.plugin, () -> {
            if (this.arena != null && this.handle != null) {
                this.arena.getPlayers().forEach(player -> this.handle.setPlayerHealth((Player)player, (int)Math.ceil(player.getHealth())));
                if (this.arena.isSpectator(this.getPlayer())) {
                    this.arena.getSpectators().forEach(player -> this.handle.setPlayerHealth((Player)player, (int)Math.ceil(player.getHealth())));
                }
            }
        }, 20L);
    }

    public void handleInvisibilityPotion(@NotNull Player player, boolean toggle) {
        if (toggle) {
            // empty if block
        }
    }

    @Override
    public Sidebar getHandle() {
        return this.handle;
    }

    @Override
    public IArena getArena() {
        return this.arena;
    }
}

