/*
 * Decompiled with CFR 0.152.
 */
package com.andrei1058.bedwars.listeners;

import com.andrei1058.bedwars.BedWars;
import com.andrei1058.bedwars.api.arena.GameState;
import com.andrei1058.bedwars.api.arena.IArena;
import com.andrei1058.bedwars.api.language.Language;
import com.andrei1058.bedwars.api.server.ServerType;
import com.andrei1058.bedwars.arena.Arena;
import com.andrei1058.bedwars.arena.LastHit;
import com.andrei1058.bedwars.arena.SetupSession;
import com.andrei1058.bedwars.arena.team.BedWarsTeam;
import com.andrei1058.bedwars.commands.bedwars.subcmds.regular.CmdStats;
import com.andrei1058.bedwars.sidebar.SidebarService;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;

public class QuitAndTeleportListener
implements Listener {
    @EventHandler
    public void onLeave(PlayerQuitEvent e) {
        SetupSession ss;
        Player p = e.getPlayer();
        IArena a2 = Arena.getArenaByPlayer(p);
        if (a2 != null) {
            if (a2.isPlayer(p)) {
                a2.removePlayer(p, true);
            } else if (a2.isSpectator(p)) {
                a2.removeSpectator(p, true);
            }
        }
        if (Language.getLangByPlayer().containsKey(p.getUniqueId())) {
            UUID u = p.getUniqueId();
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)BedWars.plugin, () -> {
                String iso = Language.getLangByPlayer().get(p.getUniqueId()).getIso();
                if (Language.isLanguageExist(iso)) {
                    if (BedWars.config.getYml().getStringList("disabled-languages").contains(iso)) {
                        iso = Language.getDefaultLanguage().getIso();
                    }
                    BedWars.getRemoteDatabase().setLanguage(u, iso);
                }
                Language.getLangByPlayer().remove(p.getUniqueId());
            });
        }
        if (BedWars.getServerType() != ServerType.SHARED) {
            e.setQuitMessage(null);
        }
        if (BedWars.getParty().isInternal() && BedWars.getParty().hasParty(p)) {
            BedWars.getParty().removeFromParty(p);
        }
        if ((ss = SetupSession.getSession(p.getUniqueId())) != null) {
            ss.cancel();
        }
        SidebarService.getInstance().remove(e.getPlayer());
        BedWarsTeam.reSpawnInvulnerability.remove(e.getPlayer().getUniqueId());
        LastHit lh = LastHit.getLastHit(p);
        if (lh != null) {
            lh.remove();
        }
        CmdStats.getStatsCoolDown().remove(e.getPlayer().getUniqueId());
    }

    @EventHandler
    public void onTeleport(PlayerTeleportEvent e) {
        IArena a1;
        if (e == null) {
            return;
        }
        if (e.isCancelled()) {
            return;
        }
        if (e.getTo() == null) {
            return;
        }
        if (e.getTo().getWorld() == null) {
            return;
        }
        IArena a2 = Arena.getArenaByPlayer(e.getPlayer());
        if (a2 != null && (a1 = Arena.getArenaByIdentifier(e.getTo().getWorld().getName())) != null && !a1.equals(a2)) {
            if (a2.isSpectator(e.getPlayer())) {
                a2.removeSpectator(e.getPlayer(), false);
            }
            if (a2.isPlayer(e.getPlayer())) {
                a2.removePlayer(e.getPlayer(), false);
            }
            e.getPlayer().sendMessage("PlayerTeleportEvent something went wrong. You have joined an arena world while playing on a different map.");
        }
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent e) {
        IArena a2;
        if (BedWars.getServerType() == ServerType.SHARED && BedWars.config.getBoolean("scoreboard-settings.sidebar.enable-lobby-sidebar")) {
            if (e.getPlayer().getWorld().getName().equalsIgnoreCase(BedWars.getLobbyWorld())) {
                SidebarService.getInstance().giveSidebar(e.getPlayer(), null, true);
            } else {
                SidebarService.getInstance().remove(e.getPlayer());
            }
        }
        if ((a2 = Arena.getArenaByPlayer(e.getPlayer())) != null && a2.isPlayer(e.getPlayer())) {
            if (a2.getStatus() == GameState.waiting || a2.getStatus() == GameState.starting) {
                return;
            }
            if (!e.getPlayer().getWorld().getName().equalsIgnoreCase(a2.getWorld().getName())) {
                a2.removePlayer(e.getPlayer(), BedWars.getServerType() == ServerType.BUNGEE);
                BedWars.debug(e.getPlayer().getName() + " was removed from " + a2.getDisplayName() + " because he was teleported outside the arena.");
            }
        }
    }
}

