/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.v8;

import clib.phtree.PhTreeHelper;
import clib.phtree.v8.Bits;
import clib.phtree.v8.Node;
import clib.phtree.v8.NodeIteratorFull;
import clib.phtree.v8.PhOperations;
import clib.phtree.v8.PhTree8;
import org.zoodb.index.critbit.CritBit64;

public class PhOperationsSimple<T>
implements PhOperations<T> {
    protected static final int NO_INSERT_REQUIRED = Integer.MAX_VALUE;
    protected PhTree8<T> tree;

    PhOperationsSimple() {
    }

    public PhOperationsSimple(PhTree8<T> tree) {
        this.tree = tree;
    }

    @Override
    public Node<T> createNode(Node<T> original, int dim) {
        return Node.createNode(original, dim);
    }

    @Override
    public Node<T> createNode(PhTree8<T> parent, int infixLen, int postLen, int estimatedPostCount) {
        return Node.createNode(parent, infixLen, postLen, estimatedPostCount);
    }

    @Override
    public T put(long[] key, T value) {
        if (this.tree.getRoot() == null) {
            this.tree.insertRoot(key, value);
            return null;
        }
        return this.insert(key, value, this.tree.getRoot(), null, -1L);
    }

    protected T insert(long[] key, T value, Node<T> node, Node<T> parent, long posInParent) {
        long pos = PhTreeHelper.posInArray(key, node.getPostLen());
        if (node.getPostLen() > 0) {
            if (node.isPostNI()) {
                return this.insertNI(key, value, node, pos);
            }
            Node<T> sub = node.getSubNode(pos, key.length);
            if (sub == null) {
                return this.insertNoSub(key, value, node, pos, parent, posInParent);
            }
            if (sub.hasInfixes() && this.conflictingInfix(sub, key)) {
                return this.insertSplit(key, value, sub, node, pos);
            }
            return this.insert(key, value, sub, node, pos);
        }
        return this.insertLeaf(key, value, node, pos);
    }

    protected T insertNI(long[] key, T value, Node<T> node, long pos) {
        PhTree8.NodeEntry<T> e = node.getChildNI(pos);
        if (e != null && e.node != null) {
            Node sub = e.node;
            if (sub.hasInfixes() && this.conflictingInfix(sub, key)) {
                return this.insertSplit(key, value, sub, node, pos);
            }
            return this.insert(key, value, sub, node, pos);
        }
        return this.performInsertionNI(this.tree, key, value, node, e, pos);
    }

    protected final T performInsertionNI(PhTree8<T> tree, long[] key, T value, Node<T> node, PhTree8.NodeEntry<T> e, long pos) {
        if (e == null) {
            node.addPostPOB(pos, -1, key, value);
            tree.increaseNrEntries();
            return null;
        }
        Object prevVal = e.getValue();
        if (node.postEquals(e.getKey(), key)) {
            e.setPost(e.getKey(), value);
            return prevVal;
        }
        Node<T> sub = this.calcPostfixes(key, value, e.getKey(), prevVal, node.getPostLen());
        node.setPostCount(node.getPostCount() - 1);
        node.setSubCount(node.getSubCount() + 1);
        e.setNode(sub);
        tree.increaseNrEntries();
        return null;
    }

    protected T insertSplit(long[] key, T value, Node<T> node, Node<T> parent, long posInParent) {
        int DIM = key.length;
        long[] infix = new long[DIM];
        node.getInfixNoOverwrite(infix);
        int maxConflictingBits = this.tree.getConflictingInfixBits(key, infix, node);
        int newLocalInfLen = node.getInfixLen() + 1 + node.getPostLen() - maxConflictingBits;
        int newSubInfLen = node.getInfixLen() - newLocalInfLen - 1;
        long posOfNewSub = this.tree.posInArrayFromInfixes(node, newLocalInfLen);
        int newPostLen = maxConflictingBits - 1;
        Node<T> newNode = this.createNode(this.tree, newLocalInfLen, newPostLen, 1);
        if (newLocalInfLen > 0) {
            newNode.writeInfix(infix);
        }
        int oldInfLen = node.getInfixLen();
        node.setInfixLen(newSubInfLen);
        Bits.removeBits(node.ba, node.getBitPos_Infix(), (oldInfLen - newSubInfLen) * DIM);
        node.writeInfix(infix);
        node.ba = Bits.arrayTrim(node.ba, node.calcArraySizeTotalBits(node.getPostCount(), DIM));
        newNode.addSubNode(posOfNewSub, node, DIM);
        long pos = PhTreeHelper.posInArray(key, newPostLen);
        newNode.addPost(pos, key, value);
        this.tree.increaseNrEntries();
        parent.replaceSub(posInParent, newNode, DIM);
        return null;
    }

    protected boolean conflictingInfix(Node<T> node, long[] key) {
        int DIM = this.tree.getDim();
        long[] infix = new long[DIM];
        node.getInfixNoOverwrite(infix);
        int maxConflictingBits = this.tree.getConflictingInfixBits(key, infix, node);
        return maxConflictingBits != 0;
    }

    protected T insertNoSub(long[] key, T value, Node<T> node, long pos, Node<T> parent, long posInParent) {
        int DIM = key.length;
        int pob = node.getPostOffsetBits(pos, DIM);
        if (pob >= 0) {
            if (node.postEqualsPOB(pob, pos, key)) {
                return node.updatePostValuePOB(pob, pos, key, DIM, value);
            }
            long[] prevKey = new long[DIM];
            T prevVal = node.getPostPOB(pob, pos, prevKey);
            Node<T> sub = this.calcPostfixes(key, value, prevKey, prevVal, node.getPostLen());
            node.removePostPOB(pos, pob, DIM);
            node.addSubNode(pos, sub, DIM);
        } else {
            node.addPostPOB(pos, pob, key, value);
        }
        this.tree.increaseNrEntries();
        return null;
    }

    protected T insertLeaf(long[] key, T value, Node<T> node, long pos) {
        int DIM = key.length;
        int pob = node.getPostOffsetBits(pos, DIM);
        if (pob < 0) {
            node.addPostPOB(pos, pob, key, value);
            this.tree.increaseNrEntries();
            return null;
        }
        if (node.isPostNI() && !node.hasPostFix(pos, DIM)) {
            node.addPostPOB(pos, pob, key, value);
            this.tree.increaseNrEntries();
            return null;
        }
        return node.updatePostValuePOB(pob, pos, key, DIM, value);
    }

    private Node<T> calcPostfixes(long[] key1, T val1, long[] key2, T val2, int parentPostLen) {
        int mcb = PhTreeHelper.getMaxConflictingBits(key1, key2, parentPostLen);
        int infLen = parentPostLen - mcb;
        int postLen = mcb - 1;
        Node<T> node = this.createNode(this.tree, infLen, postLen, 2);
        node.writeInfix(key1);
        long posSub1 = PhTreeHelper.posInArray(key1, postLen);
        node.addPost(posSub1, key1, val1);
        long posSub2 = PhTreeHelper.posInArray(key2, postLen);
        node.addPost(posSub2, key2, val2);
        return node;
    }

    @Override
    public T remove(long ... key) {
        if (this.tree.getRoot() == null) {
            return null;
        }
        return this.delete(key, this.tree.getRoot(), null, -1L, null, null);
    }

    protected T delete(long[] key, Node<T> node, Node<T> parent, long posInParent, long[] newKey, int[] insertRequired) {
        if (node.getInfixLen() > 0 && !this.checkInfixMatch(node, key)) {
            return null;
        }
        if (node.isPostNI()) {
            T ret = this.deleteNI(key, node, parent, posInParent, newKey, insertRequired);
            if (insertRequired != null && insertRequired[0] < node.getPostLen()) {
                this.insert(newKey, ret, node, parent, posInParent);
                insertRequired[0] = Integer.MAX_VALUE;
            }
            return ret;
        }
        long pos = PhTreeHelper.posInArray(key, node.getPostLen());
        Node<T> sub1 = node.getSubNode(pos, key.length);
        if (sub1 != null) {
            T ret = this.delete(key, sub1, node, pos, newKey, insertRequired);
            if (insertRequired != null && insertRequired[0] < node.getPostLen()) {
                this.insert(newKey, ret, node, parent, posInParent);
                insertRequired[0] = Integer.MAX_VALUE;
            }
            return ret;
        }
        return this.performDeletion(key, node, parent, posInParent, newKey, insertRequired, pos);
    }

    protected boolean checkInfixMatch(Node<T> node, long[] key) {
        long mask = (1L << node.getInfixLen()) - 1L;
        int shiftMask = node.getPostLen() + 1;
        mask = shiftMask == 64 ? 0L : mask << shiftMask;
        for (int i = 0; i < key.length; ++i) {
            if (((key[i] ^ node.getInfix(i)) & mask) == 0L) continue;
            return false;
        }
        return true;
    }

    protected T deleteNI(long[] key, Node<T> node, Node<T> parent, long posInParent, long[] newKey, int[] insertRequired) {
        long pos = PhTreeHelper.posInArray(key, node.getPostLen());
        PhTree8.NodeEntry<T> e = node.getChildNI(pos);
        if (e == null) {
            return null;
        }
        if (e.node != null) {
            Object ret = this.delete(key, e.node, node, pos, newKey, insertRequired);
            if (insertRequired != null && insertRequired[0] < node.getPostLen()) {
                this.insert(newKey, ret, node, parent, posInParent);
                insertRequired[0] = Integer.MAX_VALUE;
            }
            return ret;
        }
        return this.performDeletionNI(this.tree, key, e, node, parent, posInParent, newKey, insertRequired, pos);
    }

    protected T performDeletionNI(PhTree8<T> tree, long[] key, PhTree8.NodeEntry<T> e, Node<T> node, Node<T> parent, long posInParent, long[] newKey, int[] insertRequired, long pos) {
        int DIM = key.length;
        if (!node.postEquals(e.getKey(), key)) {
            return null;
        }
        if (newKey != null) {
            long diff = 0L;
            for (int i = 0; i < key.length; ++i) {
                diff |= key[i] ^ newKey[i];
            }
            int bitPosOfDiff = 64 - Long.numberOfLeadingZeros(diff);
            if (bitPosOfDiff <= node.getPostLen()) {
                PhTree8.NodeEntry ne = node.niGet(pos);
                Object oldValue = ne.getValue();
                ne.setPost((long[])newKey.clone(), oldValue);
                return oldValue;
            }
            insertRequired[0] = bitPosOfDiff;
        }
        tree.decreaseNrEntries();
        int nP = node.getPostCount();
        int nS = node.getSubCount();
        if (parent == null || nP + nS > 2) {
            node.removePostPOB(pos, -1, DIM);
            return e.getValue();
        }
        tree.decreaseNrNodes();
        Object oldValue = e.getValue();
        CritBit64.CBIterator<PhTree8.NodeEntry<T>> iter = node.niIterator();
        CritBit64.Entry<PhTree8.NodeEntry<T>> ie = iter.nextEntry();
        if (ie.key() == pos) {
            ie = iter.nextEntry();
        }
        if ((e = ie.value()).getKey() != null) {
            long[] newPost = e.getKey();
            node.getInfixNoOverwrite(newPost);
            Object val = e.getValue();
            PhTreeHelper.applyHcPos(ie.key(), node.getPostLen(), newPost);
            parent.removeSub(posInParent, DIM);
            node.setRemoved(true);
            parent.addPost(posInParent, newPost, val);
            return oldValue;
        }
        Node sub2 = e.node;
        this.performDeletionWithSub(node, parent, posInParent, sub2, ie.key(), DIM);
        return oldValue;
    }

    T performDeletion(long[] key, Node<T> node, Node<T> parent, long posInParent, long[] newKey, int[] insertRequired, long pos) {
        int DIM = key.length;
        int pob = node.getPostOffsetBits(pos, DIM);
        if (pob < 0) {
            return null;
        }
        if (!node.postEqualsPOB(pob, pos, key)) {
            return null;
        }
        if (newKey != null) {
            long diff = 0L;
            for (int i = 0; i < key.length; ++i) {
                diff |= key[i] ^ newKey[i];
            }
            int bitPosOfDiff = 64 - Long.numberOfLeadingZeros(diff);
            if (bitPosOfDiff <= node.getPostLen()) {
                T oldValue = node.getPostValuePOB(pob, pos, DIM);
                node.replacePost(pob, pos, newKey, oldValue);
                return oldValue;
            }
            insertRequired[0] = bitPosOfDiff;
        }
        this.tree.decreaseNrEntries();
        int nP = node.getPostCount();
        int nS = node.getSubCount();
        if (parent == null || nP + nS > 2) {
            return node.removePostPOB(pos, pob, DIM);
        }
        this.tree.decreaseNrNodes();
        T oldValue = node.getPostValue(pos, DIM);
        NodeIteratorFull<T> iter = new NodeIteratorFull<T>(node, DIM, null);
        long pos2 = iter.getCurrentPos();
        if (pos2 == pos) {
            iter.increment();
            pos2 = iter.getCurrentPos();
        }
        boolean isSubNode = iter.isNextSub();
        int posSubLHC = iter.getPosSubLHC();
        if (!isSubNode) {
            long[] newPost = new long[DIM];
            node.getInfixNoOverwrite(newPost);
            T val = node.getPost(pos2, newPost);
            PhTreeHelper.applyHcPos(pos2, node.getPostLen(), newPost);
            parent.removeSub(posInParent, DIM);
            parent.addPost(posInParent, newPost, val);
            node.setRemoved(true);
            return oldValue;
        }
        Node<T> sub2 = this.getSubNode(node, pos2, posSubLHC);
        this.performDeletionWithSub(node, parent, posInParent, sub2, pos2, DIM);
        return oldValue;
    }

    protected void performDeletionWithSub(Node<T> node, Node<T> parent, long posInParent, Node<T> sub2, long posSub, int DIM) {
        long[] infix = new long[DIM];
        node.getInfixNoOverwrite(infix);
        sub2.adjustInfix(infix, node.getInfixLen(), node.getPostLen(), posSub);
        parent.replaceSub(posInParent, sub2, DIM);
        node.setRemoved(true);
    }

    protected Node<T> getSubNode(Node<T> node, long pos2, int posSubLHC) {
        return node.getSubNodeWithPos(pos2, posSubLHC);
    }

    @Override
    public T update(long[] oldKey, long[] newKey) {
        if (this.tree.getRoot() == null) {
            return null;
        }
        int[] insertRequired = new int[]{Integer.MAX_VALUE};
        T v = this.delete(oldKey, this.tree.getRoot(), null, -1L, newKey, insertRequired);
        if (insertRequired[0] != Integer.MAX_VALUE) {
            this.put(newKey, v);
        }
        return v;
    }

    protected Node<T> copyNodeAndReplaceInParent(Node<T> node, Node<T> parent, long posInParent) {
        if (parent != null) {
            node = this.createNode(node, this.tree.getDim());
            parent.replaceSub(posInParent, node, this.tree.getDim());
        }
        return node;
    }

    protected Node<T> copyNodeAndReplaceInParentNI(Node<T> node, long childPos) {
        PhTree8.NodeEntry<T> e = node.getChildNI(childPos);
        if (e != null) {
            if (e.node != null) {
                node.niPut(childPos, this.createNode(e.node, this.tree.getDim()));
            } else {
                node.niPut(childPos, e.getKey(), e.getValue());
            }
        }
        return node;
    }

    public void setTree(PhTree8<T> tree) {
        this.tree = tree;
    }
}

