/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.v16.bst;

import clib.phtree.v16.Node;
import clib.phtree.v16.bst.BSTreePage;
import java.util.NoSuchElementException;

public class BSTIteratorAll {
    private BSTreePage currentPage;
    private int currentPos;
    private Node.BSTEntry nextValue;

    public BSTIteratorAll reset(BSTreePage root) {
        this.currentPage = root;
        this.currentPos = 0;
        if (this.findFirstLeafPage()) {
            this.findNext();
        }
        return this;
    }

    private boolean findFirstLeafPage() {
        while (!this.currentPage.isLeaf()) {
            if (this.currentPage.getNKeys() == -1) {
                this.currentPage = null;
                return false;
            }
            this.currentPage = this.currentPage.getPageByPos(0);
        }
        return true;
    }

    private void findNext() {
        while (this.currentPage != null) {
            if (this.currentPos >= this.currentPage.getNKeys()) {
                this.currentPage = this.currentPage.getNextLeaf();
                this.currentPos = 0;
                continue;
            }
            this.nextValue = this.currentPage.getValues()[this.currentPos];
            ++this.currentPos;
            return;
        }
    }

    public boolean hasNextEntry() {
        return this.currentPage != null;
    }

    public Node.BSTEntry nextEntry() {
        if (!this.hasNextEntry()) {
            throw new NoSuchElementException();
        }
        Node.BSTEntry ret = this.nextValue;
        this.findNext();
        return ret;
    }
}

