/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.v16;

import clib.phtree.PhEntry;
import clib.phtree.PhFilter;
import clib.phtree.v16.Node;
import clib.phtree.v16.bst.BSTIteratorMask;

public class NodeIteratorNoGC<T> {
    private Node node;
    private final BSTIteratorMask niIterator = new BSTIteratorMask();
    private long maskLower;
    private long maskUpper;
    private long[] rangeMin;
    private long[] rangeMax;
    private PhFilter checker;

    public NodeIteratorNoGC(int dims) {
    }

    private void reinit(Node node, long[] rangeMin, long[] rangeMax, PhFilter checker) {
        this.rangeMin = rangeMin;
        this.rangeMax = rangeMax;
        this.checker = checker;
        this.node = node;
        this.niIterator.reset(node.getRoot(), this.maskLower, this.maskUpper, node.getEntryCount());
    }

    boolean increment(PhEntry<T> result) {
        while (this.niIterator.hasNextEntry()) {
            Node.BSTEntry be = this.niIterator.nextEntry();
            if (!this.readValue(be, result)) continue;
            return true;
        }
        return false;
    }

    private boolean readValue(Node.BSTEntry candidate, PhEntry<T> result) {
        if (!this.node.checkAndGetEntry(candidate, result, this.rangeMin, this.rangeMax)) {
            return false;
        }
        if (candidate.getValue() instanceof Node) {
            Node sub = (Node)candidate.getValue();
            return this.checker == null || sub.getPostLen() >= 63 || this.checker.isValid(sub.getPostLen() + 1, candidate.getKdKey());
        }
        return this.checker == null || this.checker.isValid(candidate.getKdKey());
    }

    private void calcLimits(long[] rangeMin, long[] rangeMax, long[] prefix) {
        int postLen = this.node.getPostLen();
        long maskHcBit = 1L << postLen;
        long maskVT = -1L << postLen;
        long lowerLimit = 0L;
        long upperLimit = 0L;
        if (maskHcBit >= 0L) {
            for (int i = 0; i < rangeMin.length; ++i) {
                lowerLimit <<= 1;
                upperLimit <<= 1;
                long nodeBisection = (prefix[i] | maskHcBit) & maskVT;
                if (rangeMin[i] >= nodeBisection) {
                    lowerLimit |= 1L;
                }
                if (rangeMax[i] < nodeBisection) continue;
                upperLimit |= 1L;
            }
        } else {
            for (int i = 0; i < rangeMin.length; ++i) {
                lowerLimit <<= 1;
                upperLimit <<= 1;
                if (rangeMin[i] < 0L) {
                    upperLimit |= 1L;
                }
                if (rangeMax[i] >= 0L) continue;
                lowerLimit |= 1L;
            }
        }
        this.maskLower = lowerLimit;
        this.maskUpper = upperLimit;
    }

    void init(long[] rangeMin, long[] rangeMax, Node node, PhFilter checker, long[] prefix) {
        this.node = node;
        this.calcLimits(rangeMin, rangeMax, prefix);
        this.reinit(node, rangeMin, rangeMax, checker);
    }
}

