/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.v16;

import clib.phtree.PhEntry;
import clib.phtree.v16.Node;
import clib.phtree.v16.PhResultList;
import clib.phtree.v16.bst.BSTIteratorMask;
import java.util.List;

public class NodeIteratorListReuse<T, R> {
    private final PhResultList<T, R> results;
    private int maxResults;
    private long[] rangeMin;
    private long[] rangeMax;
    private final PhIteratorStack pool;

    NodeIteratorListReuse(PhResultList<T, R> results) {
        this.results = results;
        this.pool = new PhIteratorStack();
    }

    List<R> resetAndRun(Node node, long[] rangeMin, long[] rangeMax, int maxResults) {
        this.results.clear();
        this.rangeMin = rangeMin;
        this.rangeMax = rangeMax;
        this.maxResults = maxResults;
        this.run(node, null);
        return this.results;
    }

    private void run(Node node, long[] prefix) {
        NodeIterator nIt = this.pool.prepare();
        nIt.reinitAndRun(node, prefix);
        this.pool.pop();
    }

    private final class NodeIterator {
        private final BSTIteratorMask niIterator = new BSTIteratorMask();
        private long maskLower;
        private long maskUpper;

        private NodeIterator() {
        }

        void reinitAndRun(Node node, long[] prefix) {
            this.calcLimits(node, NodeIteratorListReuse.this.rangeMin, NodeIteratorListReuse.this.rangeMax, prefix);
            this.niIterator.reset(node.getRoot(), this.maskLower, this.maskUpper, node.getEntryCount());
            this.getAll();
        }

        private void checkAndRunSubnode(Node sub, long[] subPrefix) {
            if (NodeIteratorListReuse.this.results.phIsPrefixValid(subPrefix, sub.getPostLen() + 1)) {
                NodeIteratorListReuse.this.run(sub, subPrefix);
            }
        }

        private void readValue(Node.BSTEntry candidate) {
            PhEntry<Object> result = NodeIteratorListReuse.this.results.phGetTempEntry();
            result.setKeyInternal(candidate.getKdKey());
            result.setValueInternal(candidate.getValue());
            NodeIteratorListReuse.this.results.phOffer(result);
        }

        private void checkEntry(Node.BSTEntry be) {
            Object v = be.getValue();
            if (v instanceof Node) {
                this.checkAndRunSubnode((Node)v, be.getKdKey());
            } else if (v != null) {
                this.readValue(be);
            }
        }

        private void getAll() {
            this.niAllNext();
        }

        private void niAllNext() {
            this.niAllNextIterator();
        }

        private void niAllNextIterator() {
            while (this.niIterator.hasNextEntry() && NodeIteratorListReuse.this.results.size() < NodeIteratorListReuse.this.maxResults) {
                Node.BSTEntry be = this.niIterator.nextEntry();
                this.checkEntry(be);
            }
        }

        private void calcLimits(Node node, long[] rangeMin, long[] rangeMax, long[] prefix) {
            long maskHcBit = 1L << node.getPostLen();
            long maskVT = -1L << node.getPostLen();
            long lowerLimit = 0L;
            long upperLimit = 0L;
            if (maskHcBit >= 0L) {
                for (int i = 0; i < rangeMin.length; ++i) {
                    lowerLimit <<= 1;
                    upperLimit <<= 1;
                    long nodeBisection = (prefix[i] | maskHcBit) & maskVT;
                    if (rangeMin[i] >= nodeBisection) {
                        lowerLimit |= 1L;
                    }
                    if (rangeMax[i] < nodeBisection) continue;
                    upperLimit |= 1L;
                }
            } else {
                for (int i = 0; i < rangeMin.length; ++i) {
                    lowerLimit <<= 1;
                    upperLimit <<= 1;
                    if (rangeMin[i] < 0L) {
                        upperLimit |= 1L;
                    }
                    if (rangeMax[i] >= 0L) continue;
                    lowerLimit |= 1L;
                }
            }
            this.maskLower = lowerLimit;
            this.maskUpper = upperLimit;
        }
    }

    private class PhIteratorStack {
        private final NodeIterator[] stack = new NodeIterator[64];
        private int size = 0;

        private PhIteratorStack() {
        }

        NodeIterator prepare() {
            NodeIterator ni;
            if ((ni = this.stack[this.size++]) == null) {
                this.stack[this.size - 1] = ni = new NodeIterator();
            }
            return ni;
        }

        NodeIterator pop() {
            return this.stack[--this.size];
        }
    }
}

