/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.v13SynchedPool.nt;

import ch.ethz.globis.pht64kd.MaxKTreeI;
import clib.phtree.v13SynchedPool.nt.Bits;
import clib.phtree.v13SynchedPool.nt.NodeTreeV13;
import clib.phtree.v13SynchedPool.nt.NtNode;

public class NtNodeIteratorAll<T> {
    private static final long FINISHED = Long.MAX_VALUE;
    private static final long START = -1L;
    private boolean isHC;
    private long next;
    private NtNode<T> nextSubNode;
    private NtNode<T> node;
    private int currentOffsetKey;
    private int nMaxEntry;
    private int nFound = 0;
    private int postEntryLenLHC;
    private long prefix;
    private final long localMax;

    public NtNodeIteratorAll() {
        this.localMax = 255L;
    }

    private void reinit(NtNode<T> node, long prefix) {
        this.node = node;
        this.prefix = prefix;
        this.next = -1L;
        this.nextSubNode = null;
        this.currentOffsetKey = 0;
        this.nFound = 0;
        this.node = node;
        this.isHC = node.isAHC();
        this.nMaxEntry = node.getEntryCount();
        this.currentOffsetKey = node.getBitPosIndex();
        if (!this.isHC) {
            this.postEntryLenLHC = NtNode.IK_WIDTH(8) + 8 * node.getPostLen();
        }
    }

    boolean increment(MaxKTreeI.NtEntry<T> result) {
        this.getNext(result);
        return this.next != Long.MAX_VALUE;
    }

    long getCurrentPos() {
        return this.next;
    }

    boolean isNextSub() {
        return this.nextSubNode != null;
    }

    private boolean readValue(int pin, long pos, MaxKTreeI.NtEntry<T> result) {
        Object v = this.node.getValueByPIN(pin);
        if (v == null) {
            return false;
        }
        this.prefix = this.node.localReadAndApplyReadPostfixAndHc(pin, pos, this.prefix);
        if (v instanceof NtNode) {
            NtNode sub;
            this.nextSubNode = sub = (NtNode)v;
        } else {
            this.nextSubNode = null;
            this.node.getKdKeyByPIN(pin, result.getKdKey());
            result.setValue(v == NodeTreeV13.NT_NULL ? null : v);
        }
        result.setKey(this.prefix);
        return true;
    }

    private void getNext(MaxKTreeI.NtEntry<T> result) {
        if (this.isHC) {
            this.getNextAHC(result);
        } else {
            this.getNextLHC(result);
        }
    }

    private void getNextAHC(MaxKTreeI.NtEntry<T> result) {
        long currentPos;
        long l = currentPos = this.next == -1L ? 0L : this.next + 1L;
        while (currentPos <= this.localMax) {
            if (this.readValue((int)currentPos, currentPos, result)) {
                this.next = currentPos;
                return;
            }
            ++currentPos;
        }
        this.next = Long.MAX_VALUE;
    }

    private void getNextLHC(MaxKTreeI.NtEntry<T> result) {
        while (++this.nFound <= this.nMaxEntry) {
            long currentPos = Bits.readArray(this.node.ba, this.currentOffsetKey, NtNode.IK_WIDTH(8));
            this.currentOffsetKey += this.postEntryLenLHC;
            if (currentPos > this.localMax) break;
            if (!this.readValue(this.nFound - 1, currentPos, result)) continue;
            this.next = currentPos;
            return;
        }
        this.next = Long.MAX_VALUE;
    }

    public NtNode<T> getCurrentSubNode() {
        return this.nextSubNode;
    }

    public NtNode<T> node() {
        return this.node;
    }

    void init(long valTemplate, NtNode<T> node) {
        this.reinit(node, valTemplate);
    }

    public long getPrefix() {
        return this.prefix;
    }
}

