/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.v13;

import clib.phtree.PhEntry;
import clib.phtree.PhFilter;
import clib.phtree.v13.Bits;
import clib.phtree.v13.Node;

public class NodeIteratorFullNoGC<T> {
    private static final long FINISHED = Long.MAX_VALUE;
    private final int dims;
    private boolean isHC;
    private long next = -1L;
    private Node node;
    private int currentOffsetKey;
    private int nMaxEntries;
    private int nEntriesFound = 0;
    private int postEntryLenLHC;
    private final long[] valTemplate;
    private PhFilter checker;
    private final long maxPos;

    public NodeIteratorFullNoGC(int dims, long[] valTemplate) {
        this.dims = dims;
        this.maxPos = (1L << dims) - 1L;
        this.valTemplate = valTemplate;
    }

    private void reinit(Node node, PhFilter checker) {
        this.next = -1L;
        this.nEntriesFound = 0;
        this.checker = checker;
        this.node = node;
        this.isHC = node.isAHC();
        this.nMaxEntries = node.getEntryCount();
        this.currentOffsetKey = node.getBitPosIndex();
        this.postEntryLenLHC = Node.IK_WIDTH(this.dims) + this.dims * node.postLenStored();
    }

    boolean increment(PhEntry<T> result) {
        this.getNext(result);
        return this.next != Long.MAX_VALUE;
    }

    private boolean readValue(int posInNode, long hcPos, PhEntry<T> result) {
        long[] key = result.getKey();
        Object v = this.node.getEntryPIN(posInNode, hcPos, this.valTemplate, key);
        if (v == null) {
            return false;
        }
        if (v instanceof Node) {
            result.setNodeInternal(v);
        } else {
            if (this.checker != null && !this.checker.isValid(key)) {
                return false;
            }
            result.setValueInternal(v);
        }
        this.next = hcPos;
        return true;
    }

    private boolean readValue(long pos, long[] kdKey, Object value, PhEntry<T> result) {
        if (value instanceof Node) {
            Node sub = (Node)value;
            if (this.checker != null && !this.checker.isValid(sub.postLenStored() + 1, kdKey)) {
                return false;
            }
            System.arraycopy(kdKey, 0, this.valTemplate, 0, kdKey.length);
            result.setNodeInternal(sub);
        } else {
            if (this.checker != null && !this.checker.isValid(kdKey)) {
                return false;
            }
            System.arraycopy(kdKey, 0, result.getKey(), 0, kdKey.length);
            result.setValueInternal(value);
        }
        return true;
    }

    private void getNext(PhEntry<T> result) {
        if (this.isHC) {
            this.getNextAHC(result);
        } else {
            this.getNextLHC(result);
        }
    }

    private void getNextAHC(PhEntry<T> result) {
        long currentPos = this.next;
        do {
            if (++currentPos <= this.maxPos) continue;
            this.next = Long.MAX_VALUE;
            break;
        } while (!this.readValue((int)currentPos, currentPos, result));
    }

    private void getNextLHC(PhEntry<T> result) {
        long currentPos;
        do {
            if (++this.nEntriesFound > this.nMaxEntries) {
                this.next = Long.MAX_VALUE;
                break;
            }
            currentPos = Bits.readArray(this.node.ba(), this.currentOffsetKey, Node.IK_WIDTH(this.dims));
            this.currentOffsetKey += this.postEntryLenLHC;
        } while (!this.readValue(this.nEntriesFound - 1, currentPos, result));
    }

    void init(Node node, PhFilter checker) {
        this.reinit(node, checker);
    }
}

