/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.v11;

import clib.phtree.PhDistance;
import clib.phtree.PhDistanceL;
import clib.phtree.PhEntry;
import clib.phtree.PhFilter;
import clib.phtree.PhFilterDistance;
import clib.phtree.PhRangeQuery;
import clib.phtree.PhTree;
import clib.phtree.PhTreeConfig;
import clib.phtree.PhTreeHelper;
import clib.phtree.util.PhMapper;
import clib.phtree.util.PhTreeStats;
import clib.phtree.util.StringBuilderLn;
import clib.phtree.v11.Bits;
import clib.phtree.v11.Node;
import clib.phtree.v11.NodeIteratorListReuse;
import clib.phtree.v11.PhIteratorFullNoGC;
import clib.phtree.v11.PhIteratorNoGC;
import clib.phtree.v11.PhQueryKnnMbbPPList;
import clib.phtree.v11.PhResultList;
import clib.phtree.v11.nt.NodeTreeV11;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class PhTree11<T>
implements PhTree<T> {
    public static final boolean HCI_ENABLED = true;
    static final boolean AHC_ENABLED = true;
    public static final int LHC_BINARY_SEARCH_THRESHOLD = 50;
    static final int DEPTH_64 = 64;
    private static final int NO_INSERT_REQUIRED = Integer.MAX_VALUE;
    private final int dims;
    private final AtomicInteger nEntries = new AtomicInteger();
    private Node root = null;

    Node getRoot() {
        return this.root;
    }

    void changeRoot(Node newRoot) {
        this.root = newRoot;
    }

    public PhTree11(int dim) {
        this.dims = dim;
        PhTreeHelper.debugCheck();
    }

    public PhTree11(PhTreeConfig cnf) {
        this.dims = cnf.getDimActual();
        PhTreeHelper.debugCheck();
        switch (cnf.getConcurrencyType()) {
            case 0: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("type= " + cnf.getConcurrencyType());
            }
        }
    }

    void increaseNrEntries() {
        this.nEntries.incrementAndGet();
    }

    void decreaseNrEntries() {
        this.nEntries.decrementAndGet();
    }

    @Override
    public int size() {
        return this.nEntries.get();
    }

    @Override
    public PhTreeStats getStats() {
        return this.getStats(0, this.getRoot(), new PhTreeStats(64));
    }

    /*
     * WARNING - void declaration
     */
    private PhTreeStats getStats(int currentDepth, Node node, PhTreeStats stats) {
        int n;
        int n2;
        ++stats.nNodes;
        if (node.isAHC()) {
            ++stats.nAHC;
        }
        if (node.isNT()) {
            ++stats.nNT;
        }
        int n3 = node.getInfixLen();
        stats.infixHist[n3] = stats.infixHist[n3] + 1;
        int n4 = currentDepth;
        stats.nodeDepthHist[n4] = stats.nodeDepthHist[n4] + 1;
        int size = node.getEntryCount();
        int n5 = 32 - Integer.numberOfLeadingZeros(size);
        stats.nodeSizeLogHist[n5] = stats.nodeSizeLogHist[n5] + 1;
        stats.q_totalDepth += (currentDepth += node.getInfixLen());
        if (node.values() != null) {
            void var7_11;
            Object[] objectArray = node.values();
            int n6 = objectArray.length;
            boolean bl = false;
            while (var7_11 < n6) {
                Object o = objectArray[var7_11];
                if (o instanceof Node) {
                    this.getStats(currentDepth + 1, (Node)o, stats);
                } else if (o != null) {
                    int n7 = currentDepth;
                    stats.q_nPostFixN[n7] = stats.q_nPostFixN[n7] + 1;
                }
                ++var7_11;
            }
        } else {
            ArrayList<Object> entries = new ArrayList<Object>();
            NodeTreeV11.getStats(node.ind(), stats, this.dims, entries);
            for (Object e : entries) {
                if (e instanceof Node) {
                    this.getStats(currentDepth + 1, (Node)e, stats);
                    continue;
                }
                if (e == null) continue;
                int n8 = currentDepth;
                stats.q_nPostFixN[n8] = stats.q_nPostFixN[n8] + 1;
            }
            if (entries.size() != node.ntGetSize()) {
                System.err.println("WARNING: entry count mismatch: a-found/ec=" + entries.size() + "/" + node.getEntryCount());
            }
        }
        int REF = 4;
        stats.size += (long)PhTreeHelper.align8(31);
        int nChildren = node.getEntryCount();
        stats.size += (long)(16 + PhTreeHelper.align8(Bits.arraySizeInByte(node.ba)));
        stats.size = stats.size + (node.values() != null ? (long)(16 + PhTreeHelper.align8(node.values().length * 4)) : 0L);
        if (nChildren == 1 && node != this.getRoot() && this.nEntries.get() > 1) {
            System.err.println("WARNING: found lonely node...");
        }
        if (nChildren == 0 && node != this.getRoot()) {
            System.err.println("WARNING: found ZOMBIE node...");
        }
        if (this.dims <= 31 && (long)node.getEntryCount() > 1L << this.dims) {
            System.err.println("WARNING: Over-populated node found: ec=" + node.getEntryCount());
        }
        if ((n2 = Bits.calcArraySize(n = node.calcArraySizeTotalBits(node.getEntryCount(), this.dims))) < node.ba.length) {
            System.err.println("Array too large: " + node.ba.length + " - " + n2 + " = " + (node.ba.length - n2));
        }
        stats.nTotalChildren += nChildren;
        return stats;
    }

    @Override
    public T put(long[] key, T value) {
        Object nonNullValue;
        Object object = nonNullValue = value == null ? PhTreeHelper.NULL : value;
        if (this.getRoot() == null) {
            this.insertRoot(key, nonNullValue);
            return null;
        }
        Object o = this.getRoot();
        while (o instanceof Node) {
            Node currentNode = o;
            o = currentNode.doInsertIfMatching(key, nonNullValue, this);
        }
        return (T)o;
    }

    void insertRoot(long[] key, Object value) {
        this.root = Node.createNode(this.dims, 0, 63);
        long pos = PhTreeHelper.posInArray(key, this.root.getPostLen());
        this.root.addPostPIN(pos, -1, key, value);
        this.increaseNrEntries();
    }

    @Override
    public boolean contains(long ... key) {
        Object o = this.getRoot();
        while (o instanceof Node) {
            Node currentNode = o;
            o = currentNode.doIfMatching(key, true, null, null, null, this);
        }
        return o != null;
    }

    @Override
    public T get(long ... key) {
        Object o = this.getRoot();
        while (o instanceof Node) {
            Node currentNode = o;
            o = currentNode.doIfMatching(key, true, null, null, null, this);
        }
        return (T)(o == PhTreeHelper.NULL ? null : o);
    }

    @Override
    public T remove(long ... key) {
        Object o = this.getRoot();
        Node parentNode = null;
        while (o instanceof Node) {
            Node currentNode = o;
            o = currentNode.doIfMatching(key, false, parentNode, null, null, this);
            parentNode = currentNode;
        }
        return (T)o;
    }

    @Override
    public T update(long[] oldKey, long[] newKey) {
        Node value;
        Node[] stack = new Node[64];
        int stackSize = 0;
        Object o = this.getRoot();
        Node parentNode = null;
        int[] insertRequired = new int[]{Integer.MAX_VALUE};
        while (o instanceof Node) {
            Node currentNode = o;
            stack[stackSize++] = currentNode;
            o = currentNode.doIfMatching(oldKey, false, parentNode, newKey, insertRequired, this);
            parentNode = currentNode;
        }
        Node node = value = o == PhTreeHelper.NULL ? null : o;
        if (insertRequired[0] != Integer.MAX_VALUE) {
            if (stack[stackSize - 1].getEntryCount() == 0 && stackSize > 1) {
                --stackSize;
            }
            while (stackSize > 0) {
                if (stack[--stackSize].getPostLen() + 1 < insertRequired[0]) continue;
                o = stack[stackSize];
                while (o instanceof Node) {
                    Node currentNode = (Node)o;
                    o = currentNode.doInsertIfMatching(newKey, value, this);
                }
                insertRequired[0] = Integer.MAX_VALUE;
                break;
            }
        }
        return (T)value;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " AHC/LHC=" + 2.0 + " AHC-on=" + true + " HCI-on=" + true + " NtLimit=" + 150 + " NtMaxDim=" + 6 + " DEBUG=" + false;
    }

    @Override
    public String toStringPlain() {
        StringBuilderLn sb = new StringBuilderLn();
        if (this.getRoot() != null) {
            this.toStringPlain(sb, this.getRoot(), new long[this.dims]);
        }
        return sb.toString();
    }

    private void toStringPlain(StringBuilderLn sb, Node node, long[] key) {
        int i = 0;
        while ((long)i < 1L << this.dims) {
            Object o = node.getEntry(i, key);
            if (o != null) {
                if (o instanceof Node) {
                    this.toStringPlain(sb, (Node)o, key);
                } else {
                    sb.append(Bits.toBinary(key, 64));
                    sb.appendLn("  v=" + o);
                }
            }
            ++i;
        }
    }

    @Override
    public String toStringTree() {
        StringBuilderLn sb = new StringBuilderLn();
        if (this.getRoot() != null) {
            this.toStringTree(sb, 0, this.getRoot(), new long[this.dims], true);
        }
        return sb.toString();
    }

    private void toStringTree(StringBuilderLn sb, int currentDepth, Node node, long[] key, boolean printValue) {
        int i;
        String ind = "*";
        for (i = 0; i < currentDepth; ++i) {
            ind = ind + "-";
        }
        sb.append(ind + "il=" + node.getInfixLen() + " pl=" + node.getPostLen() + " ec=" + node.getEntryCount() + " inf=[");
        if (node.getInfixLen() > 0) {
            long mask = -1L << node.getInfixLen();
            mask ^= 0xFFFFFFFFFFFFFFFFL;
            mask <<= node.getPostLen() + 1;
            for (int i2 = 0; i2 < this.dims; ++i2) {
                sb.append(Bits.toBinary(key[i2] & mask) + ",");
            }
        }
        currentDepth += node.getInfixLen();
        sb.appendLn("]  " + node);
        i = 0;
        while ((long)i < 1L << this.dims) {
            Object o = node.getEntry(i, key);
            if (o != null) {
                if (o instanceof Node) {
                    sb.appendLn(ind + "# " + i + "  +");
                    this.toStringTree(sb, currentDepth + 1, (Node)o, key, printValue);
                } else {
                    sb.append(ind + Bits.toBinary(key, 64));
                    sb.append("  hcPos=" + i);
                    if (printValue) {
                        sb.append("  v=" + o);
                    }
                    sb.appendLn("");
                }
            }
            ++i;
        }
    }

    @Override
    public PhTree.PhExtent<T> queryExtent() {
        return new PhIteratorFullNoGC(this, null).reset();
    }

    @Override
    public PhTree.PhQuery<T> query(long[] min, long[] max) {
        if (min.length != this.dims || max.length != this.dims) {
            throw new IllegalArgumentException("Invalid number of arguments: " + min.length + " / " + max.length + "  DIM=" + this.dims);
        }
        PhIteratorNoGC q = new PhIteratorNoGC(this, null);
        q.reset(min, max);
        return q;
    }

    @Override
    public List<PhEntry<T>> queryAll(long[] min, long[] max) {
        return this.queryAll(min, max, Integer.MAX_VALUE, null, PhMapper.PVENTRY());
    }

    @Override
    public <R> List<R> queryAll(long[] min, long[] max, int maxResults, PhFilter filter, PhMapper<T, R> mapper) {
        if (min.length != this.dims || max.length != this.dims) {
            throw new IllegalArgumentException("Invalid number of arguments: " + min.length + " / " + max.length + "  DIM=" + this.dims);
        }
        if (this.getRoot() == null) {
            return new ArrayList();
        }
        PhResultList.MappingResultList<T, R> list = new PhResultList.MappingResultList<T, R>(null, mapper, () -> new PhEntry<Object>(new long[this.dims], null));
        NodeIteratorListReuse<T, R> it = new NodeIteratorListReuse<T, R>(this.dims, list);
        return it.resetAndRun(this.getRoot(), min, max, maxResults);
    }

    @Override
    public int getDim() {
        return this.dims;
    }

    @Override
    public int getBitDepth() {
        return 64;
    }

    @Override
    public PhTree.PhKnnQuery<T> nearestNeighbour(int nMin, long ... v) {
        return new PhQueryKnnMbbPPList(this).reset(nMin, PhDistanceL.THIS, v);
    }

    @Override
    public PhTree.PhKnnQuery<T> nearestNeighbour(int nMin, PhDistance dist, PhFilter dimsFilter, long ... center) {
        return new PhQueryKnnMbbPPList(this).reset(nMin, dist, center);
    }

    @Override
    public PhRangeQuery<T> rangeQuery(double dist, long ... center) {
        return this.rangeQuery(dist, null, center);
    }

    @Override
    public PhRangeQuery<T> rangeQuery(double dist, PhDistance optionalDist, long ... center) {
        PhFilterDistance filter = new PhFilterDistance();
        if (optionalDist == null) {
            optionalDist = PhDistanceL.THIS;
        }
        filter.set(center, optionalDist, dist);
        PhIteratorNoGC q = new PhIteratorNoGC(this, filter);
        PhRangeQuery qr = new PhRangeQuery(q, this, optionalDist, filter);
        qr.reset(dist, center);
        return qr;
    }

    @Override
    public void clear() {
        this.root = null;
        this.nEntries.set(0);
    }

    void adjustCounts(int deletedPosts) {
        this.nEntries.addAndGet(-deletedPosts);
    }

    static long inc(long v, long min, long max) {
        long r = v | max ^ 0xFFFFFFFFFFFFFFFFL;
        return ++r & max | min;
    }
}

