/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.v11;

import ch.ethz.globis.pht64kd.MaxKTreeI;
import clib.phtree.PhEntry;
import clib.phtree.PhFilter;
import clib.phtree.v11.Bits;
import clib.phtree.v11.Node;
import clib.phtree.v11.PhTree11;
import clib.phtree.v11.nt.NtIteratorMask;

public class NodeIteratorNoGC<T> {
    private static final long START = -1L;
    private final int dims;
    private boolean isHC;
    private boolean isNI;
    private long next;
    private Node node;
    private int currentOffsetKey;
    private NtIteratorMask<Object> niIterator;
    private int nMaxEntry;
    private int nFound = 0;
    private int postEntryLenLHC;
    private final long[] valTemplate;
    private long maskLower;
    private long maskUpper;
    private long[] rangeMin;
    private long[] rangeMax;
    private boolean useHcIncrementer;
    private boolean useNiHcIncrementer;
    private PhFilter checker;

    public NodeIteratorNoGC(int dims, long[] valTemplate) {
        this.dims = dims;
        this.valTemplate = valTemplate;
    }

    private void reinit(Node node, long[] rangeMin, long[] rangeMax, PhFilter checker) {
        this.rangeMin = rangeMin;
        this.rangeMax = rangeMax;
        this.next = -1L;
        this.currentOffsetKey = 0;
        this.nFound = 0;
        this.checker = checker;
        this.node = node;
        this.isHC = node.isAHC();
        this.isNI = node.isNT();
        this.nMaxEntry = node.getEntryCount();
        if (!this.isHC) {
            this.currentOffsetKey = node.getBitPosIndex();
            this.postEntryLenLHC = Node.IK_WIDTH(this.dims) + this.dims * node.getPostLen();
        }
        this.useHcIncrementer = false;
        this.useNiHcIncrementer = false;
        if (this.dims > 6) {
            this.initHCI();
        }
        if (this.isNI && !this.useNiHcIncrementer) {
            if (this.niIterator == null) {
                this.niIterator = new NtIteratorMask(this.dims);
            }
            this.niIterator.reset(node.ind(), this.maskLower, this.maskUpper);
        }
    }

    private void initHCI() {
        long maxHcAddr = -1L << this.dims ^ 0xFFFFFFFFFFFFFFFFL;
        int nSetFilterBits = Long.bitCount(this.maskLower | (this.maskUpper ^ 0xFFFFFFFFFFFFFFFFL) & maxHcAddr);
        long nPossibleMatch = 1L << this.dims - nSetFilterBits;
        if (this.isNI) {
            int logNChild;
            boolean useHcIncrementer;
            int nChild = this.node.ntGetSize();
            boolean bl = useHcIncrementer = (double)nChild > (double)nPossibleMatch * (double)(logNChild = 64 - Long.numberOfLeadingZeros(nChild)) * 2.0;
            this.useNiHcIncrementer = useHcIncrementer && this.dims < 50;
        } else {
            int logNPost;
            this.useHcIncrementer = this.isHC ? nPossibleMatch * 2L <= maxHcAddr : (double)this.nMaxEntry >= (double)(2L * nPossibleMatch) * (double)(logNPost = 64 - Long.numberOfLeadingZeros(this.nMaxEntry) + 1 + 1);
        }
    }

    boolean increment(PhEntry<T> result) {
        return this.getNext(result);
    }

    private boolean readValue(int pin, long pos, PhEntry<T> result) {
        Object o = this.node.checkAndGetEntryPIN(pin, pos, this.valTemplate, result.getKey(), this.rangeMin, this.rangeMax);
        if (o == null) {
            return false;
        }
        if (o instanceof Node) {
            Node sub = (Node)o;
            if (this.checker != null && sub.getPostLen() < 63 && !this.checker.isValid(sub.getPostLen() + 1, this.valTemplate)) {
                return false;
            }
            result.setNodeInternal(sub);
            return true;
        }
        if (this.checker != null && !this.checker.isValid(result.getKey())) {
            return false;
        }
        result.setValueInternal(o);
        return true;
    }

    private boolean readValue(long pos, Object value, PhEntry<T> result) {
        if (!this.node.checkAndGetEntryNt(pos, value, result, this.valTemplate, this.rangeMin, this.rangeMax)) {
            return false;
        }
        if (value instanceof Node) {
            Node sub = (Node)value;
            return this.checker == null || sub.getPostLen() >= 63 || this.checker.isValid(sub.getPostLen() + 1, this.valTemplate);
        }
        return this.checker == null || this.checker.isValid(result.getKey());
    }

    private boolean getNextHCI(PhEntry<T> result) {
        int pin;
        long currentPos = this.next;
        do {
            if (currentPos == -1L) {
                currentPos = this.maskLower;
                continue;
            }
            if ((currentPos = PhTree11.inc(currentPos, this.maskLower, this.maskUpper)) > this.maskLower) continue;
            return false;
        } while ((pin = this.node.getPosition(currentPos, this.dims)) < 0 || !this.readValue(pin, currentPos, result));
        this.next = currentPos;
        return true;
    }

    private boolean getNext(PhEntry<T> result) {
        if (this.isNI) {
            return this.niFindNext(result);
        }
        if (this.useHcIncrementer) {
            return this.getNextHCI(result);
        }
        if (this.isHC) {
            return this.getNextAHC(result);
        }
        return this.getNextLHC(result);
    }

    private boolean getNextAHC(PhEntry<T> result) {
        long currentPos;
        long l = currentPos = this.next == -1L ? this.maskLower - 1L : this.next;
        do {
            if (++currentPos <= this.maskUpper) continue;
            return false;
        } while (!this.checkHcPos(currentPos) || !this.readValue((int)currentPos, currentPos, result));
        this.next = currentPos;
        return true;
    }

    private boolean getNextLHC(PhEntry<T> result) {
        while (true) {
            if (++this.nFound > this.nMaxEntry) {
                return false;
            }
            long currentPos = Bits.readArray(this.node.ba, this.currentOffsetKey, Node.IK_WIDTH(this.dims));
            this.currentOffsetKey += this.postEntryLenLHC;
            if (this.checkHcPos(currentPos)) {
                if (!this.readValue(this.nFound - 1, currentPos, result)) continue;
                this.next = currentPos;
                return true;
            }
            if (currentPos > this.maskUpper) break;
        }
        return false;
    }

    private boolean niFindNext(PhEntry<T> result) {
        return this.useNiHcIncrementer ? this.niFindNextHCI(result) : this.niFindNextIter(result);
    }

    private boolean niFindNextIter(PhEntry<T> result) {
        while (this.niIterator.hasNext()) {
            MaxKTreeI.NtEntry<Object> e = this.niIterator.nextEntryReuse();
            System.arraycopy(e.getKdKey(), 0, result.getKey(), 0, this.dims);
            if (!this.readValue(e.key(), e.value(), result)) continue;
            this.next = e.getKey();
            return true;
        }
        return false;
    }

    private boolean niFindNextHCI(PhEntry<T> result) {
        long currentPos = this.next;
        while (currentPos == -1L || currentPos < this.maskUpper) {
            if (currentPos == -1L) {
                currentPos = this.maskLower;
            } else if ((currentPos = PhTree11.inc(currentPos, this.maskLower, this.maskUpper)) <= this.maskLower) break;
            Object v = this.node.ntGetEntry(currentPos, result.getKey(), this.valTemplate);
            if (v == null) continue;
            this.next = currentPos;
            if (!this.readValue(currentPos, v, result)) continue;
            return true;
        }
        return false;
    }

    private boolean checkHcPos(long pos) {
        return ((pos | this.maskLower) & this.maskUpper) == pos;
    }

    public Node node() {
        return this.node;
    }

    private void calcLimits(long[] rangeMin, long[] rangeMax) {
        int postLen = this.node.getPostLen();
        long maskHcBit = 1L << postLen;
        long maskVT = -1L << postLen;
        long lowerLimit = 0L;
        long upperLimit = 0L;
        if (maskHcBit >= 0L) {
            for (int i = 0; i < this.valTemplate.length; ++i) {
                lowerLimit <<= 1;
                upperLimit <<= 1;
                long nodeBisection = (this.valTemplate[i] | maskHcBit) & maskVT;
                if (rangeMin[i] >= nodeBisection) {
                    lowerLimit |= 1L;
                }
                if (rangeMax[i] < nodeBisection) continue;
                upperLimit |= 1L;
            }
        } else {
            for (int i = 0; i < this.valTemplate.length; ++i) {
                lowerLimit <<= 1;
                upperLimit <<= 1;
                if (rangeMin[i] < 0L) {
                    upperLimit |= 1L;
                }
                if (rangeMax[i] >= 0L) continue;
                lowerLimit |= 1L;
            }
        }
        this.maskLower = lowerLimit;
        this.maskUpper = upperLimit;
    }

    boolean adjustMinMax(long[] rangeMin, long[] rangeMax) {
        this.calcLimits(rangeMin, rangeMax);
        if (this.next >= this.maskUpper) {
            return false;
        }
        if (this.next < this.maskLower) {
            if (this.isHC) {
                this.currentOffsetKey = this.node.getBitPosIndex();
                this.next = -1L;
            } else if (this.isNI) {
                if (!this.useNiHcIncrementer) {
                    this.niIterator.adjustMinMax(this.maskLower, this.maskUpper);
                } else {
                    this.next = -1L;
                }
            } else {
                if (this.next + 50L < this.maskLower) {
                    int pin = this.node.getPosition(this.maskLower, this.dims);
                    pin = pin >= 0 ? pin : -(pin + 1);
                    this.currentOffsetKey = this.node.pinToOffsBitsLHC(pin, this.node.getBitPosIndex(), this.dims);
                    this.nFound = pin;
                }
                this.next = -1L;
            }
            return true;
        }
        if ((this.useHcIncrementer || this.useNiHcIncrementer) && !this.checkHcPos(this.next)) {
            long pos;
            for (pos = this.next - 1L; !this.checkHcPos(pos) && pos > -1L; --pos) {
            }
            this.next = pos;
        }
        return true;
    }

    void init(long[] rangeMin, long[] rangeMax, Node node, PhFilter checker) {
        this.node = node;
        this.calcLimits(rangeMin, rangeMax);
        this.reinit(node, rangeMin, rangeMax, checker);
    }

    boolean verifyMinMax() {
        long mask = -1L << this.node.getPostLen() + 1;
        for (int i = 0; i < this.valTemplate.length; ++i) {
            if ((this.valTemplate[i] | mask ^ 0xFFFFFFFFFFFFFFFFL) >= this.rangeMin[i] && (this.valTemplate[i] & mask) <= this.rangeMax[i]) continue;
            return false;
        }
        return true;
    }
}

