/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.util.unsynced;

import clib.phtree.PhTreeHelper;
import clib.phtree.util.BitTools;
import clib.phtree.v16hd.BitsHD;

public class LongArrayOps {
    private static final int UNIT_3 = 6;
    private static final int UNIT_BITS = 64;
    private static final int UNIT_0x1F = 63;
    private static final long UNIT_0xFF = -1L;
    private static final long UNIT_0x8000 = Long.MIN_VALUE;
    private static final int BYTES_PER_UNIT = 8;

    public static long readArrayOLd(long[] ba, int offsetBit, int entryLen) {
        int pA = offsetBit >>> 6;
        long ret = ba[pA];
        int semiLocalEnd = (offsetBit & 0x3F) + entryLen;
        if (semiLocalEnd <= 64) {
            ret >>>= 64 - semiLocalEnd;
        } else {
            ret <<= (semiLocalEnd -= 64);
            ret |= Long.rotateRight(ba[pA + 1], semiLocalEnd);
        }
        ret = entryLen == 64 ? ret : ret & (-1L << entryLen ^ 0xFFFFFFFFFFFFFFFFL);
        return ret;
    }

    public static long readArray(long[] ba, int offsetBit, int entryLen) {
        if (entryLen == 0) {
            return 0L;
        }
        int pA = offsetBit >>> 6;
        int srcLocStart = offsetBit & 0x3F;
        long mask1 = -1L >>> srcLocStart;
        long ret = ba[pA] & mask1;
        int srcLocalEnd = offsetBit + entryLen - 1 & 0x3F;
        ++srcLocalEnd;
        if (srcLocStart + entryLen > 64) {
            ret <<= srcLocalEnd;
            long mask2 = -1L >>> srcLocalEnd;
            ret |= Long.rotateLeft(ba[pA + 1] & (mask2 ^ 0xFFFFFFFFFFFFFFFFL), srcLocalEnd);
        } else {
            ret >>>= 64 - srcLocalEnd;
        }
        return ret;
    }

    public static void writeArray(long[] ba, int offsetBit, int entryLen, long val) {
        long mask2;
        if (entryLen == 0) {
            return;
        }
        int pA = offsetBit >>> 6;
        int startBit = offsetBit & 0x3F;
        int endPos = offsetBit + entryLen - 1;
        int endBit = endPos & 0x3F;
        long mask1 = -1L >>> startBit;
        long l = mask2 = ++endBit == 64 ? 0L : -1L >>> endBit;
        if (endBit <= startBit) {
            int n = pA;
            ba[n] = ba[n] & (mask1 ^ 0xFFFFFFFFFFFFFFFFL);
            int n2 = pA;
            ba[n2] = ba[n2] | val >>> offsetBit + entryLen & mask1;
            int n3 = pA + 1;
            ba[n3] = ba[n3] & mask2;
            int n4 = pA + 1;
            ba[n4] = ba[n4] | Long.rotateRight(val, endBit) & (mask2 ^ 0xFFFFFFFFFFFFFFFFL);
        } else {
            long mask = mask1 & (mask2 ^ 0xFFFFFFFFFFFFFFFFL);
            int n = pA;
            ba[n] = ba[n] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            int n5 = pA;
            ba[n5] = ba[n5] | val << 64 - endBit & mask;
        }
    }

    public static void insertBits1(long[] ba, int start, int nBits) {
        if (nBits == 0) {
            return;
        }
        long t1 = System.currentTimeMillis();
        int bitsToShift = ba.length * 64 - start - nBits;
        for (int i = 0; i < bitsToShift; ++i) {
            int srcBit = ba.length * 64 - nBits - i - 1;
            int trgBit = ba.length * 64 - i - 1;
            LongArrayOps.setBit(ba, trgBit, LongArrayOps.getBit(ba, srcBit));
        }
        long t2 = System.currentTimeMillis();
    }

    public static void insertBits(long[] ba, int start, int nBits) {
        int i;
        if (nBits == 0 || start + nBits >= ba.length * 64) {
            return;
        }
        int srcByteStart = start >>> 6;
        int srcLocalStart = start & 0x3F;
        int dstByteStart = start + nBits >>> 6;
        int dstLocalStart = start + nBits & 0x3F;
        int localShift = nBits & 0x3F;
        int nBytesShift = nBits >>> 6;
        if (localShift > 0) {
            for (i = ba.length - 1; i > dstByteStart; --i) {
                ba[i] = ba[i - nBytesShift] >>> localShift | ba[i - nBytesShift - 1] << -localShift;
            }
        } else {
            for (i = ba.length - 1; i > dstByteStart; --i) {
                ba[i] = ba[i - nBytesShift];
            }
        }
        long mask0 = -1L >>> dstLocalStart;
        if (dstLocalStart < srcLocalStart) {
            long buf1 = ba[srcByteStart + 1];
            ba[dstByteStart] = ba[dstByteStart] & (mask0 ^ 0xFFFFFFFFFFFFFFFFL) | Long.rotateRight(ba[srcByteStart], localShift) & mask0;
            long mask1 = mask0 >>> -srcLocalStart;
            ba[dstByteStart] = ba[dstByteStart] & (mask1 ^ 0xFFFFFFFFFFFFFFFFL) | buf1 >>> localShift & mask1;
        } else {
            ba[dstByteStart] = ba[dstByteStart] & (mask0 ^ 0xFFFFFFFFFFFFFFFFL) | Long.rotateRight(ba[srcByteStart], localShift) & mask0;
        }
    }

    public static void removeBits(long[] ba, int start, int nBits) {
        if (nBits == 0 || start + nBits >= ba.length * 64) {
            return;
        }
        int srcByteStart = start + nBits >>> 6;
        int srcLocalStart = start + nBits & 0x3F;
        int dstByteStart = start >>> 6;
        int dstLocalStart = start & 0x3F;
        int localShift = nBits & 0x3F;
        long mask0 = -1L >>> dstLocalStart;
        if (dstLocalStart <= srcLocalStart) {
            ba[dstByteStart] = (ba[dstByteStart] & (mask0 ^ 0xFFFFFFFFFFFFFFFFL) | Long.rotateLeft(ba[srcByteStart], localShift) & mask0) & -1L << localShift;
        } else {
            ba[dstByteStart] = ba[dstByteStart] & (mask0 ^ 0xFFFFFFFFFFFFFFFFL) | Long.rotateLeft(ba[srcByteStart], localShift) & mask0;
            ba[++dstByteStart] = ba[srcByteStart] << localShift;
            int n = dstByteStart;
            ba[n] = ba[n] & -1L << 64 - dstLocalStart;
        }
        if (localShift > 0) {
            for (int i = srcByteStart + 1; i < ba.length; ++i) {
                int n = dstByteStart++;
                ba[n] = ba[n] | ba[i] >>> -localShift;
                ba[dstByteStart] = ba[i] << localShift;
            }
        } else {
            for (int i = srcByteStart + 1; i < ba.length; ++i) {
                ba[++dstByteStart] = ba[i];
            }
        }
    }

    public static void copyBitsLeft(long[] src, int posSrc, long[] trg, int posTrg, int nBits) {
        if (nBits == 0) {
            return;
        }
        int srcByteStart = posSrc >>> 6;
        int srcLocalStart = posSrc & 0x3F;
        int dstByteStart = posTrg >>> 6;
        int dstLocalStart = posTrg & 0x3F;
        if (srcLocalStart + nBits <= 64) {
            LongArrayOps.writeArray(trg, posTrg, nBits, src[srcByteStart] >>> 64 - nBits - srcLocalStart);
            return;
        }
        if (dstLocalStart + nBits <= 64) {
            int lenSrc1 = 64 - srcLocalStart;
            LongArrayOps.writeArray(trg, posTrg, lenSrc1, src[srcByteStart]);
            LongArrayOps.writeArray(trg, posTrg + lenSrc1, nBits - lenSrc1, src[srcByteStart + 1] >>> 64 - nBits + lenSrc1);
            return;
        }
        if (posSrc == posTrg) {
            if (srcLocalStart != 0) {
                long mask = -1L >>> srcLocalStart;
                trg[dstByteStart] = trg[dstByteStart] & (mask ^ 0xFFFFFFFFFFFFFFFFL) | src[srcByteStart] & mask;
                ++dstByteStart;
                ++srcByteStart;
                nBits = nBits - 64 + srcLocalStart;
            }
            int byteLen = nBits >>> 6;
            System.arraycopy(src, srcByteStart, trg, dstByteStart, byteLen);
            int len2 = nBits & 0x3F;
            if (len2 > 0) {
                long mask = -1L >>> len2;
                trg[dstByteStart += byteLen] = trg[dstByteStart] & mask | src[srcByteStart += byteLen] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
            }
            return;
        }
        long mask0 = -1L >>> dstLocalStart;
        if (dstLocalStart < srcLocalStart) {
            int rotLeft = srcLocalStart - dstLocalStart;
            trg[dstByteStart] = trg[dstByteStart] & (mask0 ^ 0xFFFFFFFFFFFFFFFFL) | Long.rotateLeft(src[srcByteStart], rotLeft) & mask0;
            ++srcByteStart;
            int move = 64 - srcLocalStart;
            srcLocalStart = 0;
            posSrc += move;
            posTrg += move;
            nBits -= move;
            mask0 = -1L >>> (dstLocalStart += move);
        }
        int rotRight = dstLocalStart - srcLocalStart;
        trg[dstByteStart] = trg[dstByteStart] & (mask0 ^ 0xFFFFFFFFFFFFFFFFL) | Long.rotateRight(src[srcByteStart], rotRight) & mask0;
        ++dstByteStart;
        int lastFullSrcByte = (posSrc + nBits >>> 6) - 1;
        long maskRotRight = -1L >>> rotRight;
        while (srcByteStart < lastFullSrcByte) {
            trg[dstByteStart] = trg[dstByteStart] & maskRotRight | Long.rotateRight(src[srcByteStart], rotRight) & (maskRotRight ^ 0xFFFFFFFFFFFFFFFFL);
            trg[dstByteStart] = trg[dstByteStart] & (maskRotRight ^ 0xFFFFFFFFFFFFFFFFL) | Long.rotateRight(src[++srcByteStart], rotRight) & maskRotRight;
            ++dstByteStart;
        }
        if (dstByteStart >= trg.length) {
            return;
        }
        int dstLocalEnd = posTrg + nBits;
        if (srcByteStart > lastFullSrcByte) {
            long maskEnd = -1L >>> (dstLocalEnd & 0x3F);
            trg[dstByteStart] = trg[dstByteStart] & maskEnd | Long.rotateRight(src[srcByteStart], rotRight) & (maskEnd ^ 0xFFFFFFFFFFFFFFFFL);
            return;
        }
        trg[dstByteStart] = trg[dstByteStart] & maskRotRight | Long.rotateRight(src[srcByteStart], rotRight) & (maskRotRight ^ 0xFFFFFFFFFFFFFFFFL);
        if (++srcByteStart * 64 > posSrc + nBits - 1) {
            return;
        }
        long maskEnd = -1L >>> (dstLocalEnd & 0x3F);
        if (dstByteStart < dstLocalEnd - 1 >>> 6) {
            trg[dstByteStart] = trg[dstByteStart] & (maskRotRight ^ 0xFFFFFFFFFFFFFFFFL) | Long.rotateRight(src[srcByteStart], rotRight) & maskRotRight;
            trg[++dstByteStart] = trg[dstByteStart] & maskEnd | Long.rotateRight(src[srcByteStart], rotRight) & (maskEnd ^ 0xFFFFFFFFFFFFFFFFL);
        } else if (maskEnd != -1L) {
            long maskEnd2 = (maskEnd ^ 0xFFFFFFFFFFFFFFFFL) & maskRotRight;
            trg[dstByteStart] = trg[dstByteStart] & (maskEnd2 ^ 0xFFFFFFFFFFFFFFFFL) | Long.rotateRight(src[srcByteStart], rotRight) & maskEnd2;
        } else {
            trg[dstByteStart] = trg[dstByteStart] & (maskRotRight ^ 0xFFFFFFFFFFFFFFFFL) | Long.rotateRight(src[srcByteStart], rotRight) & maskRotRight;
        }
    }

    public static boolean getBit(long[] ba, int posBit) {
        int pA = posBit >>> 6;
        return (ba[pA] & Long.MIN_VALUE >>> (posBit &= 0x3F)) != 0L;
    }

    public static long getBit01(long[] ba, int posBit) {
        int pA = posBit >>> 6;
        return (ba[pA] & Long.MIN_VALUE >>> (posBit &= 0x3F)) != 0L ? 1L : 0L;
    }

    public static void setBit(long[] ba, int posBit, boolean b) {
        int pA = posBit >>> 6;
        posBit &= 0x3F;
        if (b) {
            int n = pA;
            ba[n] = ba[n] | Long.MIN_VALUE >>> posBit;
        } else {
            int n = pA;
            ba[n] = ba[n] & (Long.MIN_VALUE >>> posBit ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public static int findNext1Bit(long[] ba, int posBitStart, int posBitMax) {
        int pA = posBitStart >>> 6;
        int posInSlot = posBitStart & 0x3F;
        long x = ba[pA] << posInSlot;
        if (x != 0L) {
            return Long.numberOfLeadingZeros(x) + posInSlot;
        }
        int pAMax = posBitMax >>> 6;
        while (ba[++pA] == 0L && pA < pAMax) {
        }
        int lz = Long.numberOfLeadingZeros(ba[pA]);
        int newPos = pA * 64 + lz;
        return newPos <= posBitMax ? newPos : -1;
    }

    public static int binarySearch(long[] ba, int startBit, int nEntries, long key, int keyWidth, int valueWidth) {
        int entryWidth = keyWidth + valueWidth;
        int min = 0;
        int max = nEntries - 1;
        while (min <= max) {
            int mid = min + max >>> 1;
            long midKey = LongArrayOps.readArray(ba, mid * entryWidth + startBit, keyWidth);
            if (midKey < key) {
                min = mid + 1;
                continue;
            }
            if (midKey > key) {
                max = mid - 1;
                continue;
            }
            return mid;
        }
        return -(min + 1);
    }

    public static boolean hasConflictingBits(long v1, long v2, int rangeMax) {
        int rmMod64 = BitsHD.mod64(rangeMax);
        long mask = rmMod64 == 63 ? -1L : -1L << rmMod64 + 1 ^ 0xFFFFFFFFFFFFFFFFL;
        long x = (v1 ^ v2) & mask;
        return x != 0L;
    }

    public static int getMaxConflictingBits(long v1, long v2, int rangeMax) {
        int rmMod64 = BitsHD.mod64(rangeMax);
        long mask = rmMod64 == 63 ? -1L : -1L << rmMod64 + 1 ^ 0xFFFFFFFFFFFFFFFFL;
        long x = (v1 ^ v2) & mask;
        return 64 - Long.numberOfLeadingZeros(x);
    }

    public static int getMaxConflictingBits(long v1, long v2, int rangeMin, int rangeMax) {
        int rmMod64 = BitsHD.mod64(rangeMax);
        long mask = rmMod64 == 63 ? -1L : -1L << rmMod64 + 1 ^ 0xFFFFFFFFFFFFFFFFL;
        long x = (v1 ^ v2) & mask;
        int cb = 64 - Long.numberOfLeadingZeros(x);
        return cb > rangeMin ? cb : 0;
    }

    public static boolean hasConflictingBits(long v1, long v2, int rangeMin, int rangeMax) {
        int rmMod64 = BitsHD.mod64(rangeMax);
        long mask = rmMod64 == 63 ? -1L : -1L << rmMod64 + 1 ^ 0xFFFFFFFFFFFFFFFFL;
        long x = (v1 ^ v2) & mask;
        int cb = 64 - Long.numberOfLeadingZeros(x);
        return cb > rangeMin;
    }

    public static boolean checkRange(long[] candidate, long[] rangeMin, long[] rangeMax) {
        for (int i = 0; i < candidate.length; ++i) {
            long k = candidate[i];
            if (k >= rangeMin[i] && k <= rangeMax[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean checkPrefix(long[] v1, long[] v2, int bitsToIgnore) {
        if (bitsToIgnore == 64) {
            return true;
        }
        long mask = -1L << bitsToIgnore;
        for (int i = 0; i < v1.length; ++i) {
            if (((v1[i] ^ v2[i]) & mask) == 0L) continue;
            return false;
        }
        return true;
    }

    public static int calcArraySize(int nBits) {
        int arraySize = nBits + PhTreeHelper.ALLOC_BATCH_SIZE_LONG >>> 6;
        int size = PhTreeHelper.ALLOC_BATCH_SIZE;
        arraySize = arraySize / size * size;
        return arraySize;
    }

    public static int arraySizeInByte(long[] ba) {
        return ba.length * 8;
    }

    public static int arraySizeInByte(int arrayLength) {
        return arrayLength * 8;
    }

    public static void arraycopy(long[] src, int srcPos, long[] dst, int dstPos, int len) {
        if (len < 10) {
            for (int i = 0; i < len; ++i) {
                dst[dstPos + i] = src[srcPos + i];
            }
        } else {
            System.arraycopy(src, srcPos, dst, dstPos, len);
        }
    }

    public static String toBinary(long l) {
        return LongArrayOps.toBinary(l, 64);
    }

    public static String toBinary(long l, int DEPTH) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < DEPTH; ++i) {
            long mask = 1L << (int)((long)(DEPTH - i - 1));
            if ((l & mask) != 0L) {
                sb.append("1");
            } else {
                sb.append("0");
            }
            if ((i + 1) % 8 != 0 || i + 1 >= DEPTH) continue;
            sb.append('.');
        }
        return sb.toString();
    }

    public static String toBinary(long[] la, int DEPTH) {
        StringBuilder sb = new StringBuilder();
        for (long l : la) {
            sb.append(LongArrayOps.toBinary(l, DEPTH));
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String toBinary(int[] la, int DEPTH) {
        StringBuilder sb = new StringBuilder();
        int[] nArray = la;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            long l = nArray[i];
            sb.append(LongArrayOps.toBinary(l, DEPTH));
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String toBinary(long[] ba) {
        StringBuilder sb = new StringBuilder();
        for (long l : ba) {
            sb.append(LongArrayOps.toBinary(l, 64));
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String toBinary(double[] ba) {
        StringBuilder sb = new StringBuilder();
        for (double d : ba) {
            sb.append(LongArrayOps.toBinary(BitTools.toSortableLong(d), 64));
            sb.append(", ");
        }
        return sb.toString();
    }
}

