/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.util;

import clib.phtree.PhTreeHelper;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;

public class RefsLong {
    private static final long[] EMPTY_REF_ARRAY = new long[0];
    private static final ArrayPoolN POOL = new ArrayPoolN(PhTreeHelper.ARRAY_POOLING_MAX_ARRAY_SIZE, PhTreeHelper.ARRAY_POOLING_POOL_SIZE);

    private RefsLong() {
    }

    private static int calcArraySize(int nLong) {
        return nLong;
    }

    public static long[] arrayCreate(int size) {
        return POOL.getArray(RefsLong.calcArraySize(size));
    }

    public static long[] arrayReplace(long[] oldA, long[] newA) {
        if (oldA != null) {
            POOL.offer(oldA);
        }
        return newA;
    }

    public static long[] arrayClone(long[] oldA) {
        long[] newA = RefsLong.arrayCreate(oldA.length);
        RefsLong.arraycopy(oldA, 0, newA, 0, oldA.length);
        return newA;
    }

    public static void writeArray(long[] src, long[] dst, int dstPos) {
        RefsLong.arraycopy(src, 0, dst, dstPos, src.length);
    }

    public static void writeArray(long[] src, int srcPos, long[] dst, int dstPos, int length) {
        RefsLong.arraycopy(src, srcPos, dst, dstPos, length);
    }

    public static void readArray(long[] src, int srcPos, long[] dst) {
        RefsLong.arraycopy(src, srcPos, dst, 0, dst.length);
    }

    public static long[] insertArray(long[] oldA, long[] insertA, int dstPos) {
        long[] ret = RefsLong.arrayCreate(oldA.length + insertA.length);
        RefsLong.arraycopy(oldA, 0, ret, 0, dstPos);
        RefsLong.arraycopy(insertA, 0, ret, dstPos, insertA.length);
        RefsLong.arraycopy(oldA, dstPos, ret, dstPos + insertA.length, oldA.length - dstPos);
        POOL.offer(oldA);
        return ret;
    }

    public static long[] arrayRemove(long[] oldA, int dstPos, int length) {
        long[] ret = RefsLong.arrayCreate(oldA.length - length);
        RefsLong.arraycopy(oldA, 0, ret, 0, dstPos);
        RefsLong.arraycopy(oldA, dstPos + length, ret, dstPos, ret.length - dstPos);
        POOL.offer(oldA);
        return ret;
    }

    public static void arraycopy(long[] src, int srcPos, long[] dst, int dstPos, int len) {
        if (len < 10) {
            for (int i = 0; i < len; ++i) {
                dst[dstPos + i] = src[srcPos + i];
            }
        } else {
            System.arraycopy(src, srcPos, dst, dstPos, len);
        }
    }

    public static void write(long[] a, ObjectOutput out) throws IOException {
        out.writeInt(a.length);
        for (int i = 0; i < a.length; ++i) {
            out.writeLong(a[i]);
        }
    }

    public static long[] read(ObjectInput in) throws IOException {
        int size = in.readInt();
        long[] ret = POOL.getArray(size);
        for (int i = 0; i < size; ++i) {
            ret[i] = in.readLong();
        }
        return ret;
    }

    private static class ArrayPoolN {
        private final int maxArraySize;
        private final int maxArrayCount;
        long[][][] pool;
        int[] poolSize;

        ArrayPoolN(int maxArraySize, int maxArrayCount) {
            this.maxArraySize = maxArraySize;
            this.maxArrayCount = maxArrayCount;
            this.pool = new long[maxArraySize + 1][maxArrayCount][];
            this.poolSize = new int[maxArraySize + 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long[] getArray(int size) {
            if (size == 0) {
                return EMPTY_REF_ARRAY;
            }
            if (size > this.maxArraySize || !PhTreeHelper.ARRAY_POOLING) {
                return new long[size];
            }
            ArrayPoolN arrayPoolN = this;
            synchronized (arrayPoolN) {
                int ps = this.poolSize[size];
                if (ps > 0) {
                    int n = size;
                    this.poolSize[n] = this.poolSize[n] - 1;
                    long[] ret = this.pool[size][ps - 1];
                    Arrays.fill(ret, 0L);
                    return ret;
                }
            }
            return new long[size];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void offer(long[] a) {
            int size = a.length;
            if (size == 0 || size > this.maxArraySize || !PhTreeHelper.ARRAY_POOLING) {
                return;
            }
            ArrayPoolN arrayPoolN = this;
            synchronized (arrayPoolN) {
                int ps = this.poolSize[size];
                if (ps < this.maxArrayCount) {
                    this.pool[size][ps] = a;
                    int n = size;
                    this.poolSize[n] = this.poolSize[n] + 1;
                }
            }
        }
    }
}

