/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.util;

public class BitsShort {
    private static final int UNIT_3 = 4;
    private static final int UNIT_BITS = 16;
    private static final int UNIT_0x07 = 15;
    private static final long UNIT_0xFF = 65535L;
    private static final long UNIT_0xFF00 = -65536L;
    private static final int BYTES_PER_UNIT = 2;
    static int statACreate = 0;
    static int statAExpand = 0;
    static int statATrim = 0;
    static int statOldRightShift = 0;
    static int statOldRightShiftTime = 0;

    public static long readArray(short[] ba, int offsetBit, int entryLen) {
        int pA = offsetBit >>> 4;
        int startBit = 16 - (offsetBit & 0xF);
        long ret = 0L;
        int bitsRead = 0;
        while (bitsRead < entryLen) {
            long mask = (1L << startBit) - 1L;
            if (bitsRead + startBit > entryLen) {
                int bitsToIgnore = bitsRead + startBit - entryLen;
                long mask2 = (1L << bitsToIgnore) - 1L;
                bitsRead += 100000;
                ret <<= 16 - bitsToIgnore;
                ret |= ((long)ba[pA] & (mask &= mask2 ^ 0xFFFFFFFFFFFFFFFFL)) >>> bitsToIgnore;
            } else {
                bitsRead += startBit;
                ret <<= 16;
                ret |= (long)ba[pA] & mask;
            }
            startBit = 16;
            ++pA;
        }
        return ret;
    }

    public static void writeArray(short[] ba, int offsetBit, int entryLen, long val) {
        int bitsToWrite;
        int pA = offsetBit >>> 4;
        int startBit = 16 - (offsetBit & 0xF);
        for (int bitsWritten = 0; bitsWritten < entryLen; bitsWritten += bitsToWrite) {
            long eraseMask = (1L << startBit) - 1L;
            bitsToWrite = startBit;
            if (bitsWritten + bitsToWrite > entryLen) {
                int bitsToIgnore = bitsWritten + startBit - entryLen;
                long mask2 = (1L << bitsToIgnore) - 1L;
                eraseMask &= mask2 ^ 0xFFFFFFFFFFFFFFFFL;
                bitsToWrite -= bitsToIgnore;
            }
            int n = pA;
            ba[n] = (short)((long)ba[n] & (eraseMask ^ 0xFFFFFFFFFFFFFFFFL));
            int toShift = entryLen - (bitsWritten + startBit);
            long infTemp = toShift > 0 ? val >>> toShift : val << -toShift;
            long maskToCutOfHeadingBits = (1L << startBit) - 1L;
            int n2 = pA++;
            ba[n2] = (short)((long)ba[n2] | (infTemp &= maskToCutOfHeadingBits));
            startBit = 16;
        }
    }

    public static void insertBits1(short[] ba, int start, int nBits) {
        if (nBits == 0) {
            return;
        }
        if (nBits < 0) {
            throw new IllegalArgumentException();
        }
        ++statOldRightShift;
        long t1 = System.currentTimeMillis();
        int bitsToShift = ba.length * 16 - start - nBits;
        for (int i = 0; i < bitsToShift; ++i) {
            int srcBit = ba.length * 16 - nBits - i - 1;
            int trgBit = ba.length * 16 - i - 1;
            BitsShort.setBit(ba, trgBit, BitsShort.getBit(ba, srcBit));
        }
        long t2 = System.currentTimeMillis();
        statOldRightShiftTime = (int)((long)statOldRightShiftTime + (t2 - t1));
    }

    public static void insertBits(short[] ba, int start, int nBits) {
        if (nBits == 0) {
            return;
        }
        if (nBits < 0) {
            throw new IllegalArgumentException();
        }
        ++statOldRightShift;
        long t1 = System.currentTimeMillis();
        int nBytes = (int)Math.ceil((double)nBits / 16.0);
        int startByte = start >> 4;
        int bytesToCopy = ba.length - (startByte + nBytes);
        short tmp = ba[ba.length - nBytes];
        if (bytesToCopy != 0) {
            System.arraycopy(ba, startByte, ba, startByte + nBytes, bytesToCopy);
            int nBitsToMoveLeft = nBytes * 16 - nBits;
            BitsShort.removeBits(ba, start + nBits, nBitsToMoveLeft);
            int offs = 16 - nBitsToMoveLeft;
            BitsShort.copyBitsLeft(new short[]{tmp}, 0, ba, (ba.length - 1) * 16 + offs, nBitsToMoveLeft);
        } else {
            int offsTmp = start & 0xF;
            if (start + nBits < ba.length * 16) {
                int offsTrg = start + nBits & 0xF;
                int len = 16 - offsTrg;
                BitsShort.copyBitsLeft(new short[]{tmp}, offsTmp, ba, (ba.length - 1) * 16 + offsTrg, len);
            }
        }
        long t2 = System.currentTimeMillis();
        statOldRightShiftTime = (int)((long)statOldRightShiftTime + (t2 - t1));
    }

    public static void removeBits(short[] ba, int start, int nBits) {
        if (nBits == 0) {
            return;
        }
        if (nBits < 0) {
            throw new IllegalArgumentException("nBits = " + nBits);
        }
        BitsShort.copyBitsLeft(ba, start + nBits, ba, start, ba.length * 16 - start - nBits);
    }

    public static void copyBitsLeft(short[] src, int posSrc, short[] trg, int posTrg) {
        int len = src.length * 16 - posSrc;
        BitsShort.copyBitsLeft(src, posSrc, trg, posTrg, len);
    }

    public static void copyBitsLeft(short[] src, int posSrc, short[] trg, int posTrg, int len) {
        if (len == 0) {
            return;
        }
        boolean DBG = false;
        if (posSrc < 0 || posTrg < 0) {
            throw new IllegalArgumentException("s=" + posSrc + " t=" + posTrg);
        }
        if (posSrc + len > src.length * 16 || posTrg + len > trg.length * 16) {
            throw new IllegalArgumentException("s=" + posSrc + " t=" + posTrg + " len=" + len + "  srcLen/trgLen = " + src.length + " / " + trg.length + " // " + 16);
        }
        long buf = 0L;
        int psA = posSrc >>> 4;
        int startBitS = 16 - (posSrc & 0xF);
        int ptA = posTrg >>> 4;
        int startBitT_lr = posTrg & 0xF;
        int startBitT = 16 - (posTrg & 0xF);
        int bitsInBuffer = 0;
        int bitsToCopy = len;
        int bitsRead = 0;
        int bitsWritten = 0;
        if (startBitS != 16) {
            long mask = (1L << startBitS) - 1L;
            buf |= (long)src[psA] & mask;
            bitsInBuffer = startBitS;
            bitsRead = startBitS;
            ++psA;
            if (bitsRead > bitsToCopy) {
                buf >>>= bitsRead - bitsToCopy;
                bitsRead = bitsToCopy;
                bitsInBuffer = bitsToCopy;
            }
        }
        long eraseMask = (1L << startBitT) - 1L;
        eraseMask ^= 0xFFFFFFFFFFFFFFFFL;
        int bitsToWriteThisRound = startBitT < len ? startBitT : len;
        boolean readingFinished = false;
        boolean writingFinished = false;
        while (!readingFinished || !writingFinished) {
            if (bitsRead < bitsToCopy) {
                buf <<= 16;
                buf |= (long)src[psA] & 0xFFFFL;
                bitsInBuffer += 16;
                if ((bitsRead += 16) >= bitsToCopy) {
                    readingFinished = true;
                    if (bitsRead > bitsToCopy) {
                        int d = bitsRead - bitsToCopy;
                        buf >>>= d;
                        bitsRead -= d;
                        bitsInBuffer -= d;
                    }
                }
            } else {
                readingFinished = true;
            }
            if (startBitT_lr + bitsInBuffer < 16) break;
            long buf2 = buf;
            buf2 >>>= bitsInBuffer - bitsToWriteThisRound;
            if (bitsToWriteThisRound > bitsInBuffer) {
                buf2 = buf << bitsToWriteThisRound - bitsInBuffer;
                eraseMask = ~(-1 << bitsToWriteThisRound - bitsInBuffer);
            }
            int n = ptA;
            trg[n] = (short)((long)trg[n] & eraseMask);
            startBitT = 16;
            int n2 = ptA++;
            trg[n2] = (short)((long)trg[n2] | (buf2 &= 0xFFFFL));
            eraseMask = 0L;
            bitsInBuffer -= bitsToWriteThisRound;
            bitsToWriteThisRound = 16;
            ++psA;
            if (bitsToCopy - (bitsWritten += bitsToWriteThisRound) > 16) continue;
            writingFinished = true;
        }
        if (bitsWritten < bitsToCopy) {
            int bitsToWrite = bitsToCopy - bitsWritten;
            if (bitsWritten == 0) {
                eraseMask = 65535L >>> bitsToWrite | 0xFFFFFFFFFFFF0000L;
                eraseMask >>>= 16 - startBitT;
                buf <<= startBitT - bitsToWrite;
            } else {
                eraseMask = 65535L >>> bitsToWrite;
                buf <<= 16 - bitsToWrite;
            }
            int n = ptA;
            trg[n] = (short)((long)trg[n] & eraseMask);
            int n3 = ptA;
            trg[n3] = (short)((long)trg[n3] | buf);
        }
    }

    public static void copyBitsRight(short[] src, int posSrc, short[] trg, int posTrg, int len) {
        if (len == 0) {
            return;
        }
        boolean DBG = false;
        if (posSrc < 0 || posTrg < 0) {
            throw new IllegalArgumentException("s=" + posSrc + " t=" + posTrg);
        }
        if (posSrc + len > src.length * 16 || posTrg + len > trg.length * 16) {
            throw new IllegalArgumentException("s=" + posSrc + " t=" + posTrg + " len=" + len);
        }
        long buf = 0L;
        int startBitS = 16 - (posSrc & 0xF);
        int startBitT_lr = posTrg & 0xF;
        int startBitT = 16 - (posTrg & 0xF);
        boolean bitsInBuffer = false;
        int bitsToCopy = len;
        boolean bitsRead = false;
        boolean bitsWritten = false;
        int psA = posSrc + len - 1 >>> 4;
        int ptA = posTrg + len - 1 >>> 4;
        int endBitS = posSrc + len - 1 & 0xF;
        int endBitT = posTrg + len - 1 & 0xF;
        if (endBitS != 15 && endBitS + 1 - bitsToCopy >= 0) {
            buf = (long)src[psA] & 0xFFFFL;
            long eraseMask = 65535L >>> len | 0xFFFFFFFFFFFF0000L;
            buf >>>= endBitT - endBitS;
            int n = ptA;
            trg[n] = (short)((long)trg[n] & eraseMask);
            int n2 = ptA;
            trg[n2] = (short)((long)trg[n2] | (buf &= (eraseMask >>>= endBitT + 1 - len) ^ 0xFFFFFFFFFFFFFFFFL));
            return;
        }
        throw new RuntimeException();
    }

    public static boolean getBit(short[] ba, int posBit) {
        int pA = posBit >>> 4;
        return ((long)ba[pA] & 1L << 15 - (posBit &= 0xF)) != 0L;
    }

    public static void setBit(short[] ba, int posBit, boolean b) {
        int pA = posBit >>> 4;
        posBit &= 0xF;
        if (b) {
            int n = pA;
            ba[n] = (short)((long)ba[n] | 1L << 15 - posBit);
        } else {
            int n = pA;
            ba[n] = (short)((long)ba[n] & (1L << 15 - posBit ^ 0xFFFFFFFFFFFFFFFFL));
        }
    }

    public static int binarySearch(short[] ba, int startBit, int nValues, int val, int valWidth) {
        int min = 0;
        int max = nValues - 1;
        while (min <= max) {
            int mid = min + max >>> 1;
            long midVal = BitsShort.readArray(ba, mid * valWidth + startBit, valWidth);
            if (midVal < (long)val) {
                min = mid + 1;
                continue;
            }
            if (midVal > (long)val) {
                max = mid - 1;
                continue;
            }
            return mid;
        }
        return -(min + 1);
    }

    public static int calcArraySize(int nBits) {
        int arraySize = nBits >>> 3;
        if ((arraySize >>>= 3) * 8 * 8 < nBits) {
            ++arraySize;
        }
        arraySize <<= 3;
        return arraySize >>>= 1;
    }

    public static short[] arrayExpand(short[] oldA, int newSizeBits) {
        short[] newA = new short[BitsShort.calcArraySize(newSizeBits)];
        System.arraycopy(oldA, 0, newA, 0, oldA.length);
        ++statAExpand;
        return newA;
    }

    public static short[] arrayCreate(int nBits) {
        short[] newA = new short[BitsShort.calcArraySize(nBits)];
        ++statACreate;
        return newA;
    }

    public static short[] arrayEnsureSize(short[] oldA, int requiredBits) {
        if (BitsShort.isCapacitySufficient(oldA, requiredBits)) {
            return oldA;
        }
        return BitsShort.arrayExpand(oldA, requiredBits);
    }

    public static boolean isCapacitySufficient(short[] a, int requiredBits) {
        return a.length * 16 >= requiredBits;
    }

    public static short[] arrayTrim(short[] oldA, int requiredBits) {
        int reqSize = BitsShort.calcArraySize(requiredBits);
        if (oldA.length == reqSize) {
            return oldA;
        }
        if (oldA.length < reqSize) {
            throw new IllegalStateException();
        }
        short[] newA = new short[reqSize];
        System.arraycopy(oldA, 0, newA, 0, reqSize);
        ++statATrim;
        return newA;
    }

    public static int arraySizeInByte(short[] ba) {
        return ba.length * 2;
    }

    public static int arraySizeInByte(int arrayLength) {
        return arrayLength * 2;
    }

    public static String toBinary(long l) {
        return BitsShort.toBinary(l, 32);
    }

    public static String toBinary(long l, int DEPTH) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < DEPTH; ++i) {
            long mask = 1L << (int)((long)(DEPTH - i - 1));
            if ((l & mask) != 0L) {
                sb.append("1");
            } else {
                sb.append("0");
            }
            if ((i + 1) % 8 == 0 && i + 1 < DEPTH) {
                sb.append('.');
            }
            mask >>>= 1;
        }
        return sb.toString();
    }

    public static String toBinary(long[] la, int DEPTH) {
        StringBuilder sb = new StringBuilder();
        for (long l : la) {
            sb.append(BitsShort.toBinary(l, DEPTH));
            sb.append(", ");
        }
        return sb.toString();
    }

    public static String toBinary(short[] ba) {
        StringBuilder sb = new StringBuilder();
        for (short l : ba) {
            sb.append(BitsShort.toBinary(l, 16));
            sb.append(", ");
        }
        return sb.toString();
    }
}

