/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree.pre;

import clib.phtree.util.BitTools;

public interface PreProcessorPointF {
    public void pre(double[] var1, long[] var2);

    public void post(long[] var1, double[] var2);

    public long pre(double var1);

    public double post(long var1);

    public static class Multiply
    implements PreProcessorPointF {
        private final double preMult;
        private final double postMult;

        public Multiply(double multiplyer) {
            this.preMult = multiplyer;
            this.postMult = 1.0 / multiplyer;
        }

        @Override
        public void pre(double[] raw, long[] pre) {
            for (int d = 0; d < raw.length; ++d) {
                pre[d] = (long)(raw[d] * this.preMult);
            }
        }

        @Override
        public void post(long[] pre, double[] post) {
            for (int d = 0; d < pre.length; ++d) {
                post[d] = (double)pre[d] * this.postMult;
            }
        }

        @Override
        public long pre(double raw) {
            return (long)(raw * this.preMult);
        }

        @Override
        public double post(long pre) {
            return (double)pre * this.postMult;
        }
    }

    public static class IEEE
    implements PreProcessorPointF {
        @Override
        public void pre(double[] raw, long[] pre) {
            for (int d = 0; d < raw.length; ++d) {
                pre[d] = BitTools.toSortableLong(raw[d]);
            }
        }

        @Override
        public void post(long[] pre, double[] post) {
            for (int d = 0; d < post.length; ++d) {
                post[d] = BitTools.toDouble(pre[d]);
            }
        }

        @Override
        public long pre(double raw) {
            return BitTools.toSortableLong(raw);
        }

        @Override
        public double post(long pre) {
            return BitTools.toDouble(pre);
        }
    }
}

