/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree;

import clib.phtree.PhTreeHelper;
import clib.phtree.v16hd.BitsHD;

public abstract class PhTreeHelperHD {
    public static final boolean DEBUG_FULL = false;
    public static final boolean DEBUG = false;
    public static final Object NULL = PhTreeHelper.NULL;
    public static int MAX_OBJECT_POOL_SIZE = 100;
    public static int ALLOC_BATCH_SIZE;
    public static int ALLOC_BATCH_SIZE_LONG;
    public static int ALLOC_BATCH_REF;
    public static boolean ARRAY_POOLING;
    public static int ARRAY_POOLING_MAX_ARRAY_SIZE;
    public static int ARRAY_POOLING_POOL_SIZE;

    private PhTreeHelperHD() {
    }

    public static void setAllocBatchSize(int size) {
        if (size == 0) {
            ALLOC_BATCH_SIZE_LONG = 63;
            ALLOC_BATCH_SIZE = 1;
            ALLOC_BATCH_REF = 1;
        } else {
            ALLOC_BATCH_SIZE_LONG = 64 * size - 1;
            ALLOC_BATCH_SIZE = size;
            ALLOC_BATCH_REF = 2 * size - 1;
        }
    }

    public static void enablePooling(boolean flag) {
        ARRAY_POOLING = flag;
    }

    public static final void debugCheck() {
    }

    @Deprecated
    public static final int align8(int n) {
        return (int)(8.0 * Math.ceil((double)n / 8.0));
    }

    public static final long[] newHDPos(int bits) {
        return new long[1 + (bits - 1 >>> 6)];
    }

    @Deprecated
    public static final int getMaxConflictingBits(long[] v1, long[] v2, int bitsToCheck) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static final int getMaxConflictingBitsWithMask(long[] v1, long[] v2, long[] mask) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static final long posInArray(long[] valSet, int currentDepth, int DEPTH) {
        long valMask = 1L << DEPTH - 1 - currentDepth;
        long pos = 0L;
        for (long v : valSet) {
            pos <<= 1;
            if ((valMask & v) == 0L) continue;
            pos |= 1L;
        }
        return pos;
    }

    @Deprecated
    public static final long[] posInArrayHD(long[] valSet, int postLen) {
        long valMask = 1L << postLen;
        long[] posHD = PhTreeHelperHD.newHDPos(valSet.length);
        int bitsPerSlot = BitsHD.mod65x(valSet.length);
        int valsetPos = 0;
        for (int rs = 0; rs < posHD.length; ++rs) {
            long pos = 0L;
            for (int i = 0; i < bitsPerSlot; ++i) {
                pos <<= 1;
                pos |= (valMask & valSet[valsetPos++]) >>> postLen;
            }
            posHD[rs] = pos;
            bitsPerSlot = 64;
        }
        return posHD;
    }

    public static final void posInArrayHD(long[] valSet, int postLen, long[] out) {
        long valMask = 1L << postLen;
        int bitsPerSlot = BitsHD.mod65x(valSet.length);
        int valsetPos = 0;
        for (int rs = 0; rs < out.length; ++rs) {
            long pos = 0L;
            for (int i = 0; i < bitsPerSlot; ++i) {
                pos <<= 1;
                pos |= (valMask & valSet[valsetPos++]) >>> postLen;
            }
            out[rs] = pos;
            bitsPerSlot = 64;
        }
    }

    @Deprecated
    public static long[] transposeValue(long[] valSet, int DEPTH) {
        long[] tv = new long[DEPTH];
        long valMask = 1L << DEPTH - 1;
        int rightShift = DEPTH - 1;
        for (int j = 0; j < DEPTH; ++j) {
            long pos = 0L;
            for (long v : valSet) {
                pos <<= 1;
                pos |= (valMask & v) >>> rightShift;
            }
            tv[j] = pos;
            valMask >>>= 1;
            --rightShift;
        }
        return tv;
    }

    public static void applyHcPosHD(long[] posHD, int currentPostLen, long[] val) {
        long mask = 1L << currentPostLen;
        int bitsToProcess = BitsHD.mod65x(val.length);
        int currentDim = val.length - 1;
        for (int i = 0; i < posHD.length; ++i) {
            long pos = Long.rotateLeft(posHD[i], currentPostLen);
            for (int d = bitsToProcess - 1; d >= 0; --d) {
                val[currentDim] = val[currentDim] & (mask ^ 0xFFFFFFFFFFFFFFFFL) | mask & pos;
                pos = Long.rotateRight(pos, 1);
                --currentDim;
            }
            bitsToProcess = 64;
        }
    }

    static {
        PhTreeHelperHD.setAllocBatchSize(1);
        ARRAY_POOLING = true;
        ARRAY_POOLING_MAX_ARRAY_SIZE = 10000;
        ARRAY_POOLING_POOL_SIZE = 100;
    }
}

