/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree;

import clib.phtree.PersistenceProvider;

public class PhTreeConfig {
    public static final int CONCURRENCY_NONE = 0;
    public static final int CONCURRENCY_COW = 1;
    public static final int CONCURRENCY_OL_COW = 2;
    public static final int CONCURRENCY_HOH_COW = 3;
    private int dimUser;
    private int dimActual;
    private boolean[] unique;
    private int concurrencyType = 0;
    private PersistenceProvider persProvider = PersistenceProvider.NONE;

    public PhTreeConfig(int dim) {
        this.dimUser = dim;
        this.dimActual = dim;
        this.unique = new boolean[this.dimUser];
    }

    public void setUnique(int dim) {
        this.unique[dim] = true;
        ++this.dimActual;
    }

    public int getDimActual() {
        return this.dimActual;
    }

    public int getDim() {
        return this.dimUser;
    }

    public int getDepth() {
        return 64;
    }

    public int[] getDimsToSplit() {
        int[] ret = new int[this.dimActual - this.dimUser];
        int n = 0;
        for (int i = 0; i < this.unique.length; ++i) {
            if (!this.unique[i]) continue;
            ret[n] = i;
            ++n;
        }
        return ret;
    }

    public void setConcurrencyType(int concurrencyType) {
        this.concurrencyType = concurrencyType;
    }

    public int getConcurrencyType() {
        return this.concurrencyType;
    }

    public void setPersistenceProvider(PersistenceProvider persProvider) {
        this.persProvider = persProvider;
    }

    public PersistenceProvider getPersistenceProvider() {
        return this.persProvider;
    }
}

