/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree;

import clib.phtree.PhDistance;
import clib.phtree.PhEntry;
import clib.phtree.PhFilterDistance;
import clib.phtree.PhTree;

public class PhRangeQuery<T>
implements PhTree.PhIterator<T> {
    private final long[] min;
    private final long[] max;
    private final PhTree.PhQuery<T> q;
    private final int dims;
    private final PhDistance dist;
    private final PhFilterDistance filter;

    public PhRangeQuery(PhTree.PhQuery<T> iter, PhTree<T> tree, PhDistance dist, PhFilterDistance filter) {
        this.dims = tree.getDim();
        this.q = iter;
        this.dist = dist;
        this.filter = filter;
        this.min = new long[this.dims];
        this.max = new long[this.dims];
    }

    public PhRangeQuery<T> reset(double range, long ... center) {
        this.filter.set(center, this.dist, range);
        this.dist.toMBB(range, center, this.min, this.max);
        this.q.reset(this.min, this.max);
        return this;
    }

    @Override
    public long[] nextKey() {
        return this.q.nextKey();
    }

    @Override
    public T nextValue() {
        return (T)this.q.nextValue();
    }

    @Override
    public PhEntry<T> nextEntry() {
        return (PhEntry)this.q.nextEntry();
    }

    @Override
    public boolean hasNext() {
        return this.q.hasNext();
    }

    @Override
    public T next() {
        return (T)this.q.next();
    }

    @Override
    public void remove() {
        this.q.remove();
    }

    @Override
    public PhEntry<T> nextEntryReuse() {
        return this.q.nextEntryReuse();
    }
}

