/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree;

import clib.phtree.PhDistance;
import clib.phtree.util.BitTools;
import java.util.Arrays;

public class PhDistanceF
implements PhDistance {
    public static final PhDistanceF THIS = new PhDistanceF();

    @Override
    public double dist(long[] v1, long[] v2) {
        double d = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            double dl = BitTools.toDouble(v1[i]) - BitTools.toDouble(v2[i]);
            d += dl * dl;
        }
        return Math.sqrt(d);
    }

    @Override
    public void toMBB(double distance, long[] center, long[] outMin, long[] outMax) {
        for (int i = 0; i < center.length; ++i) {
            double c = BitTools.toDouble(center[i]);
            outMin[i] = BitTools.toSortableLong(c - distance);
            outMax[i] = BitTools.toSortableLong(c + distance);
        }
    }

    @Override
    public void knnCalcDistances(long[] kNNCenter, long[] prefix, int bitsToIgnore, double[] outDistances) {
        int i;
        long maskSingleBit = 1L << bitsToIgnore - 1;
        if (maskSingleBit < 0L) {
            return;
        }
        long maskPrefix = -1L << bitsToIgnore;
        long maskPostFix = (maskPrefix ^ 0xFFFFFFFFFFFFFFFFL) >> 1;
        for (i = 0; i < prefix.length; ++i) {
            long nodeCenter = prefix[i] & maskPrefix;
            boolean isLarger = kNNCenter[i] > (nodeCenter | maskPostFix);
            double dist = BitTools.toDouble(nodeCenter |= isLarger ? maskPostFix : maskSingleBit) - BitTools.toDouble(kNNCenter[i]);
            outDistances[i] = dist * dist;
        }
        Arrays.sort(outDistances);
        for (i = 1; i < outDistances.length; ++i) {
            int n = i;
            outDistances[n] = outDistances[n] + outDistances[i - 1];
        }
        for (i = 0; i < outDistances.length; ++i) {
            outDistances[i] = Math.sqrt(outDistances[i]);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

