/*
 * Decompiled with CFR 0.152.
 */
package clib.phtree;

import clib.phtree.PhTree;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public interface PersistenceProvider {
    public static final PersistenceProvider NONE = new PersistenceProviderNone();

    public Object loadNode(Object var1);

    public Object registerNode(Externalizable var1);

    public void updateNode(Externalizable var1);

    public String getDescription();

    public int statsGetPageReads();

    public int statsGetPageWrites();

    public void statsReset();

    public void writeTree(PhTree<?> var1, int var2);

    public void updateTree(PhTree<?> var1, int var2, int var3, Object var4);

    public <T> PhTree<T> loadTree();

    public void flush();

    public static void write(Object[] values, ObjectOutput out) throws IOException {
        out.writeShort(values.length);
        for (int i = 0; i < values.length; ++i) {
            Object v = values[i];
            int vi = v != null ? (Integer)v : -1;
            out.writeInt(vi);
        }
    }

    public static Object[] read(ObjectInput in) throws IOException {
        int size = in.readShort();
        Object[] ret = new Object[size];
        for (int i = 0; i < size; ++i) {
            int vi = in.readInt();
            ret[i] = vi == -1 ? null : Integer.valueOf(vi);
        }
        return ret;
    }

    public static class PersistenceProviderNone
    implements PersistenceProvider {
        private PhTree<?> tree;

        @Override
        public Object registerNode(Externalizable o) {
            return o;
        }

        @Override
        public Object loadNode(Object o) {
            return o;
        }

        @Override
        public void updateNode(Externalizable o) {
        }

        @Override
        public String getDescription() {
            return "NONE";
        }

        @Override
        public int statsGetPageReads() {
            return -1;
        }

        @Override
        public int statsGetPageWrites() {
            return -1;
        }

        @Override
        public void statsReset() {
        }

        @Override
        public void writeTree(PhTree<?> tree, int dims) {
            this.tree = tree;
        }

        @Override
        public void updateTree(PhTree<?> tree, int dims, int nEntries, Object rootId) {
            this.tree = tree;
        }

        @Override
        public <T> PhTree<T> loadTree() {
            return this.tree;
        }

        @Override
        public void flush() {
        }
    }
}

