/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.protocol.protocol1_17to1_17_1;

import com.viaversion.viabackwards.api.BackwardsProtocol;
import com.viaversion.viabackwards.protocol.protocol1_16_4to1_17.storage.PlayerLastCursorItem;
import com.viaversion.viabackwards.protocol.protocol1_17to1_17_1.storage.InventoryStateIds;
import com.viaversion.viaversion.api.connection.StorableObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.CompoundTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.ListTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.StringTag;
import com.viaversion.viaversion.libs.opennbt.tag.builtin.Tag;
import com.viaversion.viaversion.protocols.protocol1_17_1to1_17.ClientboundPackets1_17_1;
import com.viaversion.viaversion.protocols.protocol1_17to1_16_4.ClientboundPackets1_17;
import com.viaversion.viaversion.protocols.protocol1_17to1_16_4.ServerboundPackets1_17;

public final class Protocol1_17To1_17_1
extends BackwardsProtocol<ClientboundPackets1_17_1, ClientboundPackets1_17, ServerboundPackets1_17, ServerboundPackets1_17> {
    private static final int MAX_PAGE_LENGTH = 8192;
    private static final int MAX_TITLE_LENGTH = 128;
    private static final int MAX_PAGES = 200;

    public Protocol1_17To1_17_1() {
        super(ClientboundPackets1_17_1.class, ClientboundPackets1_17.class, ServerboundPackets1_17.class, ServerboundPackets1_17.class);
    }

    @Override
    protected void registerPackets() {
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_17_1.REMOVE_ENTITIES, null, wrapper -> {
            int[] entityIds = (int[])wrapper.read(Type.VAR_INT_ARRAY_PRIMITIVE);
            wrapper.cancel();
            for (int entityId : entityIds) {
                PacketWrapper newPacket = wrapper.create((PacketType)ClientboundPackets1_17.REMOVE_ENTITY);
                newPacket.write((Type)Type.VAR_INT, (Object)entityId);
                newPacket.send(Protocol1_17To1_17_1.class);
            }
        });
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_17_1.CLOSE_WINDOW, wrapper -> {
            short containerId = (Short)wrapper.passthrough((Type)Type.UNSIGNED_BYTE);
            ((InventoryStateIds)wrapper.user().get(InventoryStateIds.class)).removeStateId(containerId);
        });
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_17_1.SET_SLOT, wrapper -> {
            short containerId = (Short)wrapper.passthrough((Type)Type.UNSIGNED_BYTE);
            int stateId = (Integer)wrapper.read((Type)Type.VAR_INT);
            ((InventoryStateIds)wrapper.user().get(InventoryStateIds.class)).setStateId(containerId, stateId);
        });
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_17_1.WINDOW_ITEMS, wrapper -> {
            short containerId = (Short)wrapper.passthrough((Type)Type.UNSIGNED_BYTE);
            int stateId = (Integer)wrapper.read((Type)Type.VAR_INT);
            ((InventoryStateIds)wrapper.user().get(InventoryStateIds.class)).setStateId(containerId, stateId);
            wrapper.write(Type.FLAT_VAR_INT_ITEM_ARRAY, (Object)((Item[])wrapper.read(Type.FLAT_VAR_INT_ITEM_ARRAY_VAR_INT)));
            Item carried = (Item)wrapper.read(Type.FLAT_VAR_INT_ITEM);
            PlayerLastCursorItem lastCursorItem = (PlayerLastCursorItem)wrapper.user().get(PlayerLastCursorItem.class);
            if (lastCursorItem != null) {
                lastCursorItem.setLastCursorItem(carried);
            }
        });
        this.registerServerbound((ServerboundPacketType)ServerboundPackets1_17.CLOSE_WINDOW, wrapper -> {
            short containerId = (Short)wrapper.passthrough((Type)Type.UNSIGNED_BYTE);
            ((InventoryStateIds)wrapper.user().get(InventoryStateIds.class)).removeStateId(containerId);
        });
        this.registerServerbound((ServerboundPacketType)ServerboundPackets1_17.CLICK_WINDOW, wrapper -> {
            short containerId = (Short)wrapper.passthrough((Type)Type.UNSIGNED_BYTE);
            int stateId = ((InventoryStateIds)wrapper.user().get(InventoryStateIds.class)).removeStateId(containerId);
            wrapper.write((Type)Type.VAR_INT, (Object)(stateId == Integer.MAX_VALUE ? 0 : stateId));
        });
        this.registerServerbound((ServerboundPacketType)ServerboundPackets1_17.EDIT_BOOK, wrapper -> {
            ListTag pagesTag;
            Item item = (Item)wrapper.read(Type.FLAT_VAR_INT_ITEM);
            boolean signing = (Boolean)wrapper.read((Type)Type.BOOLEAN);
            wrapper.passthrough((Type)Type.VAR_INT);
            CompoundTag tag = item.tag();
            StringTag titleTag = null;
            if (tag == null || (pagesTag = (ListTag)tag.get("pages")) == null || signing && (titleTag = (StringTag)tag.get("title")) == null) {
                wrapper.write((Type)Type.VAR_INT, (Object)0);
                wrapper.write((Type)Type.BOOLEAN, (Object)false);
                return;
            }
            if (pagesTag.size() > 200) {
                pagesTag = new ListTag(pagesTag.getValue().subList(0, 200));
            }
            wrapper.write((Type)Type.VAR_INT, (Object)pagesTag.size());
            for (Tag pageTag : pagesTag) {
                String page = ((StringTag)pageTag).getValue();
                if (page.length() > 8192) {
                    page = page.substring(0, 8192);
                }
                wrapper.write(Type.STRING, (Object)page);
            }
            wrapper.write((Type)Type.BOOLEAN, (Object)signing);
            if (signing) {
                String title;
                if (titleTag == null) {
                    titleTag = (StringTag)tag.get("title");
                }
                if ((title = titleTag.getValue()).length() > 128) {
                    title = title.substring(0, 128);
                }
                wrapper.write(Type.STRING, (Object)title);
            }
        });
    }

    public void init(UserConnection connection) {
        connection.put((StorableObject)new InventoryStateIds());
    }
}

