/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.protocol.protocol1_13to1_13_1;

import com.viaversion.viabackwards.ViaBackwards;
import com.viaversion.viabackwards.api.BackwardsProtocol;
import com.viaversion.viabackwards.api.data.BackwardsMappings;
import com.viaversion.viabackwards.api.rewriters.TranslatableRewriter;
import com.viaversion.viabackwards.protocol.protocol1_13to1_13_1.data.CommandRewriter1_13_1;
import com.viaversion.viabackwards.protocol.protocol1_13to1_13_1.packets.EntityPackets1_13_1;
import com.viaversion.viabackwards.protocol.protocol1_13to1_13_1.packets.InventoryPackets1_13_1;
import com.viaversion.viabackwards.protocol.protocol1_13to1_13_1.packets.WorldPackets1_13_1;
import com.viaversion.viaversion.api.connection.StorableObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.data.entity.EntityTracker;
import com.viaversion.viaversion.api.minecraft.RegistryType;
import com.viaversion.viaversion.api.minecraft.entities.Entity1_13Types;
import com.viaversion.viaversion.api.minecraft.entities.EntityType;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.protocol.remapper.ValueTransformer;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.data.entity.EntityTrackerBase;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.protocols.protocol1_13_1to1_13.Protocol1_13_1To1_13;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.ChatRewriter;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.ClientboundPackets1_13;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.ServerboundPackets1_13;
import com.viaversion.viaversion.protocols.protocol1_9_3to1_9_1_2.storage.ClientWorld;
import com.viaversion.viaversion.rewriter.StatisticsRewriter;
import com.viaversion.viaversion.rewriter.TagRewriter;

public class Protocol1_13To1_13_1
extends BackwardsProtocol<ClientboundPackets1_13, ClientboundPackets1_13, ServerboundPackets1_13, ServerboundPackets1_13> {
    public static final BackwardsMappings MAPPINGS = new BackwardsMappings("1.13.2", "1.13", Protocol1_13_1To1_13.class);
    private final EntityPackets1_13_1 entityRewriter = new EntityPackets1_13_1(this);
    private final InventoryPackets1_13_1 itemRewriter = new InventoryPackets1_13_1(this);
    private final TranslatableRewriter<ClientboundPackets1_13> translatableRewriter = new TranslatableRewriter<ClientboundPackets1_13>(this);

    public Protocol1_13To1_13_1() {
        super(ClientboundPackets1_13.class, ClientboundPackets1_13.class, ServerboundPackets1_13.class, ServerboundPackets1_13.class);
    }

    @Override
    protected void registerPackets() {
        super.registerPackets();
        WorldPackets1_13_1.register(this);
        this.translatableRewriter.registerComponentPacket((ClientboundPacketType)ClientboundPackets1_13.CHAT_MESSAGE);
        this.translatableRewriter.registerCombatEvent((ClientboundPacketType)ClientboundPackets1_13.COMBAT_EVENT);
        this.translatableRewriter.registerDisconnect(ClientboundPackets1_13.DISCONNECT);
        this.translatableRewriter.registerTabList(ClientboundPackets1_13.TAB_LIST);
        this.translatableRewriter.registerTitle((ClientboundPacketType)ClientboundPackets1_13.TITLE);
        this.translatableRewriter.registerPing();
        new CommandRewriter1_13_1(this).registerDeclareCommands((ClientboundPacketType)ClientboundPackets1_13.DECLARE_COMMANDS);
        this.registerServerbound((ServerboundPacketType)ServerboundPackets1_13.TAB_COMPLETE, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT);
                this.map(Type.STRING, (ValueTransformer)new ValueTransformer<String, String>(Type.STRING){

                    public String transform(PacketWrapper wrapper, String inputValue) {
                        return !inputValue.startsWith("/") ? "/" + inputValue : inputValue;
                    }
                });
            }
        });
        this.registerServerbound((ServerboundPacketType)ServerboundPackets1_13.EDIT_BOOK, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Type.FLAT_ITEM);
                this.map((Type)Type.BOOLEAN);
                this.handler(wrapper -> {
                    Protocol1_13To1_13_1.this.itemRewriter.handleItemToServer((Item)wrapper.get(Type.FLAT_ITEM, 0));
                    wrapper.write((Type)Type.VAR_INT, (Object)0);
                });
            }
        });
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_13.OPEN_WINDOW, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.UNSIGNED_BYTE);
                this.map(Type.STRING);
                this.handler(wrapper -> {
                    JsonElement title = (JsonElement)wrapper.passthrough(Type.COMPONENT);
                    Protocol1_13To1_13_1.this.translatableRewriter.processText(title);
                    if (ViaBackwards.getConfig().fix1_13FormattedInventoryTitle()) {
                        if (title.isJsonObject() && title.getAsJsonObject().size() == 1 && title.getAsJsonObject().has("translate")) {
                            return;
                        }
                        JsonObject legacyComponent = new JsonObject();
                        legacyComponent.addProperty("text", ChatRewriter.jsonToLegacyText((String)title.toString()));
                        wrapper.set(Type.COMPONENT, 0, (Object)legacyComponent);
                    }
                });
            }
        });
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_13.TAB_COMPLETE, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT);
                this.map((Type)Type.VAR_INT);
                this.map((Type)Type.VAR_INT);
                this.map((Type)Type.VAR_INT);
                this.handler(wrapper -> {
                    int start = (Integer)wrapper.get((Type)Type.VAR_INT, 1);
                    wrapper.set((Type)Type.VAR_INT, 1, (Object)(start - 1));
                    int count = (Integer)wrapper.get((Type)Type.VAR_INT, 3);
                    for (int i = 0; i < count; ++i) {
                        wrapper.passthrough(Type.STRING);
                        boolean hasTooltip = (Boolean)wrapper.passthrough((Type)Type.BOOLEAN);
                        if (!hasTooltip) continue;
                        wrapper.passthrough(Type.STRING);
                    }
                });
            }
        });
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_13.BOSSBAR, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Type.UUID);
                this.map((Type)Type.VAR_INT);
                this.handler(wrapper -> {
                    int action = (Integer)wrapper.get((Type)Type.VAR_INT, 0);
                    if (action == 0 || action == 3) {
                        Protocol1_13To1_13_1.this.translatableRewriter.processText((JsonElement)wrapper.passthrough(Type.COMPONENT));
                        if (action == 0) {
                            wrapper.passthrough((Type)Type.FLOAT);
                            wrapper.passthrough((Type)Type.VAR_INT);
                            wrapper.passthrough((Type)Type.VAR_INT);
                            short flags = (Short)wrapper.read((Type)Type.UNSIGNED_BYTE);
                            if ((flags & 4) != 0) {
                                flags = (short)(flags | 2);
                            }
                            wrapper.write((Type)Type.UNSIGNED_BYTE, (Object)flags);
                        }
                    }
                });
            }
        });
        this.registerClientbound((ClientboundPacketType)ClientboundPackets1_13.ADVANCEMENTS, wrapper -> {
            wrapper.passthrough((Type)Type.BOOLEAN);
            int size = (Integer)wrapper.passthrough((Type)Type.VAR_INT);
            for (int i = 0; i < size; ++i) {
                wrapper.passthrough(Type.STRING);
                if (((Boolean)wrapper.passthrough((Type)Type.BOOLEAN)).booleanValue()) {
                    wrapper.passthrough(Type.STRING);
                }
                if (((Boolean)wrapper.passthrough((Type)Type.BOOLEAN)).booleanValue()) {
                    wrapper.passthrough(Type.COMPONENT);
                    wrapper.passthrough(Type.COMPONENT);
                    Item icon = (Item)wrapper.passthrough(Type.FLAT_ITEM);
                    this.itemRewriter.handleItemToClient(icon);
                    wrapper.passthrough((Type)Type.VAR_INT);
                    int flags = (Integer)wrapper.passthrough((Type)Type.INT);
                    if ((flags & 1) != 0) {
                        wrapper.passthrough(Type.STRING);
                    }
                    wrapper.passthrough((Type)Type.FLOAT);
                    wrapper.passthrough((Type)Type.FLOAT);
                }
                wrapper.passthrough(Type.STRING_ARRAY);
                int arrayLength = (Integer)wrapper.passthrough((Type)Type.VAR_INT);
                for (int array = 0; array < arrayLength; ++array) {
                    wrapper.passthrough(Type.STRING_ARRAY);
                }
            }
        });
        new TagRewriter((Protocol)this).register((ClientboundPacketType)ClientboundPackets1_13.TAGS, RegistryType.ITEM);
        new StatisticsRewriter((Protocol)this).register((ClientboundPacketType)ClientboundPackets1_13.STATISTICS);
    }

    public void init(UserConnection user) {
        user.addEntityTracker(((Object)((Object)this)).getClass(), (EntityTracker)new EntityTrackerBase(user, (EntityType)Entity1_13Types.EntityType.PLAYER));
        if (!user.has(ClientWorld.class)) {
            user.put((StorableObject)new ClientWorld(user));
        }
    }

    @Override
    public BackwardsMappings getMappingData() {
        return MAPPINGS;
    }

    public EntityPackets1_13_1 getEntityRewriter() {
        return this.entityRewriter;
    }

    public InventoryPackets1_13_1 getItemRewriter() {
        return this.itemRewriter;
    }

    public TranslatableRewriter<ClientboundPackets1_13> translatableRewriter() {
        return this.translatableRewriter;
    }
}

