/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viabackwards.protocol.protocol1_13_2to1_14.packets;

import com.viaversion.viabackwards.ViaBackwards;
import com.viaversion.viabackwards.api.entities.storage.EntityData;
import com.viaversion.viabackwards.api.entities.storage.EntityPositionHandler;
import com.viaversion.viabackwards.api.rewriters.LegacyEntityRewriter;
import com.viaversion.viabackwards.protocol.protocol1_13_2to1_14.Protocol1_13_2To1_14;
import com.viaversion.viabackwards.protocol.protocol1_13_2to1_14.storage.ChunkLightStorage;
import com.viaversion.viabackwards.protocol.protocol1_13_2to1_14.storage.DifficultyStorage;
import com.viaversion.viabackwards.protocol.protocol1_13_2to1_14.storage.EntityPositionStorage1_14;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.data.entity.EntityTracker;
import com.viaversion.viaversion.api.minecraft.Position;
import com.viaversion.viaversion.api.minecraft.VillagerData;
import com.viaversion.viaversion.api.minecraft.entities.Entity1_13Types;
import com.viaversion.viaversion.api.minecraft.entities.Entity1_14Types;
import com.viaversion.viaversion.api.minecraft.entities.EntityType;
import com.viaversion.viaversion.api.minecraft.metadata.Metadata;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.types.Particle;
import com.viaversion.viaversion.api.type.types.version.Types1_13_2;
import com.viaversion.viaversion.api.type.types.version.Types1_14;
import com.viaversion.viaversion.protocols.protocol1_13to1_12_2.ClientboundPackets1_13;
import com.viaversion.viaversion.protocols.protocol1_14to1_13_2.ClientboundPackets1_14;
import com.viaversion.viaversion.protocols.protocol1_9_3to1_9_1_2.storage.ClientWorld;
import com.viaversion.viaversion.rewriter.meta.MetaHandler;
import java.util.List;

public class EntityPackets1_14
extends LegacyEntityRewriter<ClientboundPackets1_14, Protocol1_13_2To1_14> {
    private EntityPositionHandler positionHandler;

    public EntityPackets1_14(Protocol1_13_2To1_14 protocol) {
        super(protocol, Types1_13_2.META_TYPES.optionalComponentType, Types1_13_2.META_TYPES.booleanType);
    }

    @Override
    protected void addTrackedEntity(PacketWrapper wrapper, int entityId, EntityType type) throws Exception {
        super.addTrackedEntity(wrapper, entityId, type);
        if (type == Entity1_14Types.PAINTING) {
            Position position = (Position)wrapper.get(Type.POSITION, 0);
            this.positionHandler.cacheEntityPosition(wrapper, position.x(), position.y(), position.z(), true, false);
        } else if (wrapper.getId() != ClientboundPackets1_14.JOIN_GAME.getId()) {
            this.positionHandler.cacheEntityPosition(wrapper, true, false);
        }
    }

    protected void registerPackets() {
        this.positionHandler = new EntityPositionHandler(this, EntityPositionStorage1_14.class, EntityPositionStorage1_14::new);
        ((Protocol1_13_2To1_14)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_14.ENTITY_STATUS, wrapper -> {
            int entityId = (Integer)wrapper.passthrough((Type)Type.INT);
            byte status = (Byte)wrapper.passthrough((Type)Type.BYTE);
            if (status != 3) {
                return;
            }
            EntityTracker tracker = this.tracker(wrapper.user());
            EntityType entityType = tracker.entityType(entityId);
            if (entityType != Entity1_14Types.PLAYER) {
                return;
            }
            for (int i = 0; i <= 5; ++i) {
                PacketWrapper equipmentPacket = wrapper.create((PacketType)ClientboundPackets1_13.ENTITY_EQUIPMENT);
                equipmentPacket.write((Type)Type.VAR_INT, (Object)entityId);
                equipmentPacket.write((Type)Type.VAR_INT, (Object)i);
                equipmentPacket.write(Type.FLAT_VAR_INT_ITEM, null);
                equipmentPacket.send(Protocol1_13_2To1_14.class);
            }
        });
        ((Protocol1_13_2To1_14)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_14.ENTITY_TELEPORT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.DOUBLE);
                this.handler(wrapper -> EntityPackets1_14.this.positionHandler.cacheEntityPosition(wrapper, false, false));
            }
        });
        PacketHandlers relativeMoveHandler = new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT);
                this.map((Type)Type.SHORT);
                this.map((Type)Type.SHORT);
                this.map((Type)Type.SHORT);
                this.handler(wrapper -> {
                    double x = (double)((Short)wrapper.get((Type)Type.SHORT, 0)).shortValue() / 4096.0;
                    double y = (double)((Short)wrapper.get((Type)Type.SHORT, 1)).shortValue() / 4096.0;
                    double z = (double)((Short)wrapper.get((Type)Type.SHORT, 2)).shortValue() / 4096.0;
                    EntityPackets1_14.this.positionHandler.cacheEntityPosition(wrapper, x, y, z, false, true);
                });
            }
        };
        ((Protocol1_13_2To1_14)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_14.ENTITY_POSITION, (PacketHandler)relativeMoveHandler);
        ((Protocol1_13_2To1_14)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_14.ENTITY_POSITION_AND_ROTATION, (PacketHandler)relativeMoveHandler);
        ((Protocol1_13_2To1_14)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_14.SPAWN_ENTITY, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT);
                this.map(Type.UUID);
                this.map((Type)Type.VAR_INT, (Type)Type.BYTE);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.INT);
                this.map((Type)Type.SHORT);
                this.map((Type)Type.SHORT);
                this.map((Type)Type.SHORT);
                this.handler(EntityPackets1_14.this.getObjectTrackerHandler());
                this.handler(wrapper -> {
                    int data;
                    Entity1_13Types.ObjectType objectType;
                    byte id = (Byte)wrapper.get((Type)Type.BYTE, 0);
                    int mappedId = EntityPackets1_14.this.newEntityId(id);
                    Entity1_13Types.EntityType entityType = Entity1_13Types.getTypeFromId((int)mappedId, (boolean)false);
                    if (entityType.isOrHasParent((EntityType)Entity1_13Types.EntityType.MINECART_ABSTRACT)) {
                        objectType = Entity1_13Types.ObjectType.MINECART;
                        data = 0;
                        switch (entityType) {
                            case CHEST_MINECART: {
                                data = 1;
                                break;
                            }
                            case FURNACE_MINECART: {
                                data = 2;
                                break;
                            }
                            case TNT_MINECART: {
                                data = 3;
                                break;
                            }
                            case SPAWNER_MINECART: {
                                data = 4;
                                break;
                            }
                            case HOPPER_MINECART: {
                                data = 5;
                                break;
                            }
                            case COMMAND_BLOCK_MINECART: {
                                data = 6;
                            }
                        }
                        if (data != 0) {
                            wrapper.set((Type)Type.INT, 0, (Object)data);
                        }
                    } else {
                        objectType = Entity1_13Types.ObjectType.fromEntityType((Entity1_13Types.EntityType)entityType).orElse(null);
                    }
                    if (objectType == null) {
                        return;
                    }
                    wrapper.set((Type)Type.BYTE, 0, (Object)((byte)objectType.getId()));
                    data = (Integer)wrapper.get((Type)Type.INT, 0);
                    if (objectType == Entity1_13Types.ObjectType.FALLING_BLOCK) {
                        int blockState = (Integer)wrapper.get((Type)Type.INT, 0);
                        int combined = ((Protocol1_13_2To1_14)EntityPackets1_14.this.protocol).getMappingData().getNewBlockStateId(blockState);
                        wrapper.set((Type)Type.INT, 0, (Object)combined);
                    } else if (entityType.isOrHasParent((EntityType)Entity1_13Types.EntityType.ABSTRACT_ARROW)) {
                        wrapper.set((Type)Type.INT, 0, (Object)(data + 1));
                    }
                });
            }
        });
        ((Protocol1_13_2To1_14)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_14.SPAWN_MOB, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT);
                this.map(Type.UUID);
                this.map((Type)Type.VAR_INT);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.SHORT);
                this.map((Type)Type.SHORT);
                this.map((Type)Type.SHORT);
                this.map(Types1_14.METADATA_LIST, Types1_13_2.METADATA_LIST);
                this.handler(wrapper -> {
                    int type = (Integer)wrapper.get((Type)Type.VAR_INT, 1);
                    EntityType entityType = Entity1_14Types.getTypeFromId((int)type);
                    EntityPackets1_14.this.addTrackedEntity(wrapper, (Integer)wrapper.get((Type)Type.VAR_INT, 0), entityType);
                    int oldId = EntityPackets1_14.this.newEntityId(type);
                    if (oldId == -1) {
                        EntityData entityData = EntityPackets1_14.this.entityDataForType(entityType);
                        if (entityData == null) {
                            ViaBackwards.getPlatform().getLogger().warning("Could not find 1.13.2 entity type for 1.14 entity type " + type + "/" + entityType);
                            wrapper.cancel();
                        } else {
                            wrapper.set((Type)Type.VAR_INT, 1, (Object)entityData.replacementId());
                        }
                    } else {
                        wrapper.set((Type)Type.VAR_INT, 1, (Object)oldId);
                    }
                });
                this.handler(EntityPackets1_14.this.getMobSpawnRewriter((Type<List<Metadata>>)Types1_13_2.METADATA_LIST));
            }
        });
        ((Protocol1_13_2To1_14)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_14.SPAWN_EXPERIENCE_ORB, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.DOUBLE);
                this.handler(wrapper -> EntityPackets1_14.this.addTrackedEntity(wrapper, (Integer)wrapper.get((Type)Type.VAR_INT, 0), (EntityType)Entity1_14Types.EXPERIENCE_ORB));
            }
        });
        ((Protocol1_13_2To1_14)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_14.SPAWN_GLOBAL_ENTITY, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.DOUBLE);
                this.handler(wrapper -> EntityPackets1_14.this.addTrackedEntity(wrapper, (Integer)wrapper.get((Type)Type.VAR_INT, 0), (EntityType)Entity1_14Types.LIGHTNING_BOLT));
            }
        });
        ((Protocol1_13_2To1_14)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_14.SPAWN_PAINTING, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT);
                this.map(Type.UUID);
                this.map((Type)Type.VAR_INT);
                this.map(Type.POSITION1_14, Type.POSITION);
                this.map((Type)Type.BYTE);
                this.handler(wrapper -> EntityPackets1_14.this.addTrackedEntity(wrapper, (Integer)wrapper.get((Type)Type.VAR_INT, 0), (EntityType)Entity1_14Types.PAINTING));
            }
        });
        ((Protocol1_13_2To1_14)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_14.SPAWN_PLAYER, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.VAR_INT);
                this.map(Type.UUID);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.DOUBLE);
                this.map((Type)Type.BYTE);
                this.map((Type)Type.BYTE);
                this.map(Types1_14.METADATA_LIST, Types1_13_2.METADATA_LIST);
                this.handler(EntityPackets1_14.this.getTrackerAndMetaHandler((Type<List<Metadata>>)Types1_13_2.METADATA_LIST, (EntityType)Entity1_14Types.PLAYER));
                this.handler(wrapper -> EntityPackets1_14.this.positionHandler.cacheEntityPosition(wrapper, true, false));
            }
        });
        this.registerRemoveEntities((ClientboundPacketType)ClientboundPackets1_14.DESTROY_ENTITIES);
        this.registerMetadataRewriter(ClientboundPackets1_14.ENTITY_METADATA, (Type<List<Metadata>>)Types1_14.METADATA_LIST, (Type<List<Metadata>>)Types1_13_2.METADATA_LIST);
        ((Protocol1_13_2To1_14)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_14.JOIN_GAME, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.INT);
                this.map((Type)Type.UNSIGNED_BYTE);
                this.map((Type)Type.INT);
                this.handler(EntityPackets1_14.this.getTrackerHandler((EntityType)Entity1_14Types.PLAYER, (Type<Number>)((Type)Type.INT)));
                this.handler(EntityPackets1_14.this.getDimensionHandler(1));
                this.handler(wrapper -> {
                    short difficulty = ((DifficultyStorage)wrapper.user().get(DifficultyStorage.class)).getDifficulty();
                    wrapper.write((Type)Type.UNSIGNED_BYTE, (Object)difficulty);
                    wrapper.passthrough((Type)Type.UNSIGNED_BYTE);
                    wrapper.passthrough(Type.STRING);
                    wrapper.read((Type)Type.VAR_INT);
                });
            }
        });
        ((Protocol1_13_2To1_14)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_14.RESPAWN, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Type.INT);
                this.handler(wrapper -> {
                    ClientWorld clientWorld = (ClientWorld)wrapper.user().get(ClientWorld.class);
                    int dimensionId = (Integer)wrapper.get((Type)Type.INT, 0);
                    clientWorld.setEnvironment(dimensionId);
                    short difficulty = ((DifficultyStorage)wrapper.user().get(DifficultyStorage.class)).getDifficulty();
                    wrapper.write((Type)Type.UNSIGNED_BYTE, (Object)difficulty);
                    ((ChunkLightStorage)wrapper.user().get(ChunkLightStorage.class)).clear();
                });
            }
        });
    }

    protected void registerRewrites() {
        this.mapTypes((EntityType[])Entity1_14Types.values(), Entity1_13Types.EntityType.class);
        this.mapEntityTypeWithData((EntityType)Entity1_14Types.CAT, (EntityType)Entity1_14Types.OCELOT).jsonName();
        this.mapEntityTypeWithData((EntityType)Entity1_14Types.TRADER_LLAMA, (EntityType)Entity1_14Types.LLAMA).jsonName();
        this.mapEntityTypeWithData((EntityType)Entity1_14Types.FOX, (EntityType)Entity1_14Types.WOLF).jsonName();
        this.mapEntityTypeWithData((EntityType)Entity1_14Types.PANDA, (EntityType)Entity1_14Types.POLAR_BEAR).jsonName();
        this.mapEntityTypeWithData((EntityType)Entity1_14Types.PILLAGER, (EntityType)Entity1_14Types.VILLAGER).jsonName();
        this.mapEntityTypeWithData((EntityType)Entity1_14Types.WANDERING_TRADER, (EntityType)Entity1_14Types.VILLAGER).jsonName();
        this.mapEntityTypeWithData((EntityType)Entity1_14Types.RAVAGER, (EntityType)Entity1_14Types.COW).jsonName();
        this.filter().handler((event, meta) -> {
            int typeId = meta.metaType().typeId();
            if (typeId <= 15) {
                meta.setMetaType(Types1_13_2.META_TYPES.byId(typeId));
            }
        });
        this.registerMetaTypeHandler(Types1_13_2.META_TYPES.itemType, Types1_13_2.META_TYPES.blockStateType, null, null, Types1_13_2.META_TYPES.componentType, Types1_13_2.META_TYPES.optionalComponentType);
        this.filter().type((EntityType)Entity1_14Types.PILLAGER).cancel(15);
        this.filter().type((EntityType)Entity1_14Types.FOX).cancel(15);
        this.filter().type((EntityType)Entity1_14Types.FOX).cancel(16);
        this.filter().type((EntityType)Entity1_14Types.FOX).cancel(17);
        this.filter().type((EntityType)Entity1_14Types.FOX).cancel(18);
        this.filter().type((EntityType)Entity1_14Types.PANDA).cancel(15);
        this.filter().type((EntityType)Entity1_14Types.PANDA).cancel(16);
        this.filter().type((EntityType)Entity1_14Types.PANDA).cancel(17);
        this.filter().type((EntityType)Entity1_14Types.PANDA).cancel(18);
        this.filter().type((EntityType)Entity1_14Types.PANDA).cancel(19);
        this.filter().type((EntityType)Entity1_14Types.PANDA).cancel(20);
        this.filter().type((EntityType)Entity1_14Types.CAT).cancel(18);
        this.filter().type((EntityType)Entity1_14Types.CAT).cancel(19);
        this.filter().type((EntityType)Entity1_14Types.CAT).cancel(20);
        this.filter().handler((event, meta) -> {
            EntityType type = event.entityType();
            if (type == null) {
                return;
            }
            if (type.isOrHasParent((EntityType)Entity1_14Types.ABSTRACT_ILLAGER_BASE) || type == Entity1_14Types.RAVAGER || type == Entity1_14Types.WITCH) {
                int index = event.index();
                if (index == 14) {
                    event.cancel();
                } else if (index > 14) {
                    event.setIndex(index - 1);
                }
            }
        });
        this.filter().type((EntityType)Entity1_14Types.AREA_EFFECT_CLOUD).index(10).handler((event, meta) -> this.rewriteParticle((Particle)meta.getValue()));
        this.filter().type((EntityType)Entity1_14Types.FIREWORK_ROCKET).index(8).handler((event, meta) -> {
            meta.setMetaType(Types1_13_2.META_TYPES.varIntType);
            Integer value = (Integer)meta.getValue();
            if (value == null) {
                meta.setValue((Object)0);
            }
        });
        this.filter().filterFamily((EntityType)Entity1_14Types.ABSTRACT_ARROW).removeIndex(9);
        this.filter().type((EntityType)Entity1_14Types.VILLAGER).cancel(15);
        MetaHandler villagerDataHandler = (event, meta) -> {
            VillagerData villagerData = (VillagerData)meta.getValue();
            meta.setTypeAndValue(Types1_13_2.META_TYPES.varIntType, (Object)this.villagerDataToProfession(villagerData));
            if (meta.id() == 16) {
                event.setIndex(15);
            }
        };
        this.filter().type((EntityType)Entity1_14Types.ZOMBIE_VILLAGER).index(18).handler(villagerDataHandler);
        this.filter().type((EntityType)Entity1_14Types.VILLAGER).index(16).handler(villagerDataHandler);
        this.filter().filterFamily((EntityType)Entity1_14Types.ABSTRACT_SKELETON).index(13).handler((event, meta) -> {
            byte value = (Byte)meta.getValue();
            if ((value & 4) != 0) {
                event.createExtraMeta(new Metadata(14, Types1_13_2.META_TYPES.booleanType, (Object)true));
            }
        });
        this.filter().filterFamily((EntityType)Entity1_14Types.ZOMBIE).index(13).handler((event, meta) -> {
            byte value = (Byte)meta.getValue();
            if ((value & 4) != 0) {
                event.createExtraMeta(new Metadata(16, Types1_13_2.META_TYPES.booleanType, (Object)true));
            }
        });
        this.filter().filterFamily((EntityType)Entity1_14Types.ZOMBIE).addIndex(16);
        this.filter().filterFamily((EntityType)Entity1_14Types.LIVINGENTITY).handler((event, meta) -> {
            int index = event.index();
            if (index == 12) {
                Position position = (Position)meta.getValue();
                if (position != null) {
                    PacketWrapper wrapper = PacketWrapper.create((PacketType)ClientboundPackets1_13.USE_BED, null, (UserConnection)event.user());
                    wrapper.write((Type)Type.VAR_INT, (Object)event.entityId());
                    wrapper.write(Type.POSITION, (Object)position);
                    try {
                        wrapper.scheduleSend(Protocol1_13_2To1_14.class);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                event.cancel();
            } else if (index > 12) {
                event.setIndex(index - 1);
            }
        });
        this.filter().removeIndex(6);
        this.filter().type((EntityType)Entity1_14Types.OCELOT).index(13).handler((event, meta) -> {
            event.setIndex(15);
            meta.setTypeAndValue(Types1_13_2.META_TYPES.varIntType, (Object)0);
        });
        this.filter().type((EntityType)Entity1_14Types.CAT).handler((event, meta) -> {
            if (event.index() == 15) {
                meta.setValue((Object)1);
            } else if (event.index() == 13) {
                meta.setValue((Object)((byte)((Byte)meta.getValue() & 4)));
            }
        });
        this.filter().handler((event, meta) -> {
            if (meta.metaType().typeId() > 15) {
                throw new IllegalArgumentException("Unhandled metadata: " + meta);
            }
        });
    }

    public int villagerDataToProfession(VillagerData data) {
        switch (data.profession()) {
            case 1: 
            case 10: 
            case 13: 
            case 14: {
                return 3;
            }
            case 2: 
            case 8: {
                return 4;
            }
            case 3: 
            case 9: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: 
            case 6: 
            case 7: 
            case 12: {
                return 0;
            }
        }
        return 5;
    }

    public EntityType typeFromId(int typeId) {
        return Entity1_14Types.getTypeFromId((int)typeId);
    }
}

