/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.luckperms.placeholders;

import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Locale;
import java.util.Map;

class DurationFormatter {
    public static final DurationFormatter LONG = new DurationFormatter(false);
    public static final DurationFormatter CONCISE = new DurationFormatter(true);
    public static final DurationFormatter CONCISE_LOW_ACCURACY = new DurationFormatter(true, 3);
    private static final ChronoUnit[] UNITS = new ChronoUnit[]{ChronoUnit.YEARS, ChronoUnit.MONTHS, ChronoUnit.WEEKS, ChronoUnit.DAYS, ChronoUnit.HOURS, ChronoUnit.MINUTES, ChronoUnit.SECONDS};
    private final boolean concise;
    private final int accuracy;
    private static final Map<String, String> TRANSLATIONS = ImmutableMap.builder().put((Object)"luckperms.duration.unit.years.plural", (Object)"%s years").put((Object)"luckperms.duration.unit.years.singular", (Object)"%s year").put((Object)"luckperms.duration.unit.years.short", (Object)"%sy").put((Object)"luckperms.duration.unit.months.plural", (Object)"%s months").put((Object)"luckperms.duration.unit.months.singular", (Object)"%s month").put((Object)"luckperms.duration.unit.months.short", (Object)"%smo").put((Object)"luckperms.duration.unit.weeks.plural", (Object)"%s weeks").put((Object)"luckperms.duration.unit.weeks.singular", (Object)"%s week").put((Object)"luckperms.duration.unit.weeks.short", (Object)"%sw").put((Object)"luckperms.duration.unit.days.plural", (Object)"%s days").put((Object)"luckperms.duration.unit.days.singular", (Object)"%s day").put((Object)"luckperms.duration.unit.days.short", (Object)"%sd").put((Object)"luckperms.duration.unit.hours.plural", (Object)"%s hours").put((Object)"luckperms.duration.unit.hours.singular", (Object)"%s hour").put((Object)"luckperms.duration.unit.hours.short", (Object)"%sh").put((Object)"luckperms.duration.unit.minutes.plural", (Object)"%s minutes").put((Object)"luckperms.duration.unit.minutes.singular", (Object)"%s minute").put((Object)"luckperms.duration.unit.minutes.short", (Object)"%sm").put((Object)"luckperms.duration.unit.seconds.plural", (Object)"%s seconds").put((Object)"luckperms.duration.unit.seconds.singular", (Object)"%s second").put((Object)"luckperms.duration.unit.seconds.short", (Object)"%ss").build();

    public DurationFormatter(boolean concise) {
        this(concise, Integer.MAX_VALUE);
    }

    public DurationFormatter(boolean concise, int accuracy) {
        this.concise = concise;
        this.accuracy = accuracy;
    }

    public String format(Duration duration) {
        long seconds = duration.getSeconds();
        StringBuilder builder = new StringBuilder();
        int outputSize = 0;
        for (ChronoUnit unit : UNITS) {
            long n = seconds / unit.getDuration().getSeconds();
            if (n > 0L) {
                seconds -= unit.getDuration().getSeconds() * n;
                if (outputSize != 0) {
                    builder.append(' ');
                }
                builder.append(this.formatPart(n, unit));
                ++outputSize;
            }
            if (seconds <= 0L || outputSize >= this.accuracy) break;
        }
        if (outputSize == 0) {
            return this.formatPart(0L, ChronoUnit.SECONDS);
        }
        return builder.toString();
    }

    private String formatPart(long amount, ChronoUnit unit) {
        String format = this.concise ? "short" : (amount == 1L ? "singular" : "plural");
        String translationKey = "luckperms.duration.unit." + unit.name().toLowerCase(Locale.ROOT) + "." + format;
        return String.format(TRANSLATIONS.get(translationKey), amount);
    }
}

