/*
 * Decompiled with CFR 0.152.
 */
package me.leoo.bedwars.rewardsummary.utils;

import com.andrei1058.bedwars.BedWars;
import com.google.common.base.Strings;
import java.text.DecimalFormat;
import java.util.HashMap;
import me.leoo.bedwars.rewardsummary.Main;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class SummaryUtils {
    private static final HashMap<Player, Integer> startMoney = new HashMap();
    private static final HashMap<Player, Integer> endMoney = new HashMap();
    private static final HashMap<Player, Integer> startExp = new HashMap();
    private static final HashMap<Player, Integer> endExp = new HashMap();
    private static final HashMap<Player, Integer> levelUpExp = new HashMap();

    public void sendMsg(Player player) {
        for (String s : Main.getPlugin().getMainConfig().getList("reward_summary.message")) {
            DecimalFormat decimalFormat = new DecimalFormat("###.##");
            String percentage = decimalFormat.format((double)BedWars.getLevelSupport().getCurrentXp(player) / (double)BedWars.getLevelSupport().getRequiredXp(player) * 100.0);
            s = s.replace("{coinsEarned}", String.valueOf(this.getEarnedMoney(player))).replace("{currentLevel}", String.valueOf(BedWars.getLevelSupport().getPlayerLevel(player))).replace("{nextLevelText}", this.getPrestigeText(player)).replace("{progressBar}", this.getProgressBar(BedWars.getLevelSupport().getCurrentXp(player), BedWars.getLevelSupport().getRequiredXp(player), Main.getPlugin().getMainConfig().getString("reward_summary.progress_bar.symbol").charAt(0), ChatColor.translateAlternateColorCodes((char)'&', (String)Main.getPlugin().getMainConfig().getString("reward_summary.progress_bar.unlocked-color")), ChatColor.translateAlternateColorCodes((char)'&', (String)Main.getPlugin().getMainConfig().getString("reward_summary.progress_bar.locked-color")))).replace("{currentXp}", String.valueOf(BedWars.getLevelSupport().getCurrentXp(player))).replace("{requiredXp}", String.valueOf(BedWars.getLevelSupport().getRequiredXp(player))).replace("{percentage}", percentage).replace("{expEarned}", String.valueOf(this.getEarnedExp(player)));
            player.sendMessage(s);
        }
    }

    private Integer getEarnedMoney(Player player) {
        if (!endMoney.containsKey(player) || !startMoney.containsKey(player)) {
            return 0;
        }
        return endMoney.get(player) - startMoney.get(player);
    }

    private Integer getEarnedExp(Player player) {
        if (!(endExp.containsKey(player) && startExp.containsKey(player) && levelUpExp.containsKey(player))) {
            return 0;
        }
        return endExp.get(player) - startExp.get(player) + levelUpExp.get(player);
    }

    private String getProgressBar(int current, int max, char symbol, String completedColor, String notCompletedColor) {
        float percent = (float)current / (float)max;
        int progressBars = (int)(34.0f * percent);
        return Strings.repeat((String)(completedColor + symbol), (int)progressBars) + Strings.repeat((String)(notCompletedColor + symbol), (int)(34 - progressBars));
    }

    private String getPrestigeText(Player player) {
        Object required = Main.getPlugin().getMainConfig().getString("reward_summary.new_level.level_name") + (BedWars.getLevelSupport().getPlayerLevel(player) + 1);
        int level = BedWars.getLevelSupport().getPlayerLevel(player) + 1;
        for (String colorString : Main.getPlugin().getMainConfig().getList("reward_summary.new_level.text")) {
            String[] str = colorString.split(":");
            int str1 = Integer.parseInt(str[0].split("-")[0]);
            int str2 = Integer.parseInt(str[0].split("-")[1]);
            if (level < str1 || level > str2) continue;
            required = str[1].replace("{level}", Main.getPlugin().getMainConfig().getString("reward_summary.new_level.level_name") + " " + (BedWars.getLevelSupport().getPlayerLevel(player) + 1));
        }
        return required;
    }

    public static HashMap<Player, Integer> getStartMoney() {
        return startMoney;
    }

    public static HashMap<Player, Integer> getEndMoney() {
        return endMoney;
    }

    public static HashMap<Player, Integer> getStartExp() {
        return startExp;
    }

    public static HashMap<Player, Integer> getEndExp() {
        return endExp;
    }

    public static HashMap<Player, Integer> getLevelUpExp() {
        return levelUpExp;
    }
}

