/*
 * Decompiled with CFR 0.152.
 */
package me.leoo.bedwars.mapselector.configuration;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import me.leoo.bedwars.mapselector.MapSelector;
import me.leoo.bedwars.mapselector.configuration.ConfigManager;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class MainConfig
extends ConfigManager {
    public MainConfig(Plugin plugin, String name, String directory) {
        super(plugin, name, directory);
        YamlConfiguration yml = this.getYml();
        yml.options().header(MapSelector.getPlugin().getDescription().getName() + " v" + MapSelector.getPlugin().getDescription().getVersion() + " made by " + MapSelector.getPlugin().getDescription().getAuthors() + ".\nDependencies: " + MapSelector.getPlugin().getDescription().getDepend() + ".\nSoft Dependencies: " + MapSelector.getPlugin().getDescription().getSoftDepend() + ".\nSee the wiki: https://leo18bernese.gitbook.io/bedwars1058-mapselector/\nJoin my discord server for support: https://discord.gg/dtwanz4GQg\nStorage methods: MySQL / SQLite.\n");
        yml.addDefault("map-selector.debug", (Object)Boolean.FALSE);
        yml.addDefault("map-selector.storage", (Object)"SQLite");
        yml.addDefault("map-selector.last-date", (Object)Calendar.getInstance().get(5));
        yml.addDefault("map-selector.messages.open.group-doesnt-exists", (Object)"&cThis group doesn't exists");
        yml.addDefault("map-selector.messages.open.missing", (Object)"&cUse: /bwmenu <group>");
        yml.addDefault("map-selector.messages.open.missing2", (Object)"&cUse: /bwmap <group>");
        yml.addDefault("map-selector.messages.reload.success", (Object)"&aConfiguration reloaded!");
        yml.addDefault("map-selector.messages.reset-uses.missing", (Object)"&cUse: /bwselector resetuses <player>");
        yml.addDefault("map-selector.messages.reset-uses.not-found", (Object)"&cPlayer not found!");
        yml.addDefault("map-selector.messages.reset-uses.success", (Object)"&aReset uses of {player}!");
        yml.addDefault("map-selector.messages.set-uses.missing", (Object)"&cUse: /bwselector setuses <player> <uses>");
        yml.addDefault("map-selector.messages.set-uses.not-found", (Object)"&cPlayer not found!");
        yml.addDefault("map-selector.messages.set-uses.success", (Object)"&aSet uses of {player} to {uses}!");
        yml.addDefault("map-selector.messages.limit-reached", (Object)"&cYou've reached your limit of daily map selections today!");
        yml.addDefault("map-selector.messages.no-favorites-maps", (Object)"&cYou don't have any favorite maps");
        yml.addDefault("map-selector.messages.no-maps", (Object)"&cThere aren't any available arenas of this group");
        yml.addDefault("map-selector.messages.not-party-leader", (Object)"&cYou can't join arenas because your aren't the leader of your party");
        yml.addDefault("map-selector.selections.permission", (Object)"bwselector.selector");
        yml.addDefault("map-selector.selections.unlimited-message", (Object)"Unlimited");
        yml.addDefault("map-selector.menus.bedwars-menu.title", (Object)"&8Play Bed Wars ");
        yml.addDefault("map-selector.menus.bedwars-menu.slots", (Object)36);
        yml.addDefault("map-selector.menus.maps-menu.title", (Object)"&8Bed Wars ");
        yml.addDefault("map-selector.menus.maps-menu.slots", (Object)54);
        yml.addDefault("map-selector.menus.maps-menu.maps-slots", (Object)"10,11,12,13,14,15,16,19,20,21,22,23,24,25,28,29,30,31,32,33,34");
        this.addFirstGuiItem("join-random", 12, false, Material.BED, "&aBed Wars ({groupName})", Arrays.asList("&7Play a game of Bed Wars {groupName}.", "", "&eClick to play!"));
        this.addFirstGuiItem("map-selector", 14, false, Material.SIGN, "&aMap Selector ({groupName})", Arrays.asList("&7Pick which map you want to play", "&7from a list of available games.", "", "&eClick to browse!"));
        this.addFirstGuiItem("close", 31, false, Material.BARRIER, "&cClose", Collections.emptyList());
        this.addFirstGuiItem("rejoin", 35, false, Material.ENDER_PEARL, "&cClick here to rejoin!", Arrays.asList("&7Click here to rejoin your game", "&7if you have been disconnected", "&7from it."));
        this.addSecondGuiItem("map", 0, false, Material.PAPER, "&a{mapName}", Arrays.asList("&8{groupName}", "", "&7Available Games: &a{availableGames}", "&7Times Joined: &a{timesJoined}", "&7Map Selections: &a{selectionsType}", "", "&a\u25b8 Click to Play", "&eRight click to toggle favorite!"));
        this.addSecondGuiItem("map-favorite", 0, false, Material.EMPTY_MAP, "&b\u272b &a{mapName}", Arrays.asList("&8{groupName}", "", "&7Available Games: &a{availableGames}", "&7Times Joined: &a{timesJoined}", "&7Map Selections: &a{selectionsType}", "", "&a\u25b8 Click to Play", "&eRight click to toggle favorite!"));
        this.addSecondGuiItem("map-no-permissions-no-uses", 0, false, Material.SULPHUR, "&a{mapName}", Arrays.asList("&8{groupName}", "", "&7Available Games: &a{availableGames}", "&7Times Joined: &a{timesJoined}", "&7Map Selections: &a{selectionsType}", "", "&c\u2718 You don't have the required rank(s)", "&cor you have reached", "&cthe daily map selections limit!"));
        this.addSecondGuiItem("random-map", 39, false, Material.FIREWORK, "&aRandom Map", Arrays.asList("&8{groupName}", "", "&7Map selections: &a{selectionsType}", "", "&a\u25b8 Click to Play"));
        this.addSecondGuiItem("random-favourite", 41, false, Material.DIAMOND, "&aRandom Favourite", Arrays.asList("&8{groupName}", "", "&7Map selections: &a{selectionsType}", "", "&a\u25b8 Click to Play"));
        this.addSecondGuiItem("back", 49, false, Material.ARROW, "&aBack", Collections.emptyList());
        this.addSecondGuiItem("next-page", 26, false, Material.ARROW, "&aNext Page", Collections.singletonList("&ePage {nextPage}"));
        this.addSecondGuiItem("previous-page", 18, false, Material.ARROW, "&aPrevious Page", Collections.singletonList("&ePage {previousPage}"));
        this.addFirstGuiItem("practice", 27, true, Material.WOOL, "&aPractice", Arrays.asList("&7Improve your gameplay by", "&7practicing different aspects of", "&7Bed Wars!", "", "&eClick to view modes!"));
        this.addSecondGuiItem("book", 53, true, Material.BOOK, "&aMap Selection", Arrays.asList("&7Each day you can choose which", "&7map you want to play 1 time.", "&7Unlock unlimited map selection!", "&7by upgrading to &bMVP&c+ &7rank", "&7on our store!", "", "&ehttps://store.hypixel.net!"));
        this.addSelectionsType(yml, "default", "bwselector.default", 3, false);
        this.addSelectionsType(yml, "mvp+", "bwselector.mvp+", 0, true);
        this.addSelectionsType(yml, "admin", "bwselector.admin", 0, true);
        yml.options().copyDefaults(true);
        this.save();
    }

    public void addFirstGuiItem(String name, int slot, boolean extra, Material material, String itemName, List<String> itemLore) {
        this.getYml().addDefault("map-selector.menus.bedwars-menu.items." + name + ".material", (Object)material.name());
        this.getYml().addDefault("map-selector.menus.bedwars-menu.items." + name + ".enabled", (Object)true);
        this.getYml().addDefault("map-selector.menus.bedwars-menu.items." + name + ".extra", (Object)extra);
        this.getYml().addDefault("map-selector.menus.bedwars-menu.items." + name + ".slot", (Object)slot);
        this.getYml().addDefault("map-selector.menus.bedwars-menu.items." + name + ".command", (Object)"default-action");
        this.getYml().addDefault("map-selector.menus.bedwars-menu.items." + name + ".head-value", (Object)"Head value here (see: https://bit.ly/3eF7h8l)");
        this.getYml().addDefault("map-selector.menus.bedwars-menu.items." + name + ".data", (Object)0);
        this.getYml().addDefault("map-selector.menus.bedwars-menu.items." + name + ".name", (Object)itemName);
        this.getYml().addDefault("map-selector.menus.bedwars-menu.items." + name + ".lore", itemLore);
        this.getYml().addDefault("map-selector.menus.bedwars-menu.items." + name + ".enchanted", (Object)false);
    }

    public void addSecondGuiItem(String name, int slot, boolean extra, Material material, String itemName, List<String> itemLore) {
        this.getYml().addDefault("map-selector.menus.maps-menu.items." + name + ".material", (Object)material.name());
        this.getYml().addDefault("map-selector.menus.maps-menu.items." + name + ".enabled", (Object)true);
        this.getYml().addDefault("map-selector.menus.maps-menu.items." + name + ".extra", (Object)extra);
        this.getYml().addDefault("map-selector.menus.maps-menu.items." + name + ".slot", (Object)slot);
        this.getYml().addDefault("map-selector.menus.maps-menu.items." + name + ".command", (Object)"default-action");
        this.getYml().addDefault("map-selector.menus.maps-menu.items." + name + ".head-value", (Object)"Head value here (see: https://bit.ly/3eF7h8l)");
        this.getYml().addDefault("map-selector.menus.maps-menu.items." + name + ".data", (Object)0);
        this.getYml().addDefault("map-selector.menus.maps-menu.items." + name + ".name", (Object)itemName);
        this.getYml().addDefault("map-selector.menus.maps-menu.items." + name + ".lore", itemLore);
        this.getYml().addDefault("map-selector.menus.maps-menu.items." + name + ".enchanted", (Object)false);
    }

    public void addSelectionsType(YamlConfiguration yml, String name, String permission, int uses, boolean unlimited) {
        yml.addDefault("map-selector.selections.selections." + name + ".permission", (Object)permission);
        yml.addDefault("map-selector.selections.selections." + name + ".daily-uses", (Object)uses);
        yml.addDefault("map-selector.selections.selections." + name + ".unlimited", (Object)unlimited);
    }
}

