/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.metrics;

import com.zaxxer.hikari.util.ClockSource;
import java.util.concurrent.atomic.AtomicLong;

public abstract class PoolStats {
    private final ClockSource clock;
    private final AtomicLong reloadAt;
    private final long timeoutMs;
    protected volatile int totalConnections;
    protected volatile int idleConnections;
    protected volatile int activeConnections;
    protected volatile int pendingThreads;

    public PoolStats(long timeoutMs) {
        this.timeoutMs = timeoutMs;
        this.reloadAt = new AtomicLong(0L);
        this.clock = ClockSource.INSTANCE;
    }

    protected int getTotalConnections() {
        if (this.shouldLoad()) {
            this.update();
        }
        return this.totalConnections;
    }

    protected int getIdleConnections() {
        if (this.shouldLoad()) {
            this.update();
        }
        return this.idleConnections;
    }

    protected int getActiveConnections() {
        if (this.shouldLoad()) {
            this.update();
        }
        return this.activeConnections;
    }

    protected int getPendingThreads() {
        if (this.shouldLoad()) {
            this.update();
        }
        return this.pendingThreads;
    }

    protected abstract void update();

    private boolean shouldLoad() {
        long time;
        long current;
        do {
            time = this.clock.currentTime();
            current = this.reloadAt.get();
            if (current <= time) continue;
            return false;
        } while (!this.reloadAt.compareAndSet(current, this.clock.plusMillis(time, this.timeoutMs)));
        return true;
    }
}

