/*
 * Decompiled with CFR 0.152.
 */
package me.cubecrafter.playagain.utils;

import com.andrei1058.bedwars.api.arena.IArena;
import java.util.List;
import me.cubecrafter.playagain.PlayAgain;
import me.cubecrafter.playagain.arena.ArenaData;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public final class TextUtil {
    public static String color(String s) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }

    public static List<String> color(List<String> lines) {
        lines.replaceAll(TextUtil::color);
        return lines;
    }

    public static void sendMessage(Player player, String message) {
        player.sendMessage(TextUtil.color(message));
    }

    public static void info(String message) {
        PlayAgain.getInstance().getLogger().info(message);
    }

    public static void severe(String message) {
        PlayAgain.getInstance().getLogger().severe(message);
    }

    public static String format(String s, ArenaData arena) {
        return TextUtil.color(s).replace("{displayname}", arena.getName()).replace("{players}", String.valueOf(arena.getPlayers())).replace("{max_players}", String.valueOf(arena.getMaxPlayers())).replace("{max_team_players}", String.valueOf(arena.getMaxInTeam())).replace("{group}", arena.getGroup()).replace("{state}", arena.getState()).replace("{name}", arena.getName());
    }

    public static List<String> format(List<String> lines, ArenaData arena) {
        lines.replaceAll(s -> TextUtil.format(s, arena));
        return lines;
    }

    public static String format(String s, IArena arena) {
        return TextUtil.color(s).replace("{displayname}", arena.getDisplayName()).replace("{players}", String.valueOf(arena.getPlayers().size())).replace("{max_players}", String.valueOf(arena.getMaxPlayers())).replace("{max_team_players}", String.valueOf(arena.getMaxInTeam())).replace("{group}", arena.getGroup()).replace("{state}", arena.getStatus().toString()).replace("{name}", arena.getArenaName());
    }

    public static List<String> format(List<String> lines, IArena arena) {
        lines.replaceAll(s -> TextUtil.format(s, arena));
        return lines;
    }

    public static TextComponent buildTextComponent(String text, String click, String hover, ClickEvent.Action action) {
        TextComponent component = new TextComponent(TextUtil.color(text));
        component.setClickEvent(new ClickEvent(action, click));
        component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(TextUtil.color(hover)).create()));
        return component;
    }

    private TextUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

