/*
 * Decompiled with CFR 0.152.
 */
package me.cubecrafter.playagain.proxy;

import com.andrei1058.bedwars.proxy.arenamanager.ArenaManager;
import com.andrei1058.bedwars.proxy.socketmanager.ArenaSocketTask;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import me.cubecrafter.playagain.PlayAgain;
import me.cubecrafter.playagain.proxy.ProxySocket;
import me.cubecrafter.playagain.utils.TextUtil;

public class ProxySocketTask
implements Runnable {
    private final ProxySocket proxySocket;
    private final Socket socket;
    private Scanner in;
    private PrintWriter out;
    private final Gson gson = new Gson();

    public ProxySocketTask(ProxySocket proxySocket, Socket socket) {
        this.socket = socket;
        this.proxySocket = proxySocket;
        try {
            this.in = new Scanner(socket.getInputStream());
            this.out = new PrintWriter(socket.getOutputStream(), true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        while (this.socket.isConnected()) {
            if (this.in.hasNext()) {
                String message = this.in.next();
                if (message.isEmpty()) continue;
                System.out.println("MESSAGE RECEIVED: " + message);
                List data = (List)this.gson.fromJson(message, new TypeToken<List<Map<String, String>>>(){}.getType());
                String server = (String)((Map)data.get(0)).get("server");
                ArenaSocketTask socket = ArenaManager.getSocketByServer((String)server);
                for (Map map : data) {
                    JsonObject msg = new JsonObject();
                    msg.addProperty("type", "PLD");
                    msg.addProperty("uuid", (String)map.get("uuid"));
                    msg.addProperty("lang_iso", (String)map.get("iso"));
                    msg.addProperty("target", map.get("party") == null ? "" : (String)map.get("party"));
                    msg.addProperty("arena_identifier", (String)map.get("id"));
                    socket.getOut().println(msg);
                    if (!Boolean.parseBoolean((String)map.get("local"))) continue;
                    PlayAgain.getInstance().getProxyListener().addCache(UUID.fromString((String)map.get("uuid")), server);
                }
                continue;
            }
            this.proxySocket.getTasks().remove(this);
            TextUtil.info("Remote game server disconnected: " + this.socket.getInetAddress().getHostAddress() + ":" + this.socket.getPort());
            break;
        }
    }

    public void sendMessage(String message) {
        this.out.println(message);
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

