/*
 * Decompiled with CFR 0.152.
 */
package me.cubecrafter.playagain.proxy;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import me.cubecrafter.playagain.PlayAgain;
import me.cubecrafter.playagain.config.Configuration;
import me.cubecrafter.playagain.proxy.ProxySocketTask;
import me.cubecrafter.playagain.utils.TextUtil;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class ProxySocket {
    private final List<ProxySocketTask> tasks = new ArrayList<ProxySocketTask>();
    private ServerSocket serverSocket;
    private boolean listen = true;

    public ProxySocket() {
        try {
            this.serverSocket = new ServerSocket(Configuration.BUNGEE_LOBBY_PORT.getAsInt());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)PlayAgain.getInstance(), () -> {
            while (this.listen) {
                try {
                    Socket socket = this.serverSocket.accept();
                    ProxySocketTask task = new ProxySocketTask(this, socket);
                    this.tasks.add(task);
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)PlayAgain.getInstance(), (Runnable)task);
                    TextUtil.info("Remote game server connected: " + socket.getInetAddress().getHostAddress() + ":" + socket.getPort());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void sendMessage(String message) {
        for (ProxySocketTask task : this.tasks) {
            task.sendMessage(message);
        }
    }

    public void close() {
        this.listen = false;
        for (ProxySocketTask task : this.tasks) {
            task.close();
        }
        this.tasks.clear();
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<ProxySocketTask> getTasks() {
        return this.tasks;
    }
}

