/*
 * Decompiled with CFR 0.152.
 */
package me.cubecrafter.playagain.proxy;

import com.andrei1058.bedwars.proxy.api.ArenaStatus;
import com.andrei1058.bedwars.proxy.api.CachedArena;
import com.andrei1058.bedwars.proxy.arenamanager.ArenaManager;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.cubecrafter.playagain.PlayAgain;
import me.cubecrafter.playagain.arena.ArenaData;
import me.cubecrafter.playagain.proxy.PlayerCache;
import me.cubecrafter.playagain.proxy.ProxySocket;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class ProxyListener
implements Runnable,
Listener {
    private final ProxySocket proxySocket;
    private final Map<UUID, PlayerCache> joinCache = new HashMap<UUID, PlayerCache>();
    private final Gson gson = new Gson();

    public ProxyListener() {
        this.proxySocket = new ProxySocket();
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)PlayAgain.getInstance());
        Bukkit.getScheduler().runTaskTimer((Plugin)PlayAgain.getInstance(), (Runnable)this, 0L, 20L);
    }

    public void addCache(UUID uuid, String server) {
        this.joinCache.put(uuid, new PlayerCache(uuid, server, System.currentTimeMillis()));
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.joinCache.containsKey(player.getUniqueId())) {
            PlayerCache cache = this.joinCache.get(player.getUniqueId());
            this.joinCache.remove(player.getUniqueId());
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF("Connect");
            out.writeUTF(cache.getServer());
            Bukkit.getScheduler().runTaskLater((Plugin)PlayAgain.getInstance(), () -> player.sendPluginMessage((Plugin)PlayAgain.getInstance(), "BungeeCord", out.toByteArray()), 1L);
        }
    }

    @Override
    public void run() {
        ArrayList<ArenaData> data = new ArrayList<ArenaData>();
        for (CachedArena arena : new ArrayList(ArenaManager.getArenas())) {
            if (arena.getStatus() != ArenaStatus.WAITING && arena.getStatus() != ArenaStatus.STARTING) continue;
            ArenaData arenaData = new ArenaData(arena.getServer(), arena.getArenaName(), arena.getRemoteIdentifier(), arena.getArenaGroup(), arena.getMaxPlayers(), arena.getMaxInTeam());
            arenaData.setState(arena.getStatus().toString());
            arenaData.setPlayers(arena.getCurrentPlayers());
            data.add(arenaData);
        }
        this.proxySocket.sendMessage(this.gson.toJson(data));
        for (PlayerCache cache : new ArrayList<PlayerCache>(this.joinCache.values())) {
            if (!cache.isExpired()) continue;
            this.joinCache.remove(cache.getUuid());
        }
    }

    public void close() {
        this.proxySocket.close();
    }
}

