/*
 * Decompiled with CFR 0.152.
 */
package me.cubecrafter.playagain.proxy;

import java.util.UUID;

public class PlayerCache {
    private final UUID uuid;
    private final String server;
    private final long time;

    public boolean isExpired() {
        return System.currentTimeMillis() - this.time > 10000L;
    }

    public PlayerCache(UUID uuid, String server, long time) {
        this.uuid = uuid;
        this.server = server;
        this.time = time;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getServer() {
        return this.server;
    }

    public long getTime() {
        return this.time;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PlayerCache)) {
            return false;
        }
        PlayerCache other = (PlayerCache)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTime() != other.getTime()) {
            return false;
        }
        UUID this$uuid = this.getUuid();
        UUID other$uuid = other.getUuid();
        if (this$uuid == null ? other$uuid != null : !((Object)this$uuid).equals(other$uuid)) {
            return false;
        }
        String this$server = this.getServer();
        String other$server = other.getServer();
        return !(this$server == null ? other$server != null : !this$server.equals(other$server));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PlayerCache;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $time = this.getTime();
        result = result * 59 + (int)($time >>> 32 ^ $time);
        UUID $uuid = this.getUuid();
        result = result * 59 + ($uuid == null ? 43 : ((Object)$uuid).hashCode());
        String $server = this.getServer();
        result = result * 59 + ($server == null ? 43 : $server.hashCode());
        return result;
    }

    public String toString() {
        return "PlayerCache(uuid=" + this.getUuid() + ", server=" + this.getServer() + ", time=" + this.getTime() + ")";
    }
}

