/*
 * Decompiled with CFR 0.152.
 */
package me.cubecrafter.playagain.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import me.cubecrafter.playagain.PlayAgain;
import org.bukkit.configuration.file.YamlConfiguration;

public class FileManager {
    private YamlConfiguration config;
    private final File configFile;

    public FileManager(PlayAgain plugin, boolean proxy) {
        File folder = new File("plugins/" + (proxy ? "BedWarsProxy" : "BedWars1058") + "/Addons/PlayAgain");
        if (!folder.exists()) {
            folder.mkdirs();
        }
        this.configFile = new File(folder, "config.yml");
        if (!this.configFile.exists()) {
            this.saveResource(plugin.getResource("config.yml"), this.configFile);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    private void saveResource(InputStream in, File destination) {
        try (OutputStream out = Files.newOutputStream(destination.toPath(), new OpenOption[0]);){
            int len;
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                out.write(buf, 0, len);
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reload() {
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
    }

    public YamlConfiguration getConfig() {
        return this.config;
    }
}

