/*
 * Decompiled with CFR 0.152.
 */
package me.cubecrafter.playagain.arena;

import com.andrei1058.bedwars.api.arena.IArena;
import com.andrei1058.bedwars.api.language.Language;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.cubecrafter.playagain.PlayAgain;
import me.cubecrafter.playagain.arena.ArenaData;
import me.cubecrafter.playagain.arena.SocketTask;
import me.cubecrafter.playagain.config.Configuration;
import me.cubecrafter.playagain.utils.TextUtil;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class BungeeArenaManager {
    private final List<ArenaData> cache = new ArrayList<ArenaData>();
    private final PlayAgain plugin;
    private final String serverId;
    private final SocketTask socketTask;
    private final Gson gson = new Gson();

    public BungeeArenaManager(PlayAgain plugin) {
        this.plugin = plugin;
        this.serverId = plugin.getBedWars().getConfigs().getMainConfig().getString("bungee-settings.server-id");
        this.socketTask = new SocketTask();
    }

    public ArenaData getCache(String server, String name) {
        return this.cache.stream().filter(arena -> arena.getServer().equals(server) && arena.getName().equals(name)).findAny().orElse(null);
    }

    public void createCache(ArenaData data) {
        this.cache.add(data);
    }

    public void removeCache(ArenaData data) {
        this.cache.remove(data);
    }

    public List<ArenaData> getArenas() {
        return new ArrayList<ArenaData>(this.cache);
    }

    public void joinRandomArena(Player player, String group) {
        List<ArenaData> available = this.getAvailableArenas(group);
        ArenaData arena = available.stream().max(Comparator.comparingInt(ArenaData::getPlayers)).orElse(available.get(0));
        this.joinArena(player, arena);
    }

    public List<ArenaData> getAvailableArenas(String group) {
        if (group.equals("All")) {
            return this.getArenas().stream().filter(data -> data.getState().equals("WAITING") || data.getState().equals("STARTING")).collect(Collectors.toList());
        }
        return this.getArenas().stream().filter(data -> data.getGroup().equals(group) && (data.getState().equals("WAITING") || data.getState().equals("STARTING"))).collect(Collectors.toList());
    }

    public void joinArena(Player player, ArenaData data) {
        boolean local = data.getServer().equals(this.serverId);
        if (local) {
            IArena arena = this.plugin.getBedWars().getArenaUtil().getArenaByPlayer(player);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> arena.removePlayer(player, true), 10L);
        }
        ArrayList<Map<String, String>> message = new ArrayList<Map<String, String>>();
        if (this.plugin.getBedWars().getPartyUtil().hasParty(player) && this.plugin.getBedWars().getPartyUtil().isOwner(player)) {
            int size = this.plugin.getBedWars().getPartyUtil().partySize(player);
            if (size > data.getMaxInTeam() || size > data.getMaxPlayers() - data.getPlayers()) {
                TextUtil.sendMessage(player, Configuration.MESSAGES_PARTY_TOO_BIG.getAsString());
                return;
            }
            for (Player member : this.plugin.getBedWars().getPartyUtil().getMembers(player)) {
                if (member.equals(player)) continue;
                message.add(this.getUserData(member, data, local, player.getName()));
                if (local) continue;
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.connect(member, data.getServer()), 20L);
            }
        }
        message.add(this.getUserData(player, data, local, null));
        this.socketTask.sendMessage(this.gson.toJson(message));
        if (!local) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.connect(player, data.getServer()), 20L);
        }
    }

    public Map<String, String> getUserData(Player player, ArenaData data, boolean localArena, String partyOwner) {
        HashMap<String, String> message = new HashMap<String, String>();
        message.put("uuid", player.getUniqueId().toString());
        message.put("iso", Language.getPlayerLanguage((Player)player).getIso());
        message.put("id", data.getId());
        message.put("server", data.getServer());
        message.put("local", String.valueOf(localArena));
        message.put("party", partyOwner == null ? "" : partyOwner);
        return message;
    }

    public void connect(Player player, String server) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        out.writeUTF("Connect");
        out.writeUTF(server);
        player.sendPluginMessage((Plugin)PlayAgain.getInstance(), "BungeeCord", out.toByteArray());
    }

    public void close() {
        this.socketTask.close();
    }
}

