/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.clsm;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.nio.charset.StandardCharsets;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javassist.ByteArrayClassPath;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.yaml.snakeyaml.Yaml;

public class NMSTransformer
implements ClassFileTransformer {
    private static final Pattern PATTERN = Pattern.compile("^(\\w+)\\s*\\((.*?)\\)\\s*@(.+?\\.txt)$");
    private static final boolean DEBUG = Boolean.getBoolean("clsmDebug");
    private static Map<String, Change[]> changes = new HashMap<String, Change[]>();

    public static void premain(String agentArgs, Instrumentation instrumentation) {
        instrumentation.addTransformer(new NMSTransformer());
        try (InputStream fileStream = NMSTransformer.class.getResourceAsStream("/list.yml");){
            if (fileStream == null) {
                System.err.println("Failed to find change list.");
                System.exit(1);
                return;
            }
            Yaml yaml = new Yaml();
            try (InputStreamReader reader = new InputStreamReader(fileStream);){
                Map data = (Map)yaml.load(reader);
                Iterator iterator = data.keySet().iterator();
                while (iterator.hasNext()) {
                    Change[] oldChanges;
                    String originalClazz;
                    boolean optional = (originalClazz = (String)iterator.next()).startsWith("__optional__");
                    String clazz = originalClazz.substring(optional ? 12 : 0);
                    if (!(data.get(originalClazz) instanceof ArrayList)) {
                        System.err.println("Invalid change list for class " + clazz + ".");
                        continue;
                    }
                    List changeList = (List)data.get(originalClazz);
                    Change[] changeArray = new Change[changeList.size()];
                    for (int i = 0; i < changeList.size(); ++i) {
                        String content;
                        Matcher matcher = PATTERN.matcher((CharSequence)changeList.get(i));
                        if (!matcher.find()) {
                            System.err.println("Invalid change '" + (String)changeList.get(i) + "' on class " + clazz + ".");
                            System.exit(1);
                        }
                        String methodName = matcher.group(1);
                        String paramsString = matcher.group(2).trim();
                        String[] parameters = paramsString.isEmpty() ? new String[]{} : matcher.group(2).split(",");
                        String location = matcher.group(3);
                        try (InputStream changeStream = NMSTransformer.class.getResourceAsStream("/" + location);){
                            if (changeStream == null) {
                                System.err.println("Failed to find data for change " + (String)changeList.get(i) + " on class " + clazz + ".");
                                System.exit(1);
                            }
                            byte[] contentByteArray = NMSTransformer.readAllBytes(changeStream);
                            content = new String(contentByteArray, StandardCharsets.UTF_8);
                        }
                        changeArray[i] = new Change(methodName, parameters, content, optional);
                    }
                    if (DEBUG) {
                        System.out.println("Loaded " + changeArray.length + " changes for class " + clazz + ".");
                    }
                    if ((oldChanges = changes.get(clazz)) == null) {
                        changes.put(clazz, changeArray);
                        continue;
                    }
                    Change[] newChanges = new Change[oldChanges.length + changeArray.length];
                    System.arraycopy(oldChanges, 0, newChanges, 0, oldChanges.length);
                    System.arraycopy(changeArray, 0, newChanges, oldChanges.length, changeArray.length);
                    changes.put(clazz, newChanges);
                }
            }
        }
        catch (IOException ex) {
            System.err.println("Failed to load class list.");
            ex.printStackTrace();
        }
    }

    private static byte[] readAllBytes(InputStream stream) throws IOException {
        int readLen;
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((readLen = stream.read(buffer)) != -1) {
            byteStream.write(buffer, 0, readLen);
        }
        return byteStream.toByteArray();
    }

    @Override
    public byte[] transform(ClassLoader classLoader, String className, Class<?> classBeingTransformed, ProtectionDomain protectionDomain, byte[] bytes) {
        if (className != null && changes.containsKey(className)) {
            String fixedClassName = className.replace("/", ".");
            if (DEBUG) {
                System.out.println("Applying changes for class " + fixedClassName);
            }
            try {
                ClassPool pool = ClassPool.getDefault();
                pool.appendClassPath(new ByteArrayClassPath(fixedClassName, bytes));
                CtClass ctClass = pool.get(fixedClassName);
                for (Change change : changes.get(className)) {
                    CtMethod[] methods = ctClass.getDeclaredMethods(change.getMethodName());
                    boolean found = false;
                    block5: for (CtMethod method : methods) {
                        CtClass[] params = method.getParameterTypes();
                        if (params.length != change.getParams().length) continue;
                        for (int i = 0; i < params.length; ++i) {
                            if (!change.getParams()[i].trim().equals(params[i].getName())) continue block5;
                        }
                        found = true;
                        try {
                            method.insertBefore(change.getContent());
                            break;
                        }
                        catch (CannotCompileException ex) {
                            if (change.isOptional()) break;
                            throw ex;
                        }
                    }
                    if (found || change.isOptional()) continue;
                    throw new NotFoundException("Unknown method " + change.getMethodName());
                }
                return ctClass.toBytecode();
            }
            catch (IOException | CannotCompileException | NotFoundException ex) {
                System.err.println("Failed to override methods from class " + fixedClassName + ".");
                ex.printStackTrace();
            }
        }
        return null;
    }

    private static class Change {
        private final String methodName;
        private final String[] params;
        private final String content;
        private final boolean optional;

        public String getMethodName() {
            return this.methodName;
        }

        public String[] getParams() {
            return this.params;
        }

        public String getContent() {
            return this.content;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public Change(String methodName, String[] params, String content, boolean optional) {
            this.methodName = methodName;
            this.params = params;
            this.content = content;
            this.optional = optional;
        }
    }
}

