/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.command.tool;

import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.LocalConfiguration;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.blocks.BlockData;
import com.sk89q.worldedit.command.tool.DoubleActionBlockTool;
import com.sk89q.worldedit.entity.Player;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.extension.platform.Platform;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;

public class BlockDataCyler
implements DoubleActionBlockTool {
    @Override
    public boolean canUse(Actor player) {
        return player.hasPermission("worldedit.tool.data-cycler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleCycle(Platform server, LocalConfiguration config, Player player, LocalSession session, Location clicked, boolean forward) {
        World world = (World)clicked.getExtent();
        int type = world.getBlockType(clicked.toVector());
        int data = world.getBlockData(clicked.toVector());
        if (!(config.allowedDataCycleBlocks.isEmpty() || player.hasPermission("worldedit.override.data-cycler") || config.allowedDataCycleBlocks.contains(type))) {
            player.printError("You are not permitted to cycle the data value of that block.");
            return true;
        }
        int increment = forward ? 1 : -1;
        BaseBlock block = new BaseBlock(type, BlockData.cycle(type, data, increment));
        EditSession editSession = session.createEditSession(player);
        if (block.getData() < 0) {
            player.printError("That block's data cannot be cycled!");
        } else {
            try {
                editSession.setBlock(clicked.toVector(), block);
            }
            catch (MaxChangedBlocksException e) {
                player.printError("Max blocks change limit reached.");
            }
            finally {
                session.remember(editSession);
            }
        }
        return true;
    }

    @Override
    public boolean actPrimary(Platform server, LocalConfiguration config, Player player, LocalSession session, Location clicked) {
        return this.handleCycle(server, config, player, session, clicked, true);
    }

    @Override
    public boolean actSecondary(Platform server, LocalConfiguration config, Player player, LocalSession session, Location clicked) {
        return this.handleCycle(server, config, player, session, clicked, false);
    }
}

