/*
 * Decompiled with CFR 0.152.
 */
package com.sk89q.worldedit.bukkit.adapter.impl;

import com.google.common.base.Preconditions;
import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.ByteTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.DoubleTag;
import com.sk89q.jnbt.EndTag;
import com.sk89q.jnbt.FloatTag;
import com.sk89q.jnbt.IntArrayTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.LongTag;
import com.sk89q.jnbt.NBTConstants;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.blocks.BaseBlock;
import com.sk89q.worldedit.bukkit.adapter.BukkitImplAdapter;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.internal.Constants;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import net.minecraft.server.v1_8_R2.BiomeBase;
import net.minecraft.server.v1_8_R2.BlockPosition;
import net.minecraft.server.v1_8_R2.Entity;
import net.minecraft.server.v1_8_R2.EntityTypes;
import net.minecraft.server.v1_8_R2.NBTBase;
import net.minecraft.server.v1_8_R2.NBTTagByte;
import net.minecraft.server.v1_8_R2.NBTTagByteArray;
import net.minecraft.server.v1_8_R2.NBTTagCompound;
import net.minecraft.server.v1_8_R2.NBTTagDouble;
import net.minecraft.server.v1_8_R2.NBTTagEnd;
import net.minecraft.server.v1_8_R2.NBTTagFloat;
import net.minecraft.server.v1_8_R2.NBTTagInt;
import net.minecraft.server.v1_8_R2.NBTTagIntArray;
import net.minecraft.server.v1_8_R2.NBTTagList;
import net.minecraft.server.v1_8_R2.NBTTagLong;
import net.minecraft.server.v1_8_R2.NBTTagShort;
import net.minecraft.server.v1_8_R2.NBTTagString;
import net.minecraft.server.v1_8_R2.TileEntity;
import net.minecraft.server.v1_8_R2.World;
import net.minecraft.server.v1_8_R2.WorldServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_8_R2.CraftServer;
import org.bukkit.craftbukkit.v1_8_R2.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R2.block.CraftBlock;
import org.bukkit.craftbukkit.v1_8_R2.entity.CraftEntity;
import org.bukkit.event.entity.CreatureSpawnEvent;

public final class Spigot_v1_8_R2
implements BukkitImplAdapter {
    private final Logger logger = Logger.getLogger(this.getClass().getCanonicalName());
    private final Field nbtListTagListField;
    private final Method nbtCreateTagMethod;

    public Spigot_v1_8_R2() throws NoSuchFieldException, NoSuchMethodException {
        CraftServer.class.cast(Bukkit.getServer());
        this.nbtListTagListField = NBTTagList.class.getDeclaredField("list");
        this.nbtListTagListField.setAccessible(true);
        this.nbtCreateTagMethod = NBTBase.class.getDeclaredMethod("createTag", Byte.TYPE);
        this.nbtCreateTagMethod.setAccessible(true);
    }

    private static void readTagIntoTileEntity(NBTTagCompound tag, TileEntity tileEntity) {
        tileEntity.a(tag);
    }

    private static void readTileEntityIntoTag(TileEntity tileEntity, NBTTagCompound tag) {
        tileEntity.b(tag);
    }

    @Nullable
    private static String getEntityId(Entity entity) {
        return EntityTypes.b((Entity)entity);
    }

    @Nullable
    private static Entity createEntityFromId(String id, World world) {
        return EntityTypes.createEntityByName((String)id, (World)world);
    }

    private static void readTagIntoEntity(NBTTagCompound tag, Entity entity) {
        entity.f(tag);
    }

    private static void readEntityIntoTag(Entity entity, NBTTagCompound tag) {
        entity.e(tag);
    }

    @Override
    public int getBlockId(Material material) {
        return material.getId();
    }

    @Override
    public Material getMaterial(int id) {
        return Material.getMaterial((int)id);
    }

    @Override
    public int getBiomeId(Biome biome) {
        BiomeBase mcBiome = CraftBlock.biomeToBiomeBase((Biome)biome);
        return mcBiome != null ? mcBiome.id : 0;
    }

    @Override
    public Biome getBiome(int id) {
        BiomeBase mcBiome = BiomeBase.getBiome((int)id);
        return CraftBlock.biomeBaseToBiome((BiomeBase)mcBiome);
    }

    @Override
    public BaseBlock getBlock(Location location) {
        Preconditions.checkNotNull((Object)location);
        CraftWorld craftWorld = (CraftWorld)location.getWorld();
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        Block bukkitBlock = location.getBlock();
        BaseBlock block = new BaseBlock(bukkitBlock.getTypeId(), bukkitBlock.getData());
        TileEntity te = craftWorld.getHandle().getTileEntity(new BlockPosition(x, y, z));
        if (te != null) {
            NBTTagCompound tag = new NBTTagCompound();
            Spigot_v1_8_R2.readTileEntityIntoTag(te, tag);
            block.setNbtData((CompoundTag)this.toNative((NBTBase)tag));
        }
        return block;
    }

    @Override
    public boolean setBlock(Location location, BaseBlock block, boolean notifyAndLight) {
        TileEntity tileEntity;
        Preconditions.checkNotNull((Object)location);
        Preconditions.checkNotNull((Object)block);
        CraftWorld craftWorld = (CraftWorld)location.getWorld();
        int x = location.getBlockX();
        int y = location.getBlockY();
        int z = location.getBlockZ();
        boolean changed = location.getBlock().setTypeIdAndData(block.getId(), (byte)block.getData(), notifyAndLight);
        CompoundTag nativeTag = block.getNbtData();
        if (nativeTag != null && (tileEntity = craftWorld.getHandle().getTileEntity(new BlockPosition(x, y, z))) != null) {
            NBTTagCompound tag = (NBTTagCompound)this.fromNative(nativeTag);
            tag.set("x", (NBTBase)new NBTTagInt(x));
            tag.set("y", (NBTBase)new NBTTagInt(y));
            tag.set("z", (NBTBase)new NBTTagInt(z));
            Spigot_v1_8_R2.readTagIntoTileEntity(tag, tileEntity);
        }
        return changed;
    }

    @Override
    public BaseEntity getEntity(org.bukkit.entity.Entity entity) {
        Preconditions.checkNotNull((Object)entity);
        CraftEntity craftEntity = (CraftEntity)entity;
        Entity mcEntity = craftEntity.getHandle();
        String id = Spigot_v1_8_R2.getEntityId(mcEntity);
        if (id != null) {
            NBTTagCompound tag = new NBTTagCompound();
            Spigot_v1_8_R2.readEntityIntoTag(mcEntity, tag);
            return new BaseEntity(id, (CompoundTag)this.toNative((NBTBase)tag));
        }
        return null;
    }

    @Override
    @Nullable
    public org.bukkit.entity.Entity createEntity(Location location, BaseEntity state) {
        Preconditions.checkNotNull((Object)location);
        Preconditions.checkNotNull((Object)state);
        CraftWorld craftWorld = (CraftWorld)location.getWorld();
        WorldServer worldServer = craftWorld.getHandle();
        Entity createdEntity = Spigot_v1_8_R2.createEntityFromId(state.getTypeId(), (World)craftWorld.getHandle());
        if (createdEntity != null) {
            CompoundTag nativeTag = state.getNbtData();
            if (nativeTag != null) {
                NBTTagCompound tag = (NBTTagCompound)this.fromNative(nativeTag);
                for (String name : Constants.NO_COPY_ENTITY_NBT_FIELDS) {
                    tag.remove(name);
                }
                Spigot_v1_8_R2.readTagIntoEntity(tag, createdEntity);
            }
            createdEntity.setLocation(location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
            worldServer.addEntity(createdEntity, CreatureSpawnEvent.SpawnReason.CUSTOM);
            return createdEntity.getBukkitEntity();
        }
        return null;
    }

    private Tag toNative(NBTBase foreign) {
        if (foreign == null) {
            return null;
        }
        if (foreign instanceof NBTTagCompound) {
            HashMap<String, Tag> values = new HashMap<String, Tag>();
            Set foreignKeys = ((NBTTagCompound)foreign).c();
            for (String str : foreignKeys) {
                NBTBase base = ((NBTTagCompound)foreign).get(str);
                values.put(str, this.toNative(base));
            }
            return new CompoundTag(values);
        }
        if (foreign instanceof NBTTagByte) {
            return new ByteTag(((NBTTagByte)foreign).f());
        }
        if (foreign instanceof NBTTagByteArray) {
            return new ByteArrayTag(((NBTTagByteArray)foreign).c());
        }
        if (foreign instanceof NBTTagDouble) {
            return new DoubleTag(((NBTTagDouble)foreign).g());
        }
        if (foreign instanceof NBTTagFloat) {
            return new FloatTag(((NBTTagFloat)foreign).h());
        }
        if (foreign instanceof NBTTagInt) {
            return new IntTag(((NBTTagInt)foreign).d());
        }
        if (foreign instanceof NBTTagIntArray) {
            return new IntArrayTag(((NBTTagIntArray)foreign).c());
        }
        if (foreign instanceof NBTTagList) {
            try {
                return this.toNativeList((NBTTagList)foreign);
            }
            catch (Throwable e) {
                this.logger.log(Level.WARNING, "Failed to convert NBTTagList", e);
                return new ListTag(ByteTag.class, new ArrayList());
            }
        }
        if (foreign instanceof NBTTagLong) {
            return new LongTag(((NBTTagLong)foreign).c());
        }
        if (foreign instanceof NBTTagShort) {
            return new ShortTag(((NBTTagShort)foreign).e());
        }
        if (foreign instanceof NBTTagString) {
            return new StringTag(((NBTTagString)foreign).a_());
        }
        if (foreign instanceof NBTTagEnd) {
            return new EndTag();
        }
        throw new IllegalArgumentException("Don't know how to make native " + foreign.getClass().getCanonicalName());
    }

    private ListTag toNativeList(NBTTagList foreign) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        ArrayList<Tag> values = new ArrayList<Tag>();
        int type = foreign.f();
        List foreignList = (List)this.nbtListTagListField.get(foreign);
        for (int i = 0; i < foreign.size(); ++i) {
            NBTBase element = (NBTBase)foreignList.get(i);
            values.add(this.toNative(element));
        }
        Class<? extends Tag> cls = NBTConstants.getClassFromType(type);
        return new ListTag(cls, values);
    }

    private NBTBase fromNative(Tag foreign) {
        if (foreign == null) {
            return null;
        }
        if (foreign instanceof CompoundTag) {
            NBTTagCompound tag = new NBTTagCompound();
            for (Map.Entry entry : ((CompoundTag)foreign).getValue().entrySet()) {
                tag.set((String)entry.getKey(), this.fromNative((Tag)entry.getValue()));
            }
            return tag;
        }
        if (foreign instanceof ByteTag) {
            return new NBTTagByte(((ByteTag)foreign).getValue().byteValue());
        }
        if (foreign instanceof ByteArrayTag) {
            return new NBTTagByteArray(((ByteArrayTag)foreign).getValue());
        }
        if (foreign instanceof DoubleTag) {
            return new NBTTagDouble(((DoubleTag)foreign).getValue().doubleValue());
        }
        if (foreign instanceof FloatTag) {
            return new NBTTagFloat(((FloatTag)foreign).getValue().floatValue());
        }
        if (foreign instanceof IntTag) {
            return new NBTTagInt(((IntTag)foreign).getValue().intValue());
        }
        if (foreign instanceof IntArrayTag) {
            return new NBTTagIntArray(((IntArrayTag)foreign).getValue());
        }
        if (foreign instanceof ListTag) {
            NBTTagList tag = new NBTTagList();
            ListTag foreignList = (ListTag)foreign;
            Iterator i$ = foreignList.getValue().iterator();
            while (i$.hasNext()) {
                Tag t = (Tag)i$.next();
                tag.add(this.fromNative(t));
            }
            return tag;
        }
        if (foreign instanceof LongTag) {
            return new NBTTagLong(((LongTag)foreign).getValue().longValue());
        }
        if (foreign instanceof ShortTag) {
            return new NBTTagShort(((ShortTag)foreign).getValue().shortValue());
        }
        if (foreign instanceof StringTag) {
            return new NBTTagString(((StringTag)foreign).getValue());
        }
        if (foreign instanceof EndTag) {
            try {
                return (NBTBase)this.nbtCreateTagMethod.invoke(null, (byte)0);
            }
            catch (Exception e) {
                return null;
            }
        }
        throw new IllegalArgumentException("Don't know how to make NMS " + foreign.getClass().getCanonicalName());
    }
}

