/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.versions.messages;

import com.eazyftw.ezcolors.EazyAPI;
import com.eazyftw.ezcolors.versions.ReflectionUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ActionBar {
    private static final boolean sixteen = Material.getMaterial((String)"LODESTONE") != null;
    private static final boolean spigot;
    private static final MethodHandle chatComponentText;
    private static final MethodHandle packetPlayOutChat;
    private static final Object chatMessageType;

    public static void sendActionBar(@Nonnull Player player, @Nullable String message) {
        Objects.requireNonNull(player, "Cannot send action bar to null player");
        if (spigot) {
            player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
            return;
        }
        try {
            Object component = chatComponentText.invoke(message);
            Object packet = sixteen ? packetPlayOutChat.invoke(component, chatMessageType, player.getUniqueId()) : packetPlayOutChat.invoke(component, chatMessageType);
            ReflectionUtils.sendPacket(player, packet);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void sendPlayersActionBar(@Nullable String message) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            ActionBar.sendActionBar(player, message);
        }
    }

    public static void sendActionBarWhile(final @Nonnull Player player, final @Nullable String message, final @Nonnull Callable<Boolean> callable) {
        new BukkitRunnable(){

            public void run() {
                try {
                    if (!((Boolean)callable.call()).booleanValue()) {
                        this.cancel();
                        return;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                ActionBar.sendActionBar(player, message);
            }
        }.runTaskTimerAsynchronously((Plugin)EazyAPI.getPluginAPI(), 0L, 40L);
    }

    public static void sendActionBarWhile(final @Nonnull Player player, final @Nullable Callable<String> message, final @Nonnull Callable<Boolean> callable) {
        new BukkitRunnable(){

            public void run() {
                try {
                    if (!((Boolean)callable.call()).booleanValue()) {
                        this.cancel();
                        return;
                    }
                    ActionBar.sendActionBar(player, (String)message.call());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)EazyAPI.getPluginAPI(), 0L, 40L);
    }

    public static void sendActionBar(final @Nonnull Player player, final @Nullable String message, final long duration) {
        if (duration < 1L) {
            return;
        }
        new BukkitRunnable(){
            long repeater;
            {
                this.repeater = duration;
            }

            public void run() {
                ActionBar.sendActionBar(player, message);
                this.repeater -= 40L;
                if (this.repeater - 40L < -20L) {
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)EazyAPI.getPluginAPI(), 0L, 40L);
    }

    static {
        boolean exists = false;
        if (Material.getMaterial((String)"KNOWLEDGE_BOOK") != null) {
            try {
                Class.forName("org.spigotmc.SpigotConfig");
                exists = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        spigot = exists;
        MethodHandle packet = null;
        MethodHandle chatComp = null;
        Byte chatMsgType = null;
        if (!spigot) {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            Class<?> packetPlayOutChatClass = ReflectionUtils.getNMSClass("PacketPlayOutChat");
            Class<?> iChatBaseComponentClass = ReflectionUtils.getNMSClass("IChatBaseComponent");
            try {
                Class<?> chatMessageTypeClass = Class.forName(ReflectionUtils.NMS + "ChatMessageType");
                MethodType type = sixteen ? MethodType.methodType(Void.TYPE, iChatBaseComponentClass, chatMessageTypeClass, UUID.class) : MethodType.methodType(Void.TYPE, iChatBaseComponentClass, chatMessageTypeClass);
                for (Object obj : chatMessageTypeClass.getEnumConstants()) {
                    String name = obj.toString();
                    if (!name.equals("GAME_INFO") && !name.equalsIgnoreCase("ACTION_BAR")) continue;
                    chatMsgType = obj;
                    break;
                }
                Class<?> chatComponentTextClass = ReflectionUtils.getNMSClass("ChatComponentText");
                chatComp = lookup.findConstructor(chatComponentTextClass, MethodType.methodType(Void.TYPE, String.class));
                packet = lookup.findConstructor(packetPlayOutChatClass, type);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException ignored) {
                try {
                    chatMsgType = 2;
                    Class<?> chatComponentTextClass = ReflectionUtils.getNMSClass("ChatComponentText");
                    chatComp = lookup.findConstructor(chatComponentTextClass, MethodType.methodType(Void.TYPE, String.class));
                    packet = lookup.findConstructor(packetPlayOutChatClass, MethodType.methodType(Void.TYPE, iChatBaseComponentClass, Byte.TYPE));
                }
                catch (IllegalAccessException | NoSuchMethodException ex) {
                    ex.printStackTrace();
                }
            }
        }
        chatMessageType = chatMsgType;
        chatComponentText = chatComp;
        packetPlayOutChat = packet;
    }
}

