/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.versions;

import com.eazyftw.ezcolors.color.EZMessage;
import com.eazyftw.ezcolors.versions.XItemStack;
import com.eazyftw.ezcolors.versions.XMaterial;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class XItem {
    private ItemStack is;
    private List<String> lore = new ArrayList<String>();
    private List<String> originalLore = new ArrayList<String>();
    private boolean firstLore = false;

    private XItem(XMaterial material) {
        this.is = material.parseItem();
    }

    private XItem(XMaterial material, int am) {
        this.is = material.parseItem();
        this.is.setAmount(am);
    }

    private XItem(ItemStack itemStack) {
        this.is = itemStack;
    }

    @Deprecated
    private XItem(Material material) {
        this.is = new ItemStack(material);
    }

    @Deprecated
    private XItem(Material material, int am) {
        this.is = new ItemStack(material, am);
    }

    public static XItem of(XMaterial material) {
        return new XItem(material);
    }

    public static XItem of(XMaterial material, int am) {
        return new XItem(material, am);
    }

    public static XItem of(ItemStack itemStack) {
        return new XItem(itemStack);
    }

    @Deprecated
    public static XItem of(Material material) {
        return new XItem(material);
    }

    @Deprecated
    public static XItem of(Material material, int am) {
        return new XItem(material, am);
    }

    public XItem owner(UUID owner) {
        return this.owner(Bukkit.getOfflinePlayer((UUID)owner));
    }

    public XItem owner(OfflinePlayer owner) {
        if (this.is.getItemMeta() != null && this.is.getItemMeta() instanceof SkullMeta) {
            SkullMeta itemMeta = (SkullMeta)this.is.getItemMeta();
            itemMeta.setOwningPlayer(owner);
            this.is.setItemMeta((ItemMeta)itemMeta);
        }
        return this;
    }

    @Deprecated
    public XItem owner(String owner) {
        if (this.is.getItemMeta() != null && this.is.getItemMeta() instanceof SkullMeta) {
            SkullMeta itemMeta = (SkullMeta)this.is.getItemMeta();
            itemMeta.setOwner(owner);
            this.is.setItemMeta((ItemMeta)itemMeta);
        }
        return this;
    }

    @Deprecated
    public String getSkullOwner() {
        if (this.is.getItemMeta() != null && this.is.getItemMeta() instanceof SkullMeta) {
            return ((SkullMeta)this.is.getItemMeta()).getOwner();
        }
        return null;
    }

    public XItem setSkullTexture(String texture) {
        if (texture == null) {
            return this;
        }
        SkullMeta itemMeta = (SkullMeta)this.is.getItemMeta();
        GameProfile gameProfile = new GameProfile(UUID.randomUUID(), "");
        gameProfile.getProperties().put((Object)"textures", (Object)new Property("textures", Base64.getEncoder().encodeToString(String.format("{textures:{SKIN:{url:\"%s\"}}}", texture).getBytes())));
        try {
            Field declaredField = itemMeta.getClass().getDeclaredField("profile");
            declaredField.setAccessible(true);
            declaredField.set(itemMeta, gameProfile);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException ex) {
            ex.printStackTrace();
        }
        this.is.setItemMeta((ItemMeta)itemMeta);
        return this;
    }

    public XItem nameNoColor(String s) {
        if (this.is.getItemMeta() != null) {
            ItemMeta itemMeta = this.is.getItemMeta();
            itemMeta.setDisplayName(s);
            this.is.setItemMeta(itemMeta);
        }
        return this;
    }

    public XItem name(String s) {
        if (this.is.getItemMeta() != null) {
            ItemMeta itemMeta = this.is.getItemMeta();
            itemMeta.setDisplayName(EZMessage.text(s).colored());
            this.is.setItemMeta(itemMeta);
        }
        return this;
    }

    public XItem amount(int amount) {
        this.is.setAmount(amount);
        return this;
    }

    public XItem loreNoColor(List<String> list) {
        if (list == null) {
            return this;
        }
        if (this.is.getItemMeta() != null) {
            ItemMeta itemMeta = this.is.getItemMeta();
            itemMeta.setLore(list);
            this.is.setItemMeta(itemMeta);
        }
        this.lore = list;
        if (!this.firstLore) {
            this.firstLore = true;
            this.originalLore = list;
        }
        return this;
    }

    public XItem lore(List<String> list) {
        if (list == null) {
            return this;
        }
        List<String> coloredList = new ArrayList<String>();
        if (this.is.getItemMeta() != null) {
            ItemMeta itemMeta = this.is.getItemMeta();
            coloredList = list.stream().map(l -> EZMessage.text(l).colored()).collect(Collectors.toList());
            itemMeta.setLore(coloredList);
            this.is.setItemMeta(itemMeta);
        }
        this.lore = coloredList;
        if (!this.firstLore) {
            this.firstLore = true;
            this.originalLore = coloredList;
        }
        return this;
    }

    public void addLore(String ... lore) {
        List<String> currentLore = this.getLore();
        if (this.is.getItemMeta() != null) {
            ItemMeta itemMeta = this.is.getItemMeta();
            Arrays.stream(lore).map(l -> EZMessage.text(l).colored()).forEach(currentLore::add);
            itemMeta.setLore(currentLore);
            this.is.setItemMeta(itemMeta);
            this.lore = currentLore;
            if (!this.firstLore) {
                this.firstLore = true;
                this.originalLore = currentLore;
            }
        }
    }

    public XItem firstLore(String s) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(s);
        list.addAll(this.getLore());
        this.lore(list);
        return this;
    }

    public XItem lores(String ... array) {
        this.lore(new ArrayList<String>(Arrays.asList(array)));
        return this;
    }

    public XItem loreLine(String s) {
        ArrayList<String> list = new ArrayList<String>(this.getLore());
        list.add(s);
        this.lore(list);
        return this;
    }

    public XItem loreLines(ArrayList<String> list) {
        list.forEach(this::loreLine);
        return this;
    }

    public XItem loreLines(String[] array) {
        int length = array.length;
        for (int i = 0; i < length; ++i) {
            this.loreLine(array[i]);
        }
        return this;
    }

    public XItem lore(String[] array) {
        this.lore(new ArrayList<String>(Arrays.asList(array)));
        return this;
    }

    public List<String> getLore() {
        return this.lore;
    }

    public List<String> getOriginalLore() {
        return this.originalLore;
    }

    public XItem addEnchantment(Enchantment enchantment, int n) {
        this.is.addUnsafeEnchantment(enchantment, n);
        return this;
    }

    public XItem removeEnchantment(Enchantment enchantment) {
        this.is.removeEnchantment(enchantment);
        return this;
    }

    public XItem showEnchantments(boolean b) {
        if (this.is.getItemMeta() != null) {
            ItemMeta itemMeta = this.is.getItemMeta();
            if (b) {
                itemMeta.removeItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            } else {
                itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            }
            this.is.setItemMeta(itemMeta);
        }
        return this;
    }

    public XItem addItemFlag(ItemFlag itemflag) {
        if (this.is == null) {
            return this;
        }
        ItemMeta im = this.is.getItemMeta();
        if (im == null) {
            return this;
        }
        im.addItemFlags(new ItemFlag[]{itemflag});
        this.is.setItemMeta(this.is.getItemMeta());
        return this;
    }

    public XItem showAllAttributes(boolean b) {
        if (this.is.getItemMeta() != null) {
            ItemMeta itemMeta = this.is.getItemMeta();
            if (b) {
                itemMeta.removeItemFlags(ItemFlag.values());
            } else {
                itemMeta.addItemFlags(ItemFlag.values());
            }
            this.is.setItemMeta(itemMeta);
        }
        return this;
    }

    public XItem setUnbreakable(boolean unbreakable) {
        ItemMeta meta = this.is.getItemMeta();
        if (meta == null) {
            return this;
        }
        meta.setUnbreakable(unbreakable);
        this.is.setItemMeta(meta);
        return this;
    }

    public void serialize(ConfigurationSection config) {
        XItemStack.serialize(this.is, config);
    }

    public XItem deserialize(ConfigurationSection config) {
        return new XItem(XItemStack.deserialize(config));
    }

    public ItemStack build() {
        return this.is;
    }
}

