/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.utils;

import com.eazyftw.ezcolors.utils.EazyUtils;
import com.eazyftw.ezcolors.versions.MinecraftVersion;
import java.awt.Color;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;

public class Colors {
    public static String getColored(String msg, boolean forceClosestHex) {
        if (msg == null) {
            return "";
        }
        if (Pattern.compile("\\{#[0-9A-Fa-f]{6}}").matcher(msg).find()) {
            Matcher m = Pattern.compile("\\{#[0-9A-Fa-f]{6}}").matcher(msg);
            if (!forceClosestHex && MinecraftVersion.getServersVersion().isAboveOrEqual(MinecraftVersion.V1_16_R1)) {
                while (m.find()) {
                    String s = m.group();
                    String sNew = "\u00a7x" + Arrays.stream(s.split("")).map(s2 -> "\u00a7" + s2).collect(Collectors.joining()).replace("\u00a7#", "");
                    msg = msg.replace(s, sNew.replace("\u00a7{", "").replace("\u00a7}", ""));
                }
            } else {
                while (m.find()) {
                    String s = m.group();
                    String sNew = "\u00a7" + DefaultColor.getClosestFromHex(s.replace("{", "").replace("}", ""));
                    msg = msg.replace(s, sNew.replace("\u00a7{", "").replace("\u00a7}", ""));
                }
            }
            return ChatColor.translateAlternateColorCodes((char)'&', (String)msg.replace("%prefix%", EazyUtils.getPrefix()));
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)msg.replace("%prefix%", EazyUtils.getPrefix()));
    }

    public static String getColored(String msg) {
        return Colors.getColored(msg, false);
    }

    public static enum DefaultColor {
        DARK_RED("dark_red", "4", "#AA0000"),
        RED("red", "c", "#FF5555"),
        GOLD("gold", "6", "#FFAA00"),
        YELLOW("yellow", "e", "#FFFF55"),
        DARK_GREEN("dark_green", "2", "#00AA00"),
        GREEN("green", "a", "#55FF55"),
        AQUA("aqua", "b", "#55FFFF"),
        DARK_AQUA("dark_aqua", "3", "#00AAAA"),
        DARK_BLUE("dark_blue", "1", "#0000AA"),
        BLUE("blue", "9", "#5555FF"),
        LIGHT_PURPLE("light_purple", "d", "#FF55FF"),
        DARK_PURPLE("dark_purple", "5", "#AA00AA"),
        WHITE("white", "f", "#FFFFFF"),
        GRAY("gray", "7", "#AAAAAA"),
        DARK_GRAY("dark_gray", "8", "#555555"),
        BLACK("black", "0", "#000000");

        private final String name;
        private final String code;
        private final String hex;
        private final int r;
        private final int g;
        private final int b;

        private DefaultColor(String name, String code, String hex) {
            this.name = name;
            this.code = code;
            this.hex = hex;
            Color color = DefaultColor.hex2Rgb(hex);
            this.r = color.getRed();
            this.g = color.getGreen();
            this.b = color.getBlue();
        }

        public String getName() {
            return this.name;
        }

        public String getHex() {
            return this.hex;
        }

        public String getCode() {
            return this.code;
        }

        public int getRed() {
            return this.r;
        }

        public int getGreen() {
            return this.g;
        }

        public int getBlue() {
            return this.b;
        }

        public Color getColor() {
            return new Color(this.r, this.g, this.b);
        }

        public static String getClosestFromHex(String hex) {
            Color color2 = DefaultColor.hex2Rgb(hex);
            int closestInt = -1;
            DefaultColor closestColor = null;
            for (DefaultColor color1 : DefaultColor.values()) {
                int result = DefaultColor.distance(color1, color2);
                if (closestInt <= result && closestInt != -1) continue;
                closestInt = result;
                closestColor = color1;
            }
            if (closestColor == null) {
                return "f";
            }
            return closestColor.getCode();
        }

        private static int distance(DefaultColor color1, Color color2) {
            return Math.abs(color1.r - color2.getRed()) + Math.abs(color1.g - color2.getGreen()) + Math.abs(color1.b - color2.getBlue());
        }

        public static Color hex2Rgb(String colorStr) {
            return new Color(Integer.valueOf(colorStr.substring(1, 3), 16), Integer.valueOf(colorStr.substring(3, 5), 16), Integer.valueOf(colorStr.substring(5, 7), 16));
        }
    }
}

