/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.types.color;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum Rainbow {
    DARK_RED("Dark Red", "4"),
    RED("Red", "c"),
    GOLD("Gold", "6"),
    YELLOW("Yellow", "e"),
    GREEN("Green", "2"),
    LIME("Lime", "a"),
    AQUA("Aqua", "b"),
    CYAN("Cyan", "3"),
    BLUE("Blue", "9"),
    PINK("Pink", "d");

    private final String name;
    private final String colorCode;

    private Rainbow(String name, String colorCode) {
        this.name = name;
        this.colorCode = colorCode;
    }

    public String getName() {
        return this.name;
    }

    public String getColorCode() {
        return this.colorCode;
    }

    public String getColorCodeWithAnd() {
        return "&" + this.colorCode;
    }

    public static List<String> all() {
        return Arrays.stream(Rainbow.values()).map(Rainbow::getColorCodeWithAnd).collect(Collectors.toList());
    }
}

