/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.scoreboard;

import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.Optional;
import java.util.function.Predicate;
import org.bukkit.Bukkit;

public final class FastReflection {
    private static final String NM_PACKAGE = "net.minecraft";
    public static final String OBC_PACKAGE = "org.bukkit.craftbukkit";
    public static final String NMS_PACKAGE = "net.minecraft.server";
    public static final String VERSION = Bukkit.getServer().getClass().getPackage().getName().substring("org.bukkit.craftbukkit".length() + 1);
    private static final MethodType VOID_METHOD_TYPE = MethodType.methodType(Void.TYPE);
    private static final boolean NMS_REPACKAGED = FastReflection.optionalClass("net.minecraft.network.protocol.Packet").isPresent();
    private static volatile Object theUnsafe;

    private FastReflection() {
        throw new UnsupportedOperationException();
    }

    public static boolean isRepackaged() {
        return NMS_REPACKAGED;
    }

    public static String nmsClassName(String post1_17package, String className) {
        if (NMS_REPACKAGED) {
            String classPackage = post1_17package == null ? NM_PACKAGE : "net.minecraft." + post1_17package;
            return classPackage + '.' + className;
        }
        return "net.minecraft.server." + VERSION + '.' + className;
    }

    public static Class<?> nmsClass(String post1_17package, String className) throws ClassNotFoundException {
        return Class.forName(FastReflection.nmsClassName(post1_17package, className));
    }

    public static Optional<Class<?>> nmsOptionalClass(String post1_17package, String className) {
        return FastReflection.optionalClass(FastReflection.nmsClassName(post1_17package, className));
    }

    public static String obcClassName(String className) {
        return "org.bukkit.craftbukkit." + VERSION + '.' + className;
    }

    public static Class<?> obcClass(String className) throws ClassNotFoundException {
        return Class.forName(FastReflection.obcClassName(className));
    }

    public static Optional<Class<?>> obcOptionalClass(String className) {
        return FastReflection.optionalClass(FastReflection.obcClassName(className));
    }

    public static Optional<Class<?>> optionalClass(String className) {
        try {
            return Optional.of(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }

    public static Object enumValueOf(Class<?> enumClass, String enumName) {
        return Enum.valueOf(enumClass.asSubclass(Enum.class), enumName);
    }

    public static Object enumValueOf(Class<?> enumClass, String enumName, int fallbackOrdinal) {
        try {
            return FastReflection.enumValueOf(enumClass, enumName);
        }
        catch (IllegalArgumentException e) {
            ?[] constants = enumClass.getEnumConstants();
            if (constants.length > fallbackOrdinal) {
                return constants[fallbackOrdinal];
            }
            throw e;
        }
    }

    static Class<?> innerClass(Class<?> parentClass, Predicate<Class<?>> classPredicate) throws ClassNotFoundException {
        for (Class<?> innerClass : parentClass.getDeclaredClasses()) {
            if (!classPredicate.test(innerClass)) continue;
            return innerClass;
        }
        throw new ClassNotFoundException("No class in " + parentClass.getCanonicalName() + " matches the predicate.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static PacketConstructor findPacketConstructor(Class<?> packetClass, MethodHandles.Lookup lookup) throws Exception {
        try {
            MethodHandle constructor2 = lookup.findConstructor(packetClass, VOID_METHOD_TYPE);
            return (PacketConstructor)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invoke(), ()Ljava/lang/Object;)((MethodHandle)constructor2);
        }
        catch (IllegalAccessException | NoSuchMethodException constructor2) {
            if (theUnsafe == null) {
                Class<FastReflection> constructor2 = FastReflection.class;
                // MONITORENTER : com.eazyftw.ezcolors.scoreboard.FastReflection.class
                if (theUnsafe == null) {
                    Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
                    Field theUnsafeField = unsafeClass.getDeclaredField("theUnsafe");
                    theUnsafeField.setAccessible(true);
                    theUnsafe = theUnsafeField.get(null);
                }
                // MONITOREXIT : constructor2
            }
            MethodType allocateMethodType = MethodType.methodType(Object.class, Class.class);
            MethodHandle allocateMethod = lookup.findVirtual(theUnsafe.getClass(), "allocateInstance", allocateMethodType);
            return () -> allocateMethod.invoke(theUnsafe, packetClass);
        }
    }

    @FunctionalInterface
    static interface PacketConstructor {
        public Object invoke() throws Throwable;
    }
}

