/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.scoreboard;

import com.eazyftw.ezcolors.scoreboard.FastReflection;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class FastBoard {
    private static final Map<Class<?>, Field[]> PACKETS = new HashMap(8);
    private static final String[] COLOR_CODES = (String[])Arrays.stream(ChatColor.values()).map(Object::toString).toArray(String[]::new);
    private static final VersionType VERSION_TYPE;
    private static final Class<?> CHAT_COMPONENT_CLASS;
    private static final Class<?> CHAT_FORMAT_ENUM;
    private static final Object EMPTY_MESSAGE;
    private static final Object RESET_FORMATTING;
    private static final MethodHandle MESSAGE_FROM_STRING;
    private static final MethodHandle PLAYER_CONNECTION;
    private static final MethodHandle SEND_PACKET;
    private static final MethodHandle PLAYER_GET_HANDLE;
    private static final FastReflection.PacketConstructor PACKET_SB_OBJ;
    private static final FastReflection.PacketConstructor PACKET_SB_DISPLAY_OBJ;
    private static final FastReflection.PacketConstructor PACKET_SB_SCORE;
    private static final FastReflection.PacketConstructor PACKET_SB_TEAM;
    private static final FastReflection.PacketConstructor PACKET_SB_SERIALIZABLE_TEAM;
    private static final Class<?> ENUM_SB_HEALTH_DISPLAY;
    private static final Class<?> ENUM_SB_ACTION;
    private static final Object ENUM_SB_HEALTH_DISPLAY_INTEGER;
    private static final Object ENUM_SB_ACTION_CHANGE;
    private static final Object ENUM_SB_ACTION_REMOVE;
    private final Player player;
    private final String id;
    private final List<String> lines = new ArrayList<String>();
    private String title = ChatColor.RESET.toString();
    private boolean deleted = false;

    public FastBoard(Player player) {
        this.player = Objects.requireNonNull(player, "player");
        this.id = "fb-" + Integer.toHexString(ThreadLocalRandom.current().nextInt());
        try {
            this.sendObjectivePacket(ObjectiveMode.CREATE);
            this.sendDisplayObjectivePacket();
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to create scoreboard", t);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void updateTitle(String title) {
        if (this.title.equals(Objects.requireNonNull(title, "title"))) {
            return;
        }
        if (!VersionType.V1_13.isHigherOrEqual() && title.length() > 32) {
            throw new IllegalArgumentException("Title is longer than 32 chars");
        }
        this.title = title;
        try {
            this.sendObjectivePacket(ObjectiveMode.UPDATE);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to update scoreboard title", t);
        }
    }

    public List<String> getLines() {
        return new ArrayList<String>(this.lines);
    }

    public String getLine(int line) {
        this.checkLineNumber(line, true, false);
        return this.lines.get(line);
    }

    public synchronized void updateLine(int line, String text) {
        this.checkLineNumber(line, false, true);
        try {
            if (line < this.size()) {
                this.lines.set(line, text);
                this.sendTeamPacket(this.getScoreByLine(line), TeamMode.UPDATE);
                return;
            }
            ArrayList<String> newLines = new ArrayList<String>(this.lines);
            if (line > this.size()) {
                for (int i = this.size(); i < line; ++i) {
                    newLines.add("");
                }
            }
            newLines.add(text);
            this.updateLines(newLines);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to update scoreboard lines", t);
        }
    }

    public synchronized void removeLine(int line) {
        this.checkLineNumber(line, false, false);
        if (line >= this.size()) {
            return;
        }
        ArrayList<String> newLines = new ArrayList<String>(this.lines);
        newLines.remove(line);
        this.updateLines(newLines);
    }

    public void updateLines(String ... lines) {
        this.updateLines(Arrays.asList(lines));
    }

    public synchronized void updateLines(Collection<String> lines) {
        Objects.requireNonNull(lines, "lines");
        this.checkLineNumber(lines.size(), false, true);
        if (!VersionType.V1_13.isHigherOrEqual()) {
            int lineCount = 0;
            for (String s : lines) {
                if (s != null && s.length() > 30) {
                    throw new IllegalArgumentException("Line " + lineCount + " is longer than 30 chars");
                }
                ++lineCount;
            }
        }
        ArrayList<String> oldLines = new ArrayList<String>(this.lines);
        this.lines.clear();
        this.lines.addAll(lines);
        int linesSize = this.lines.size();
        try {
            if (oldLines.size() != linesSize) {
                int i;
                ArrayList<String> oldLinesCopy = new ArrayList<String>(oldLines);
                if (oldLines.size() > linesSize) {
                    for (i = oldLinesCopy.size(); i > linesSize; --i) {
                        this.sendTeamPacket(i - 1, TeamMode.REMOVE);
                        this.sendScorePacket(i - 1, ScoreboardAction.REMOVE);
                        oldLines.remove(0);
                    }
                } else {
                    for (i = oldLinesCopy.size(); i < linesSize; ++i) {
                        this.sendScorePacket(i, ScoreboardAction.CHANGE);
                        this.sendTeamPacket(i, TeamMode.CREATE);
                        oldLines.add(oldLines.size() - i, this.getLineByScore(i));
                    }
                }
            }
            for (int i = 0; i < linesSize; ++i) {
                if (Objects.equals(this.getLineByScore(oldLines, i), this.getLineByScore(i))) continue;
                this.sendTeamPacket(i, TeamMode.UPDATE);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to update scoreboard lines", t);
        }
    }

    public Player getPlayer() {
        return this.player;
    }

    public String getId() {
        return this.id;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public int size() {
        return this.lines.size();
    }

    public void delete() {
        try {
            for (int i = 0; i < this.lines.size(); ++i) {
                this.sendTeamPacket(i, TeamMode.REMOVE);
            }
            this.sendObjectivePacket(ObjectiveMode.REMOVE);
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to delete scoreboard", t);
        }
        this.deleted = true;
    }

    protected boolean hasLinesMaxLength() {
        return !VersionType.V1_13.isHigherOrEqual();
    }

    private void checkLineNumber(int line, boolean checkInRange, boolean checkMax) {
        if (line < 0) {
            throw new IllegalArgumentException("Line number must be positive");
        }
        if (checkInRange && line >= this.lines.size()) {
            throw new IllegalArgumentException("Line number must be under " + this.lines.size());
        }
        if (checkMax && line >= COLOR_CODES.length - 1) {
            throw new IllegalArgumentException("Line number is too high: " + line);
        }
    }

    private int getScoreByLine(int line) {
        return this.lines.size() - line - 1;
    }

    private String getLineByScore(int score) {
        return this.getLineByScore(this.lines, score);
    }

    private String getLineByScore(List<String> lines, int score) {
        return lines.get(lines.size() - score - 1);
    }

    private void sendObjectivePacket(ObjectiveMode mode) throws Throwable {
        Object packet = PACKET_SB_OBJ.invoke();
        this.setField(packet, String.class, this.id);
        this.setField(packet, Integer.TYPE, mode.ordinal());
        if (mode != ObjectiveMode.REMOVE) {
            this.setComponentField(packet, this.title, 1);
            if (VersionType.V1_8.isHigherOrEqual()) {
                this.setField(packet, ENUM_SB_HEALTH_DISPLAY, ENUM_SB_HEALTH_DISPLAY_INTEGER);
            }
        } else if (VERSION_TYPE == VersionType.V1_7) {
            this.setField(packet, String.class, "", 1);
        }
        this.sendPacket(packet);
    }

    private void sendDisplayObjectivePacket() throws Throwable {
        Object packet = PACKET_SB_DISPLAY_OBJ.invoke();
        this.setField(packet, Integer.TYPE, 1);
        this.setField(packet, String.class, this.id);
        this.sendPacket(packet);
    }

    private void sendScorePacket(int score, ScoreboardAction action) throws Throwable {
        Object packet = PACKET_SB_SCORE.invoke();
        this.setField(packet, String.class, COLOR_CODES[score], 0);
        if (VersionType.V1_8.isHigherOrEqual()) {
            this.setField(packet, ENUM_SB_ACTION, action == ScoreboardAction.REMOVE ? ENUM_SB_ACTION_REMOVE : ENUM_SB_ACTION_CHANGE);
        } else {
            this.setField(packet, Integer.TYPE, action.ordinal(), 1);
        }
        if (action == ScoreboardAction.CHANGE) {
            this.setField(packet, String.class, this.id, 1);
            this.setField(packet, Integer.TYPE, score);
        }
        this.sendPacket(packet);
    }

    private void sendTeamPacket(int score, TeamMode mode) throws Throwable {
        if (mode == TeamMode.ADD_PLAYERS || mode == TeamMode.REMOVE_PLAYERS) {
            throw new UnsupportedOperationException();
        }
        int maxLength = this.hasLinesMaxLength() ? 16 : 1024;
        Object packet = PACKET_SB_TEAM.invoke();
        this.setField(packet, String.class, this.id + ':' + score);
        this.setField(packet, Integer.TYPE, mode.ordinal(), VERSION_TYPE == VersionType.V1_8 ? 1 : 0);
        if (mode == TeamMode.CREATE || mode == TeamMode.UPDATE) {
            String prefix;
            String line = this.getLineByScore(score);
            String suffix = null;
            if (line == null || line.isEmpty()) {
                prefix = COLOR_CODES[score] + ChatColor.RESET;
            } else if (line.length() <= maxLength) {
                prefix = line;
            } else {
                int index = line.charAt(maxLength - 1) == '\u00a7' ? maxLength - 1 : maxLength;
                prefix = line.substring(0, index);
                String suffixTmp = line.substring(index);
                ChatColor chatColor = null;
                if (suffixTmp.length() >= 2 && suffixTmp.charAt(0) == '\u00a7') {
                    chatColor = ChatColor.getByChar((char)suffixTmp.charAt(1));
                }
                String color = ChatColor.getLastColors((String)prefix);
                boolean addColor = chatColor == null || chatColor.isFormat();
                suffix = (addColor ? (color.isEmpty() ? ChatColor.RESET.toString() : color) : "") + suffixTmp;
            }
            if (prefix.length() > maxLength || suffix != null && suffix.length() > maxLength) {
                prefix = prefix.substring(0, maxLength);
                String string = suffix = suffix != null ? suffix.substring(0, maxLength) : null;
            }
            if (VersionType.V1_17.isHigherOrEqual()) {
                Object team = PACKET_SB_SERIALIZABLE_TEAM.invoke();
                this.setComponentField(team, "", 0);
                this.setField(team, CHAT_FORMAT_ENUM, RESET_FORMATTING);
                this.setComponentField(team, prefix, 1);
                this.setComponentField(team, suffix == null ? "" : suffix, 2);
                this.setField(team, String.class, "always", 0);
                this.setField(team, String.class, "always", 1);
                this.setField(packet, Optional.class, Optional.of(team));
            } else {
                this.setComponentField(packet, prefix, 2);
                this.setComponentField(packet, suffix == null ? "" : suffix, 3);
                this.setField(packet, String.class, "always", 4);
                this.setField(packet, String.class, "always", 5);
            }
            if (mode == TeamMode.CREATE) {
                this.setField(packet, Collection.class, Collections.singletonList(COLOR_CODES[score]));
            }
        }
        this.sendPacket(packet);
    }

    private void sendPacket(Object packet) throws Throwable {
        if (this.deleted) {
            throw new IllegalStateException("This FastBoard is deleted");
        }
        if (this.player.isOnline()) {
            Object entityPlayer = PLAYER_GET_HANDLE.invoke(this.player);
            Object playerConnection = PLAYER_CONNECTION.invoke(entityPlayer);
            SEND_PACKET.invoke(playerConnection, packet);
        }
    }

    private void setField(Object object, Class<?> fieldType, Object value) throws ReflectiveOperationException {
        this.setField(object, fieldType, value, 0);
    }

    private void setField(Object packet, Class<?> fieldType, Object value, int count) throws ReflectiveOperationException {
        int i = 0;
        for (Field field : PACKETS.get(packet.getClass())) {
            if (field.getType() != fieldType || count != i++) continue;
            field.set(packet, value);
        }
    }

    private void setComponentField(Object packet, String value, int count) throws Throwable {
        if (!VersionType.V1_13.isHigherOrEqual()) {
            this.setField(packet, String.class, value, count);
            return;
        }
        int i = 0;
        for (Field field : PACKETS.get(packet.getClass())) {
            if (field.getType() != String.class && field.getType() != CHAT_COMPONENT_CLASS || count != i++) continue;
            field.set(packet, value.isEmpty() ? EMPTY_MESSAGE : Array.get(MESSAGE_FROM_STRING.invoke(value), 0));
        }
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            VERSION_TYPE = FastReflection.isRepackaged() ? VersionType.V1_17 : (FastReflection.nmsOptionalClass(null, "ScoreboardServer$Action").isPresent() ? VersionType.V1_13 : (FastReflection.nmsOptionalClass(null, "IScoreboardCriteria$EnumScoreboardHealthDisplay").isPresent() ? VersionType.V1_8 : VersionType.V1_7));
            String gameProtocolPackage = "network.protocol.game";
            Class<?> craftPlayerClass = FastReflection.obcClass("entity.CraftPlayer");
            Class<?> craftChatMessageClass = FastReflection.obcClass("util.CraftChatMessage");
            Class<?> entityPlayerClass = FastReflection.nmsClass("server.level", "EntityPlayer");
            Class<?> playerConnectionClass = FastReflection.nmsClass("server.network", "PlayerConnection");
            Class<?> packetClass = FastReflection.nmsClass("network.protocol", "Packet");
            Class<?> packetSbObjClass = FastReflection.nmsClass(gameProtocolPackage, "PacketPlayOutScoreboardObjective");
            Class<?> packetSbDisplayObjClass = FastReflection.nmsClass(gameProtocolPackage, "PacketPlayOutScoreboardDisplayObjective");
            Class<?> packetSbScoreClass = FastReflection.nmsClass(gameProtocolPackage, "PacketPlayOutScoreboardScore");
            Class<?> packetSbTeamClass = FastReflection.nmsClass(gameProtocolPackage, "PacketPlayOutScoreboardTeam");
            Class<?> sbTeamClass = VersionType.V1_17.isHigherOrEqual() ? FastReflection.innerClass(packetSbTeamClass, innerClass -> !innerClass.isEnum()) : null;
            Field playerConnectionField = Arrays.stream(entityPlayerClass.getFields()).filter(field -> field.getType().isAssignableFrom(playerConnectionClass)).findFirst().orElseThrow(NoSuchFieldException::new);
            Method sendPacketMethod = Arrays.stream(playerConnectionClass.getMethods()).filter(m -> m.getParameterCount() == 1 && m.getParameterTypes()[0] == packetClass).findFirst().orElseThrow(NoSuchMethodException::new);
            MESSAGE_FROM_STRING = lookup.unreflect(craftChatMessageClass.getMethod("fromString", String.class));
            CHAT_COMPONENT_CLASS = FastReflection.nmsClass("network.chat", "IChatBaseComponent");
            CHAT_FORMAT_ENUM = FastReflection.nmsClass(null, "EnumChatFormat");
            EMPTY_MESSAGE = Array.get(MESSAGE_FROM_STRING.invoke(""), 0);
            RESET_FORMATTING = FastReflection.enumValueOf(CHAT_FORMAT_ENUM, "RESET", 21);
            PLAYER_GET_HANDLE = lookup.findVirtual(craftPlayerClass, "getHandle", MethodType.methodType(entityPlayerClass));
            PLAYER_CONNECTION = lookup.unreflectGetter(playerConnectionField);
            SEND_PACKET = lookup.unreflect(sendPacketMethod);
            PACKET_SB_OBJ = FastReflection.findPacketConstructor(packetSbObjClass, lookup);
            PACKET_SB_DISPLAY_OBJ = FastReflection.findPacketConstructor(packetSbDisplayObjClass, lookup);
            PACKET_SB_SCORE = FastReflection.findPacketConstructor(packetSbScoreClass, lookup);
            PACKET_SB_TEAM = FastReflection.findPacketConstructor(packetSbTeamClass, lookup);
            PACKET_SB_SERIALIZABLE_TEAM = sbTeamClass == null ? null : FastReflection.findPacketConstructor(sbTeamClass, lookup);
            for (Class clazz : Arrays.asList(packetSbObjClass, packetSbDisplayObjClass, packetSbScoreClass, packetSbTeamClass, sbTeamClass)) {
                Field[] fields;
                if (clazz == null) continue;
                for (Field field2 : fields = (Field[])Arrays.stream(clazz.getDeclaredFields()).filter(field -> !Modifier.isStatic(field.getModifiers())).toArray(Field[]::new)) {
                    field2.setAccessible(true);
                }
                PACKETS.put(clazz, fields);
            }
            if (VersionType.V1_8.isHigherOrEqual()) {
                String enumSbActionClass = VersionType.V1_13.isHigherOrEqual() ? "ScoreboardServer$Action" : "PacketPlayOutScoreboardScore$EnumScoreboardAction";
                ENUM_SB_HEALTH_DISPLAY = FastReflection.nmsClass("world.scores.criteria", "IScoreboardCriteria$EnumScoreboardHealthDisplay");
                ENUM_SB_ACTION = FastReflection.nmsClass("server", enumSbActionClass);
                ENUM_SB_HEALTH_DISPLAY_INTEGER = FastReflection.enumValueOf(ENUM_SB_HEALTH_DISPLAY, "INTEGER", 0);
                ENUM_SB_ACTION_CHANGE = FastReflection.enumValueOf(ENUM_SB_ACTION, "CHANGE", 0);
                ENUM_SB_ACTION_REMOVE = FastReflection.enumValueOf(ENUM_SB_ACTION, "REMOVE", 1);
            } else {
                ENUM_SB_HEALTH_DISPLAY = null;
                ENUM_SB_ACTION = null;
                ENUM_SB_HEALTH_DISPLAY_INTEGER = null;
                ENUM_SB_ACTION_CHANGE = null;
                ENUM_SB_ACTION_REMOVE = null;
            }
        }
        catch (Throwable t) {
            throw new ExceptionInInitializerError(t);
        }
    }

    static enum VersionType {
        V1_7,
        V1_8,
        V1_13,
        V1_17;


        public boolean isHigherOrEqual() {
            return VERSION_TYPE.ordinal() >= this.ordinal();
        }
    }

    static enum ScoreboardAction {
        CHANGE,
        REMOVE;

    }

    static enum TeamMode {
        CREATE,
        REMOVE,
        UPDATE,
        ADD_PLAYERS,
        REMOVE_PLAYERS;

    }

    static enum ObjectiveMode {
        CREATE,
        REMOVE,
        UPDATE;

    }
}

