/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.regeneration.worldedit;

import com.eazyftw.ezcolors.regeneration.worldedit.NoSchematicException;
import com.google.common.base.Preconditions;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.EmptyClipboardException;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.entity.Player;

public abstract class SchematicProcessor {
    private static final int PROTOCOL;
    private static final SchematicProcessor FACTORY;
    public static final AtomicReference<String> ADAPTER_NAME;
    protected File schematic;
    protected WorldEditPlugin plugin;

    protected SchematicProcessor() {
    }

    protected SchematicProcessor(WorldEditPlugin plugin, String schematicName, File directory) {
        Preconditions.checkNotNull((Object)plugin, (Object)"WorldEditPlugin cannot be null");
        Preconditions.checkNotNull((Object)schematicName, (Object)"schematicName cannot be null");
        Preconditions.checkNotNull((Object)directory, (Object)"directory cannot be null");
        this.plugin = plugin;
        this.schematic = new File(directory, schematicName + ".schem");
        try {
            this.schematic.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public abstract void write(Player var1) throws EmptyClipboardException;

    public abstract EditSession paste(Location var1) throws NoSchematicException;

    protected abstract SchematicProcessor newInstance(WorldEditPlugin var1, String var2, File var3);

    public static SchematicProcessor newSchematicProcessor(WorldEditPlugin plugin, String name, File directory) {
        return FACTORY.newInstance(plugin, name, directory);
    }

    public static String getBaseName(File file) {
        Preconditions.checkNotNull((Object)file);
        String fileName = file.getName();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
    }

    private static String getVersion(Server server) {
        String packageName = server.getClass().getPackage().getName();
        return packageName.substring(packageName.lastIndexOf(46) + 1);
    }

    static {
        SchematicProcessor factory;
        block8: {
            PROTOCOL = Integer.parseInt(SchematicProcessor.getVersion(Bukkit.getServer()).split("_")[1]);
            ADAPTER_NAME = new AtomicReference();
            if (PROTOCOL >= 13) {
                try {
                    if (Bukkit.getPluginManager().getPlugin("FastAsyncWorldEdit") != null) {
                        factory = (SchematicProcessor)Class.forName("com.eazyftw.ezcolors.regeneration.modern.FAWESchematicProcessor").newInstance();
                        break block8;
                    }
                    factory = (SchematicProcessor)Class.forName("com.eazyftw.ezcolors.regeneration.modern.WESchematicProcessor").newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                    factory = null;
                }
            } else {
                try {
                    factory = (SchematicProcessor)Class.forName("com.eazyftw.ezcolors.regeneration.legacy.WESchematicProcessor").newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                    factory = null;
                }
            }
        }
        FACTORY = factory;
        if (FACTORY != null) {
            ADAPTER_NAME.set(FACTORY.getClass().getSimpleName());
        }
    }
}

