/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.regeneration.legacy;

import com.eazyftw.ezcolors.regeneration.worldedit.NoSchematicException;
import com.eazyftw.ezcolors.regeneration.worldedit.SchematicProcessor;
import com.sk89q.worldedit.CuboidClipboard;
import com.sk89q.worldedit.EditSession;
import com.sk89q.worldedit.EmptyClipboardException;
import com.sk89q.worldedit.LocalSession;
import com.sk89q.worldedit.MaxChangedBlocksException;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.bukkit.BukkitUtil;
import com.sk89q.worldedit.bukkit.BukkitWorld;
import com.sk89q.worldedit.bukkit.WorldEditPlugin;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardWriter;
import com.sk89q.worldedit.schematic.SchematicFormat;
import com.sk89q.worldedit.session.ClipboardHolder;
import com.sk89q.worldedit.session.SessionOwner;
import com.sk89q.worldedit.util.io.Closer;
import com.sk89q.worldedit.world.DataException;
import com.sk89q.worldedit.world.World;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class WESchematicProcessor
extends SchematicProcessor {
    public WESchematicProcessor() {
    }

    private WESchematicProcessor(WorldEditPlugin plugin, String name, File directory) {
        super(plugin, name, directory);
    }

    @Override
    public void write(Player player) throws EmptyClipboardException {
        try (Closer closer = Closer.create();){
            BukkitPlayer localPlayer = this.plugin.wrapPlayer(player);
            LocalSession localSession = this.plugin.getWorldEdit().getSessionManager().get((SessionOwner)localPlayer);
            ClipboardHolder selection = localSession.getClipboard();
            FileOutputStream fos = (FileOutputStream)closer.register((Closeable)new FileOutputStream(this.schematic));
            BufferedOutputStream bos = (BufferedOutputStream)closer.register((Closeable)new BufferedOutputStream(fos));
            ClipboardWriter writer = (ClipboardWriter)closer.register((Closeable)ClipboardFormat.SCHEMATIC.getWriter((OutputStream)bos));
            writer.write(selection.getClipboard(), selection.getWorldData());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public EditSession paste(Location location) throws NoSchematicException {
        EditSession editSession = null;
        try {
            editSession = WorldEdit.getInstance().getEditSessionFactory().getEditSession((World)new BukkitWorld(location.getWorld()), -1);
            editSession.enableQueue();
            SchematicFormat schematic = SchematicFormat.getFormat((File)this.schematic);
            CuboidClipboard cuboidClipboard = schematic.load(this.schematic);
            cuboidClipboard.paste(editSession, BukkitUtil.toVector((Location)location), false);
            editSession.flushQueue();
        }
        catch (MaxChangedBlocksException | DataException | IOException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            throw new NoSchematicException(SchematicProcessor.getBaseName(this.schematic));
        }
        return editSession;
    }

    @Override
    public SchematicProcessor newInstance(WorldEditPlugin plugin, String name, File directory) {
        return new WESchematicProcessor(plugin, name, directory);
    }
}

