/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.npc.listeners;

import com.comphenix.tinyprotocol.Reflection;
import com.comphenix.tinyprotocol.TinyProtocol;
import com.eazyftw.ezcolors.npc.NPCLib;
import com.eazyftw.ezcolors.npc.api.events.NPCInteractEvent;
import com.eazyftw.ezcolors.npc.internal.NPCBase;
import com.eazyftw.ezcolors.npc.internal.NPCManager;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class PacketListener {
    private final Class<?> packetPlayInUseEntityClazz = Reflection.getMinecraftClass("PacketPlayInUseEntity");
    private final Reflection.FieldAccessor<Integer> entityIdField = Reflection.getField(this.packetPlayInUseEntityClazz, "a", Integer.TYPE);
    private final Reflection.FieldAccessor<?> actionField = Reflection.getField(this.packetPlayInUseEntityClazz, "action", Object.class);
    private final Set<UUID> delay = new HashSet<UUID>();
    private Plugin plugin;

    public void start(NPCLib instance) {
        this.plugin = instance.getPlugin();
        new TinyProtocol(instance){

            @Override
            public Object onPacketInAsync(Player player, Object packet) {
                return PacketListener.this.handleInteractPacket(player, packet) ? super.onPacketInAsync(player, packet) : null;
            }
        };
    }

    private boolean handleInteractPacket(Player player, Object packet) {
        if (!this.packetPlayInUseEntityClazz.isInstance(packet) || player == null) {
            return true;
        }
        NPCBase npc = null;
        int packetEntityId = this.entityIdField.get(packet);
        for (NPCBase testNPC : NPCManager.getAllNPCs()) {
            if (!testNPC.isCreated() || !testNPC.isShown(player) || testNPC.getEntityId() != packetEntityId) continue;
            npc = testNPC;
            break;
        }
        if (npc == null) {
            return true;
        }
        if (this.delay.contains(player.getUniqueId())) {
            return false;
        }
        NPCInteractEvent.ClickType clickType = this.actionField.get(packet).toString().equals("ATTACK") ? NPCInteractEvent.ClickType.LEFT_CLICK : NPCInteractEvent.ClickType.RIGHT_CLICK;
        this.delay.add(player.getUniqueId());
        Bukkit.getScheduler().runTask(this.plugin, (Runnable)new TaskCallNpcInteractEvent(new NPCInteractEvent(player, clickType, npc), this));
        return false;
    }

    private static final class TaskCallNpcInteractEvent
    implements Runnable {
        private NPCInteractEvent eventToCall;
        private PacketListener listener;
        private static Location playerLocation = new Location(null, 0.0, 0.0, 0.0);

        TaskCallNpcInteractEvent(NPCInteractEvent eventToCall, PacketListener listener) {
            this.eventToCall = eventToCall;
            this.listener = listener;
        }

        @Override
        public void run() {
            Player player = this.eventToCall.getWhoClicked();
            this.listener.delay.remove(player.getUniqueId());
            if (!player.getWorld().equals(this.eventToCall.getNPC().getWorld())) {
                return;
            }
            double distance = player.getLocation(playerLocation).distanceSquared(this.eventToCall.getNPC().getLocation());
            if (distance <= 64.0) {
                Bukkit.getPluginManager().callEvent((Event)this.eventToCall);
            }
        }
    }
}

