/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.mysql;

import com.eazyftw.ezcolors.EZColors;
import com.eazyftw.ezcolors.color.EZMessage;
import com.eazyftw.ezcolors.mysql.MySQLSettings;
import com.eazyftw.ezcolors.storage.ChatColorUser;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class MySQL {
    private MySQLSettings mySQLSettings;
    private Connection connection;
    private String url;
    private boolean connected;
    private boolean cache;
    private HashMap<UUID, ChatColorUser> cacheMap;

    public MySQL(MySQLSettings mySQLSettings, boolean cache) {
        this.mySQLSettings = mySQLSettings;
        this.cache = cache;
        if (cache) {
            this.cacheMap = this.getAllUsers();
        }
        this.url = "jdbc:mysql://" + mySQLSettings.getHost() + ":" + mySQLSettings.getPort() + "/" + mySQLSettings.getDatabase();
        this.connected = this.connect(true);
    }

    public MySQL(JavaPlugin plugin, boolean cache) {
        this(MySQL.getFromConfig(plugin), cache);
    }

    public static MySQLSettings getFromConfig(JavaPlugin plugin) {
        FileConfiguration config = plugin.getConfig();
        return new MySQLSettings(config.getString("MySQL.host"), String.valueOf(config.getInt("MySQL.port")), config.getString("MySQL.database"), config.getString("MySQL.username"), config.getString("MySQL.password"));
    }

    public boolean connect(boolean broadcast) {
        try {
            this.connect(broadcast, this.mySQLSettings.getDatabase());
            return true;
        }
        catch (SQLException e) {
            EZMessage.text("%prefix% &cAn error has occurred while trying to connect to the MySQL/MariaDB server. Storage type has been defaulted to YAML!").console();
            e.printStackTrace();
            return false;
        }
    }

    public void connect(boolean broadcast, String database) throws SQLException {
        this.url = "jdbc:mysql://" + this.mySQLSettings.getHost() + ":" + this.mySQLSettings.getPort() + "/" + database + "?useUnicode=true&useJDBCCompliantTimezoneShift=true&useLegacyDatetimeCode=false&serverTimezone=UTC";
        this.connection = DriverManager.getConnection(this.url, this.mySQLSettings.getUsername(), this.mySQLSettings.getPassword());
        if (broadcast) {
            EZMessage.text("%prefix% &aSuccessfully connected to MySQL/MariaDB Server.").console();
        }
        this.createTableIfNotExists();
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(this.mySQLSettings.getDatabase());
    }

    public Connection getConnection(String database) throws SQLException {
        if (this.connection == null || !this.connection.isValid(5) || this.connection.isClosed()) {
            this.connect(false, database);
        }
        return this.connection;
    }

    public void createTableIfNotExists() {
        try {
            this.getConnection().createStatement().execute("CREATE TABLE IF NOT EXISTS `" + this.getTableName() + "` (`uuid` TEXT NOT NULL , `color` TEXT NULL);");
        }
        catch (SQLException e) {
            EZMessage.text("%prefix% &cSomething went wrong while trying to create the table!").console();
            e.printStackTrace();
        }
    }

    public boolean insertUser(UUID uuid) {
        try {
            PreparedStatement statement = this.getConnection().prepareStatement("INSERT INTO `" + this.getTableName() + "` (uuid, color) VALUES (?, NULL);");
            statement.setString(1, uuid.toString());
            boolean s = statement.execute();
            statement.close();
            return s;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void createUserIfNotExists(UUID uuid) {
        if (!this.userExists(uuid)) {
            this.insertUser(uuid);
        }
    }

    public boolean updateColor(UUID uuid, String color) {
        try {
            if (this.cache) {
                this.cacheMap.put(uuid, new ChatColorUser(uuid, color));
            }
            PreparedStatement statement = this.getConnection().prepareStatement("UPDATE `" + this.getTableName() + "` SET color= ? WHERE uuid= ?;");
            statement.setString(1, color);
            statement.setString(2, uuid.toString());
            boolean s = statement.execute();
            statement.close();
            return s;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public ChatColorUser getUser(UUID uuid, boolean create) {
        if (this.cache && this.cacheMap.containsKey(uuid)) {
            return this.cacheMap.get(uuid);
        }
        try {
            PreparedStatement statement = this.getConnection().prepareStatement("SELECT * from `" + this.getTableName() + "` WHERE uuid= ?;");
            statement.setString(1, uuid.toString());
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                ChatColorUser ccu = new ChatColorUser(uuid, rs.getString("color") == null || rs.getString("color").equalsIgnoreCase("NULL") ? null : rs.getString("color"));
                statement.close();
                if (this.cache) {
                    this.cacheMap.put(uuid, ccu);
                }
                return ccu;
            }
            if (create) {
                this.createUserIfNotExists(uuid);
                return this.getUser(uuid, false);
            }
            return null;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public HashMap<UUID, ChatColorUser> getAllUsers() {
        HashMap<UUID, ChatColorUser> users = new HashMap<UUID, ChatColorUser>();
        try {
            PreparedStatement statement = this.getConnection().prepareStatement("SELECT * from `" + this.getTableName() + "`;");
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                UUID uuid = UUID.fromString(rs.getString("uuid"));
                ChatColorUser ccu = new ChatColorUser(uuid, rs.getString("color") == null || rs.getString("color").equalsIgnoreCase("NULL") ? null : rs.getString("color"));
                users.put(uuid, ccu);
            }
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return users;
    }

    public boolean userExists(UUID uuid) {
        return this.getUser(uuid, false) != null;
    }

    public boolean hasConnected() {
        return this.connected;
    }

    public String getTableName() {
        return EZColors.getInstance().getConfig().getString("MySQL.table");
    }
}

