/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.guis;

import com.eazyftw.ezcolors.EZColors;
import com.eazyftw.ezcolors.color.EZMessage;
import com.eazyftw.ezcolors.gui.gui.GUI;
import com.eazyftw.ezcolors.gui.info.GUIInfo;
import com.eazyftw.ezcolors.guis.ChatColorGUI;
import com.eazyftw.ezcolors.guis.head.HeadEnum;
import com.eazyftw.ezcolors.language.T;
import com.eazyftw.ezcolors.storage.ChatColorUser;
import com.eazyftw.ezcolors.types.color.ChatColor;
import com.eazyftw.ezcolors.versions.XMaterial;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class RainbowColorGUI
extends GUI {
    private ChatColorUser user;
    private int update = 0;
    private String rainbow;
    private String rainbow2;
    private String rainbow3;

    public RainbowColorGUI(Player p) {
        super(p);
        this.user = EZColors.getStorage().getUser(p.getUniqueId());
        this.rainbow = ChatColor.createRainbowChatBold(T.t("RAINBOW_GUI_RAINBOW1_TITLE"));
        this.rainbow2 = ChatColor.createNiceRainbowChat(T.t("RAINBOW_GUI_RAINBOW2_TITLE"), false, true);
        this.rainbow3 = ChatColor.createRainbowChatHex(T.t("RAINBOW_GUI_RAINBOW3_TITLE"), false, true);
    }

    @Override
    protected void construct(GUIInfo info) {
        info.title(T.t("RAINBOW_GUI_TITLE"));
        info.rows(3);
        ++this.update;
        if (this.update > 20) {
            this.user = EZColors.getStorage().getUser(this.p.getUniqueId());
            this.rainbow = ChatColor.createRainbowChatBold(T.t("RAINBOW_GUI_RAINBOW1_TITLE"));
            this.rainbow2 = ChatColor.createNiceRainbowChat(T.t("RAINBOW_GUI_RAINBOW2_TITLE"), false, true);
            this.rainbow3 = ChatColor.createRainbowChatHex(T.t("RAINBOW_GUI_RAINBOW3_TITLE"), false, true);
            this.update = 0;
        }
        info.button(button -> {
            button.material(XMaterial.PLAYER_HEAD).setSkullTexture(HeadEnum.RAINBOW.getUrl()).name("&r" + this.rainbow).lores(T.tN("RAINBOW_GUI_RAINBOW1_LORE", "7"));
            button.action(action -> {
                EZMessage.text(this.getSelectedMsg(ChatColor.createNiceRainbowChat(T.t("COLOR_RAINBOW")))).player(this.p);
                this.user.setChatColor("Rainbow");
            });
        }, 1, 2);
        info.button(button -> {
            button.material(XMaterial.PLAYER_HEAD).setSkullTexture(HeadEnum.RAINBOW2.getUrl()).name("&r" + this.rainbow2).lores(T.tN("RAINBOW_GUI_RAINBOW2_LORE", "7"));
            button.action(action -> {
                EZMessage.text(this.getSelectedMsg(ChatColor.createNiceRainbowChat(T.t("COLOR_CLEAN_RAINBOW")))).player(this.p);
                this.user.setChatColor("Rainbow2");
            });
        }, 1, 6);
        info.button(button -> {
            button.material(XMaterial.PLAYER_HEAD).setSkullTexture(HeadEnum.RAINBOW3.getUrl()).name("&r" + this.rainbow3).lores(T.tN("RAINBOW_GUI_RAINBOW3_LORE", "7"));
            button.action(action -> {
                EZMessage.text(this.getSelectedMsg(ChatColor.createNiceRainbowChat(T.t("COLOR_HEX_RAINBOW")))).player(this.p);
                this.user.setChatColor("Rainbow3");
            });
        }, 1, 4);
    }

    @Override
    public void onClose(Inventory inventory) {
        new ChatColorGUI(this.p);
    }

    public String getSelectedMsg(String color) {
        return T.t("COLOR_SELECTED").replaceAll("(?i)\\{color}", color);
    }

    public String getSelectedGUIMsg(String color) {
        return T.t("GUI_SET_COLOR").replaceAll("(?i)\\{color}", color);
    }
}

