/*
 * Decompiled with CFR 0.152.
 */
package com.eazyftw.ezcolors.guis;

import com.eazyftw.ezcolors.EZColors;
import com.eazyftw.ezcolors.animations.Animation;
import com.eazyftw.ezcolors.color.EZMessage;
import com.eazyftw.ezcolors.gui.button.Button;
import com.eazyftw.ezcolors.gui.gui.PageableSmallGUI;
import com.eazyftw.ezcolors.gui.info.PageableSmallGUIInfo;
import com.eazyftw.ezcolors.gui.sort.SearchCheck;
import com.eazyftw.ezcolors.gui.sort.Sort;
import com.eazyftw.ezcolors.guis.ChatColorGUI;
import com.eazyftw.ezcolors.language.Language;
import com.eazyftw.ezcolors.language.T;
import com.eazyftw.ezcolors.languages.OnlineLanguagesManager;
import com.eazyftw.ezcolors.versions.XMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class LanguagesGUI
extends PageableSmallGUI<Language> {
    private final boolean back;

    public LanguagesGUI(Player p, boolean back) {
        super(p);
        this.back = back;
    }

    @Override
    protected void construct(PageableSmallGUIInfo<Language> info) {
        info.title(EZMessage.text(T.t("GUI_LANGUAGE_TITLE")).colored());
        if (this.back) {
            info.back(() -> new ChatColorGUI(this.p));
        }
        Sort<Language> sortAZ = new Sort<Language>("Alphabetical", "&aA-Z", "Sorts alphabetically from A to Z.", Comparator.comparing(Language::getName));
        Sort<Language> sortZA = new Sort<Language>("Reverse Alphabetical", "&aZ-A", "Sorts from Z to A.", Comparator.comparing(Language::getName).reversed());
        this.sort(new ArrayList(Arrays.asList(sortAZ, sortZA)));
        info.objects(T.getLanguageManager().getLanguages());
        info.searchCheck(new SearchCheck<Language>(){

            @Override
            public String[] getSearchableText(Language language) {
                return new String[]{language.getName(), language.getShortName()};
            }
        });
        info.button(this::refreshLanguages, 5, 4);
    }

    public void refreshLanguages(Button button) {
        button.material(XMaterial.SLIME_BALL).name(Animation.flashing("&b&l", 30, "&f&l", 10, T.t("GUI_LANGUAGE_LANGUAGE_REFRESH_TITLE"))).lores(T.tN("GUI_LANGUAGE_LANGUAGE_REFRESH_DESC", "f"));
        button.action(actionType -> {
            boolean success = OnlineLanguagesManager.getLanguagesAndDownload();
            if (!success) {
                EZMessage.text("%prefix% &cFailed to download languages online. Fetching local languages! (These may be outdated)").console();
                EZColors.saveAllLocales(true, "en", "uken", "de", "es", "it", "zh", "nl", "sr", "id", "th");
            }
            T.getLanguageManager().checkLanguages();
            EZMessage.text(T.t("GUI_LANGUAGE_LANGUAGE_REFRESH_MSG")).player(this.p);
        });
    }

    @Override
    protected void button(Button button, Language lang) {
        if (T.getLanguageManager().getLanguage().equalsIgnoreCase(lang.getShortName())) {
            button.material(XMaterial.FILLED_MAP).name("&b&l" + lang.getName() + " &8(&f" + lang.getConfigName() + "&8)").loreLine("&f" + T.t("GUI_LANGUAGE_LANGUAGE_ENABLED_DESC").replace("{Language}", lang.getName()));
        } else {
            button.material(XMaterial.MAP).name("&b&l" + lang.getName() + " &8(&f" + lang.getConfigName() + "&8)").loreLine("&f" + T.t("GUI_LANGUAGE_LANGUAGE_DISABLED_DESC").replace("{Language}", lang.getName()));
            button.action(actionType -> {
                if (lang.isFinished()) {
                    T.getLanguageManager().setLanguage(lang.getShortName());
                } else {
                    EZMessage.text(T.t("GUI_LANGUAGE_LANGUAGE_NOT_FINISHED_MSG")).player(this.p);
                }
            });
        }
    }

    @Override
    public void onClose(Inventory inventory) {
        new ChatColorGUI(this.p);
    }
}

